/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.OrchestratorVersionProfile;
import java.io.IOException;
import java.util.List;

public final class OrchestratorVersionProfileProperties
implements JsonSerializable<OrchestratorVersionProfileProperties> {
    private List<OrchestratorVersionProfile> orchestrators;
    private static final ClientLogger LOGGER = new ClientLogger(OrchestratorVersionProfileProperties.class);

    public List<OrchestratorVersionProfile> orchestrators() {
        return this.orchestrators;
    }

    public OrchestratorVersionProfileProperties withOrchestrators(List<OrchestratorVersionProfile> orchestrators) {
        this.orchestrators = orchestrators;
        return this;
    }

    public void validate() {
        if (this.orchestrators() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property orchestrators in model OrchestratorVersionProfileProperties"));
        }
        this.orchestrators().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("orchestrators", this.orchestrators, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static OrchestratorVersionProfileProperties fromJson(JsonReader jsonReader) throws IOException {
        return (OrchestratorVersionProfileProperties)jsonReader.readObject(reader -> {
            OrchestratorVersionProfileProperties deserializedOrchestratorVersionProfileProperties = new OrchestratorVersionProfileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("orchestrators".equals(fieldName)) {
                    List orchestrators;
                    deserializedOrchestratorVersionProfileProperties.orchestrators = orchestrators = reader.readArray(reader1 -> OrchestratorVersionProfile.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOrchestratorVersionProfileProperties;
        });
    }
}

