/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.implementation;

import com.azure.resourcemanager.containerservice.fluent.models.ManagedClusterInner;
import com.azure.resourcemanager.containerservice.implementation.KubernetesClusterImpl;
import com.azure.resourcemanager.containerservice.models.ContainerServiceNetworkProfile;
import com.azure.resourcemanager.containerservice.models.KubernetesCluster;
import com.azure.resourcemanager.containerservice.models.LoadBalancerSku;
import com.azure.resourcemanager.containerservice.models.NetworkDataplane;
import com.azure.resourcemanager.containerservice.models.NetworkMode;
import com.azure.resourcemanager.containerservice.models.NetworkPlugin;
import com.azure.resourcemanager.containerservice.models.NetworkPluginMode;
import com.azure.resourcemanager.containerservice.models.NetworkPolicy;

public class KubernetesClusterNetworkProfileImpl
implements KubernetesCluster.DefinitionStages.NetworkProfileDefinition<KubernetesCluster.DefinitionStages.WithCreate> {
    KubernetesClusterImpl parentKubernetesCluster;

    KubernetesClusterNetworkProfileImpl(KubernetesClusterImpl parent) {
        this.parentKubernetesCluster = parent;
    }

    public KubernetesClusterNetworkProfileImpl withNetworkPlugin(NetworkPlugin networkPlugin) {
        this.ensureNetworkProfile().withNetworkPlugin(networkPlugin);
        return this;
    }

    public KubernetesClusterNetworkProfileImpl withNetworkPolicy(NetworkPolicy networkPolicy) {
        this.ensureNetworkProfile().withNetworkPolicy(networkPolicy);
        return this;
    }

    public KubernetesClusterNetworkProfileImpl withPodCidr(String podCidr) {
        this.ensureNetworkProfile().withPodCidr(podCidr);
        return this;
    }

    public KubernetesClusterNetworkProfileImpl withServiceCidr(String serviceCidr) {
        this.ensureNetworkProfile().withServiceCidr(serviceCidr);
        return this;
    }

    public KubernetesClusterNetworkProfileImpl withDnsServiceIP(String dnsServiceIP) {
        this.ensureNetworkProfile().withDnsServiceIp(dnsServiceIP);
        return this;
    }

    @Deprecated
    public KubernetesClusterNetworkProfileImpl withDockerBridgeCidr(String dockerBridgeCidr) {
        return this;
    }

    public KubernetesClusterNetworkProfileImpl withLoadBalancerSku(LoadBalancerSku loadBalancerSku) {
        this.ensureNetworkProfile().withLoadBalancerSku(loadBalancerSku);
        return this;
    }

    public KubernetesClusterImpl attach() {
        return this.parentKubernetesCluster;
    }

    private ContainerServiceNetworkProfile ensureNetworkProfile() {
        if (((ManagedClusterInner)((Object)this.parentKubernetesCluster.innerModel())).networkProfile() == null) {
            ((ManagedClusterInner)((Object)this.parentKubernetesCluster.innerModel())).withNetworkProfile(new ContainerServiceNetworkProfile());
        }
        return ((ManagedClusterInner)((Object)this.parentKubernetesCluster.innerModel())).networkProfile();
    }

    public KubernetesClusterNetworkProfileImpl withNetworkPluginMode(NetworkPluginMode networkPluginMode) {
        this.ensureNetworkProfile().withNetworkPluginMode(networkPluginMode);
        return this;
    }

    public KubernetesClusterNetworkProfileImpl withNetworkMode(NetworkMode networkMode) {
        this.ensureNetworkProfile().withNetworkMode(networkMode);
        return this;
    }

    public KubernetesClusterNetworkProfileImpl withNetworkDataPlan(NetworkDataplane networkDataPlan) {
        this.ensureNetworkProfile().withNetworkDataplane(networkDataPlan);
        return this;
    }
}

