/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.OSType;
import com.azure.resourcemanager.containerservice.models.OpenShiftContainerServiceVMSize;
import java.io.IOException;

public final class OpenShiftManagedClusterMasterPoolProfile
implements JsonSerializable<OpenShiftManagedClusterMasterPoolProfile> {
    private String name;
    private int count;
    private OpenShiftContainerServiceVMSize vmSize;
    private String subnetCidr;
    private OSType osType;
    private static final ClientLogger LOGGER = new ClientLogger(OpenShiftManagedClusterMasterPoolProfile.class);

    public String name() {
        return this.name;
    }

    public OpenShiftManagedClusterMasterPoolProfile withName(String name) {
        this.name = name;
        return this;
    }

    public int count() {
        return this.count;
    }

    public OpenShiftManagedClusterMasterPoolProfile withCount(int count) {
        this.count = count;
        return this;
    }

    public OpenShiftContainerServiceVMSize vmSize() {
        return this.vmSize;
    }

    public OpenShiftManagedClusterMasterPoolProfile withVmSize(OpenShiftContainerServiceVMSize vmSize) {
        this.vmSize = vmSize;
        return this;
    }

    public String subnetCidr() {
        return this.subnetCidr;
    }

    public OpenShiftManagedClusterMasterPoolProfile withSubnetCidr(String subnetCidr) {
        this.subnetCidr = subnetCidr;
        return this;
    }

    public OSType osType() {
        return this.osType;
    }

    public OpenShiftManagedClusterMasterPoolProfile withOsType(OSType osType) {
        this.osType = osType;
        return this;
    }

    public void validate() {
        if (this.vmSize() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property vmSize in model OpenShiftManagedClusterMasterPoolProfile"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("count", this.count);
        jsonWriter.writeStringField("vmSize", this.vmSize == null ? null : this.vmSize.toString());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("subnetCidr", this.subnetCidr);
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        return jsonWriter.writeEndObject();
    }

    public static OpenShiftManagedClusterMasterPoolProfile fromJson(JsonReader jsonReader) throws IOException {
        return (OpenShiftManagedClusterMasterPoolProfile)jsonReader.readObject(reader -> {
            OpenShiftManagedClusterMasterPoolProfile deserializedOpenShiftManagedClusterMasterPoolProfile = new OpenShiftManagedClusterMasterPoolProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("count".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterMasterPoolProfile.count = reader.getInt();
                    continue;
                }
                if ("vmSize".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterMasterPoolProfile.vmSize = OpenShiftContainerServiceVMSize.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterMasterPoolProfile.name = reader.getString();
                    continue;
                }
                if ("subnetCidr".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterMasterPoolProfile.subnetCidr = reader.getString();
                    continue;
                }
                if ("osType".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterMasterPoolProfile.osType = OSType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOpenShiftManagedClusterMasterPoolProfile;
        });
    }
}

