/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class IstioEgressGateway
implements JsonSerializable<IstioEgressGateway> {
    private boolean enabled;
    private String name;
    private String namespace;
    private String gatewayConfigurationName;
    private static final ClientLogger LOGGER = new ClientLogger(IstioEgressGateway.class);

    public boolean enabled() {
        return this.enabled;
    }

    public IstioEgressGateway withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String name() {
        return this.name;
    }

    public IstioEgressGateway withName(String name) {
        this.name = name;
        return this;
    }

    public String namespace() {
        return this.namespace;
    }

    public IstioEgressGateway withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public String gatewayConfigurationName() {
        return this.gatewayConfigurationName;
    }

    public IstioEgressGateway withGatewayConfigurationName(String gatewayConfigurationName) {
        this.gatewayConfigurationName = gatewayConfigurationName;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model IstioEgressGateway"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("namespace", this.namespace);
        jsonWriter.writeStringField("gatewayConfigurationName", this.gatewayConfigurationName);
        return jsonWriter.writeEndObject();
    }

    public static IstioEgressGateway fromJson(JsonReader jsonReader) throws IOException {
        return (IstioEgressGateway)jsonReader.readObject(reader -> {
            IstioEgressGateway deserializedIstioEgressGateway = new IstioEgressGateway();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedIstioEgressGateway.enabled = reader.getBoolean();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedIstioEgressGateway.name = reader.getString();
                    continue;
                }
                if ("namespace".equals(fieldName)) {
                    deserializedIstioEgressGateway.namespace = reader.getString();
                    continue;
                }
                if ("gatewayConfigurationName".equals(fieldName)) {
                    deserializedIstioEgressGateway.gatewayConfigurationName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIstioEgressGateway;
        });
    }
}

