/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.IstioServiceMesh;
import com.azure.resourcemanager.containerservice.models.ServiceMeshMode;
import java.io.IOException;

public final class ServiceMeshProfile
implements JsonSerializable<ServiceMeshProfile> {
    private ServiceMeshMode mode;
    private IstioServiceMesh istio;
    private static final ClientLogger LOGGER = new ClientLogger(ServiceMeshProfile.class);

    public ServiceMeshMode mode() {
        return this.mode;
    }

    public ServiceMeshProfile withMode(ServiceMeshMode mode) {
        this.mode = mode;
        return this;
    }

    public IstioServiceMesh istio() {
        return this.istio;
    }

    public ServiceMeshProfile withIstio(IstioServiceMesh istio) {
        this.istio = istio;
        return this;
    }

    public void validate() {
        if (this.mode() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property mode in model ServiceMeshProfile"));
        }
        if (this.istio() != null) {
            this.istio().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeJsonField("istio", (JsonSerializable)this.istio);
        return jsonWriter.writeEndObject();
    }

    public static ServiceMeshProfile fromJson(JsonReader jsonReader) throws IOException {
        return (ServiceMeshProfile)jsonReader.readObject(reader -> {
            ServiceMeshProfile deserializedServiceMeshProfile = new ServiceMeshProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("mode".equals(fieldName)) {
                    deserializedServiceMeshProfile.mode = ServiceMeshMode.fromString(reader.getString());
                    continue;
                }
                if ("istio".equals(fieldName)) {
                    deserializedServiceMeshProfile.istio = IstioServiceMesh.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServiceMeshProfile;
        });
    }
}

