/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.implementation;

import com.azure.resourcemanager.containerservice.fluent.models.AgentPoolInner;
import com.azure.resourcemanager.containerservice.implementation.KubernetesClusterImpl;
import com.azure.resourcemanager.containerservice.models.AgentPoolMode;
import com.azure.resourcemanager.containerservice.models.AgentPoolType;
import com.azure.resourcemanager.containerservice.models.ContainerServiceVMSizeTypes;
import com.azure.resourcemanager.containerservice.models.KubernetesCluster;
import com.azure.resourcemanager.containerservice.models.KubernetesClusterAgentPool;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAgentPoolProfile;
import com.azure.resourcemanager.containerservice.models.OSType;
import com.azure.resourcemanager.containerservice.models.PowerState;
import com.azure.resourcemanager.containerservice.models.ScaleSetEvictionPolicy;
import com.azure.resourcemanager.containerservice.models.ScaleSetPriority;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class KubernetesClusterAgentPoolImpl
extends ChildResourceImpl<ManagedClusterAgentPoolProfile, KubernetesClusterImpl, KubernetesCluster>
implements KubernetesClusterAgentPool,
KubernetesClusterAgentPool.Definition<KubernetesClusterImpl>,
KubernetesClusterAgentPool.Update<KubernetesClusterImpl> {
    private String subnetName;

    KubernetesClusterAgentPoolImpl(ManagedClusterAgentPoolProfile inner, KubernetesClusterImpl parent) {
        super((Object)inner, (Object)parent);
        String subnetId = inner != null ? ((ManagedClusterAgentPoolProfile)this.innerModel()).vnetSubnetId() : null;
        this.subnetName = ResourceUtils.nameFromResourceId((String)subnetId);
    }

    public String name() {
        return ((ManagedClusterAgentPoolProfile)this.innerModel()).name();
    }

    @Override
    public int count() {
        return ((ManagedClusterAgentPoolProfile)this.innerModel()).count();
    }

    @Override
    public ContainerServiceVMSizeTypes vmSize() {
        return ContainerServiceVMSizeTypes.fromString(((ManagedClusterAgentPoolProfile)this.innerModel()).vmSize());
    }

    @Override
    public int osDiskSizeInGB() {
        return ((ManagedClusterAgentPoolProfile)this.innerModel()).osDiskSizeGB();
    }

    @Override
    public OSType osType() {
        return ((ManagedClusterAgentPoolProfile)this.innerModel()).osType();
    }

    @Override
    public AgentPoolType type() {
        return ((ManagedClusterAgentPoolProfile)this.innerModel()).type();
    }

    @Override
    public AgentPoolMode mode() {
        return ((ManagedClusterAgentPoolProfile)this.innerModel()).mode();
    }

    @Override
    public String subnetName() {
        if (this.subnetName != null) {
            return this.subnetName;
        }
        return ResourceUtils.nameFromResourceId((String)((ManagedClusterAgentPoolProfile)this.innerModel()).vnetSubnetId());
    }

    @Override
    public String networkId() {
        String subnetId = this.innerModel() != null ? ((ManagedClusterAgentPoolProfile)this.innerModel()).vnetSubnetId() : null;
        return subnetId != null ? ResourceUtils.parentResourceIdFromResourceId((String)subnetId) : null;
    }

    @Override
    public List<String> availabilityZones() {
        return ((ManagedClusterAgentPoolProfile)this.innerModel()).availabilityZones();
    }

    @Override
    public Map<String, String> nodeLabels() {
        return ((ManagedClusterAgentPoolProfile)this.innerModel()).nodeLabels() == null ? null : Collections.unmodifiableMap(((ManagedClusterAgentPoolProfile)this.innerModel()).nodeLabels());
    }

    @Override
    public List<String> nodeTaints() {
        return ((ManagedClusterAgentPoolProfile)this.innerModel()).nodeTaints() == null ? null : Collections.unmodifiableList(((ManagedClusterAgentPoolProfile)this.innerModel()).nodeTaints());
    }

    @Override
    public PowerState powerState() {
        return ((ManagedClusterAgentPoolProfile)this.innerModel()).powerState();
    }

    @Override
    public boolean isAutoScalingEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((ManagedClusterAgentPoolProfile)this.innerModel()).enableAutoScaling());
    }

    @Override
    public int nodeSize() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((ManagedClusterAgentPoolProfile)this.innerModel()).count());
    }

    @Override
    public int maximumPodsPerNode() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((ManagedClusterAgentPoolProfile)this.innerModel()).maxPods());
    }

    @Override
    public int minimumNodeSize() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((ManagedClusterAgentPoolProfile)this.innerModel()).minCount());
    }

    @Override
    public int maximumNodeSize() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((ManagedClusterAgentPoolProfile)this.innerModel()).maxCount());
    }

    @Override
    public ScaleSetPriority virtualMachinePriority() {
        return ((ManagedClusterAgentPoolProfile)this.innerModel()).scaleSetPriority();
    }

    @Override
    public ScaleSetEvictionPolicy virtualMachineEvictionPolicy() {
        return ((ManagedClusterAgentPoolProfile)this.innerModel()).scaleSetEvictionPolicy();
    }

    @Override
    public Double virtualMachineMaximumPrice() {
        return ((ManagedClusterAgentPoolProfile)this.innerModel()).spotMaxPrice().doubleValue();
    }

    public KubernetesClusterAgentPoolImpl withVirtualMachineSize(ContainerServiceVMSizeTypes vmSize) {
        ((ManagedClusterAgentPoolProfile)this.innerModel()).withVmSize(vmSize.toString());
        return this;
    }

    public KubernetesClusterAgentPoolImpl withOSType(OSType osType) {
        ((ManagedClusterAgentPoolProfile)this.innerModel()).withOsType(osType);
        return this;
    }

    public KubernetesClusterAgentPoolImpl withOSDiskSizeInGB(int osDiskSizeInGB) {
        ((ManagedClusterAgentPoolProfile)this.innerModel()).withOsDiskSizeGB(osDiskSizeInGB);
        return this;
    }

    public KubernetesClusterAgentPoolImpl withAgentPoolType(AgentPoolType agentPoolType) {
        ((ManagedClusterAgentPoolProfile)this.innerModel()).withType(agentPoolType);
        return this;
    }

    public KubernetesClusterAgentPoolImpl withAgentPoolTypeName(String agentPoolTypeName) {
        ((ManagedClusterAgentPoolProfile)this.innerModel()).withType(AgentPoolType.fromString(agentPoolTypeName));
        return this;
    }

    public KubernetesClusterAgentPoolImpl withAgentPoolVirtualMachineCount(int count) {
        ((ManagedClusterAgentPoolProfile)this.innerModel()).withCount(count);
        return this;
    }

    public KubernetesClusterAgentPoolImpl withMaxPodsCount(int podsCount) {
        ((ManagedClusterAgentPoolProfile)this.innerModel()).withMaxPods(podsCount);
        return this;
    }

    public KubernetesClusterAgentPoolImpl withVirtualNetwork(String virtualNetworkId, String subnetName) {
        String vnetSubnetId = virtualNetworkId + "/subnets/" + subnetName;
        this.subnetName = subnetName;
        ((ManagedClusterAgentPoolProfile)this.innerModel()).withVnetSubnetId(vnetSubnetId);
        return this;
    }

    public KubernetesClusterImpl attach() {
        return ((KubernetesClusterImpl)this.parent()).addNewAgentPool(this);
    }

    public AgentPoolInner getAgentPoolInner() {
        AgentPoolInner agentPoolInner = new AgentPoolInner();
        agentPoolInner.withCount(((ManagedClusterAgentPoolProfile)this.innerModel()).count());
        agentPoolInner.withVmSize(((ManagedClusterAgentPoolProfile)this.innerModel()).vmSize());
        agentPoolInner.withOsDiskSizeGB(((ManagedClusterAgentPoolProfile)this.innerModel()).osDiskSizeGB());
        agentPoolInner.withVnetSubnetId(((ManagedClusterAgentPoolProfile)this.innerModel()).vnetSubnetId());
        agentPoolInner.withMaxPods(((ManagedClusterAgentPoolProfile)this.innerModel()).maxPods());
        agentPoolInner.withOsType(((ManagedClusterAgentPoolProfile)this.innerModel()).osType());
        agentPoolInner.withMaxCount(((ManagedClusterAgentPoolProfile)this.innerModel()).maxCount());
        agentPoolInner.withMinCount(((ManagedClusterAgentPoolProfile)this.innerModel()).minCount());
        agentPoolInner.withEnableAutoScaling(((ManagedClusterAgentPoolProfile)this.innerModel()).enableAutoScaling());
        agentPoolInner.withTypePropertiesType(((ManagedClusterAgentPoolProfile)this.innerModel()).type());
        agentPoolInner.withMode(((ManagedClusterAgentPoolProfile)this.innerModel()).mode());
        agentPoolInner.withOrchestratorVersion(((ManagedClusterAgentPoolProfile)this.innerModel()).orchestratorVersion());
        agentPoolInner.withUpgradeSettings(((ManagedClusterAgentPoolProfile)this.innerModel()).upgradeSettings());
        agentPoolInner.withAvailabilityZones(((ManagedClusterAgentPoolProfile)this.innerModel()).availabilityZones());
        agentPoolInner.withEnableNodePublicIp(((ManagedClusterAgentPoolProfile)this.innerModel()).enableNodePublicIp());
        agentPoolInner.withScaleSetPriority(((ManagedClusterAgentPoolProfile)this.innerModel()).scaleSetPriority());
        agentPoolInner.withScaleSetEvictionPolicy(((ManagedClusterAgentPoolProfile)this.innerModel()).scaleSetEvictionPolicy());
        agentPoolInner.withSpotMaxPrice(((ManagedClusterAgentPoolProfile)this.innerModel()).spotMaxPrice());
        agentPoolInner.withTags(((ManagedClusterAgentPoolProfile)this.innerModel()).tags());
        agentPoolInner.withNodeLabels(((ManagedClusterAgentPoolProfile)this.innerModel()).nodeLabels());
        agentPoolInner.withNodeTaints(((ManagedClusterAgentPoolProfile)this.innerModel()).nodeTaints());
        agentPoolInner.withProximityPlacementGroupId(((ManagedClusterAgentPoolProfile)this.innerModel()).proximityPlacementGroupId());
        agentPoolInner.withKubeletConfig(((ManagedClusterAgentPoolProfile)this.innerModel()).kubeletConfig());
        agentPoolInner.withLinuxOSConfig(((ManagedClusterAgentPoolProfile)this.innerModel()).linuxOSConfig());
        agentPoolInner.withEnableEncryptionAtHost(((ManagedClusterAgentPoolProfile)this.innerModel()).enableEncryptionAtHost());
        agentPoolInner.withEnableUltraSsd(((ManagedClusterAgentPoolProfile)this.innerModel()).enableUltraSsd());
        agentPoolInner.withEnableFips(((ManagedClusterAgentPoolProfile)this.innerModel()).enableFips());
        agentPoolInner.withGpuInstanceProfile(((ManagedClusterAgentPoolProfile)this.innerModel()).gpuInstanceProfile());
        return agentPoolInner;
    }

    public KubernetesClusterAgentPoolImpl withAgentPoolMode(AgentPoolMode agentPoolMode) {
        ((ManagedClusterAgentPoolProfile)this.innerModel()).withMode(agentPoolMode);
        return this;
    }

    public KubernetesClusterAgentPoolImpl withAutoScaling(int minimumNodeSize, int maximumNodeSize) {
        ((ManagedClusterAgentPoolProfile)this.innerModel()).withEnableAutoScaling(true);
        ((ManagedClusterAgentPoolProfile)this.innerModel()).withMinCount(minimumNodeSize);
        ((ManagedClusterAgentPoolProfile)this.innerModel()).withMaxCount(maximumNodeSize);
        return this;
    }

    @Override
    public KubernetesClusterAgentPool.Update<KubernetesClusterImpl> withoutAutoScaling() {
        ((ManagedClusterAgentPoolProfile)this.innerModel()).withEnableAutoScaling(false);
        ((ManagedClusterAgentPoolProfile)this.innerModel()).withMinCount(null);
        ((ManagedClusterAgentPoolProfile)this.innerModel()).withMaxCount(null);
        return this;
    }

    public KubernetesClusterAgentPoolImpl withAvailabilityZones(Integer ... zones) {
        ((ManagedClusterAgentPoolProfile)this.innerModel()).withAvailabilityZones(Arrays.stream(zones).map(String::valueOf).collect(Collectors.toList()));
        return this;
    }

    public KubernetesClusterAgentPoolImpl withNodeLabels(Map<String, String> nodeLabels) {
        ((ManagedClusterAgentPoolProfile)this.innerModel()).withNodeLabels(nodeLabels == null ? null : new TreeMap<String, String>(nodeLabels));
        return this;
    }

    public KubernetesClusterAgentPoolImpl withNodeTaints(List<String> nodeTaints) {
        ((ManagedClusterAgentPoolProfile)this.innerModel()).withNodeTaints((List)nodeTaints);
        return this;
    }

    public KubernetesClusterAgentPoolImpl withVirtualMachinePriority(ScaleSetPriority priority) {
        ((ManagedClusterAgentPoolProfile)this.innerModel()).withScaleSetPriority(priority);
        return this;
    }

    public KubernetesClusterAgentPoolImpl withSpotPriorityVirtualMachine() {
        ((ManagedClusterAgentPoolProfile)this.innerModel()).withScaleSetPriority(ScaleSetPriority.SPOT);
        return this;
    }

    public KubernetesClusterAgentPoolImpl withSpotPriorityVirtualMachine(ScaleSetEvictionPolicy policy) {
        ((ManagedClusterAgentPoolProfile)this.innerModel()).withScaleSetPriority(ScaleSetPriority.SPOT);
        ((ManagedClusterAgentPoolProfile)this.innerModel()).withScaleSetEvictionPolicy(policy);
        return this;
    }

    public KubernetesClusterAgentPoolImpl withVirtualMachineMaximumPrice(Double maxPriceInUsDollars) {
        ((ManagedClusterAgentPoolProfile)this.innerModel()).withSpotMaxPrice(Float.valueOf(maxPriceInUsDollars.floatValue()));
        return this;
    }
}

