/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.containerservice.fluent.OpenShiftManagedClustersClient;
import com.azure.resourcemanager.containerservice.fluent.models.OpenShiftManagedClusterInner;
import com.azure.resourcemanager.containerservice.implementation.ContainerServiceManagementClientImpl;
import com.azure.resourcemanager.containerservice.models.OpenShiftManagedClusterListResult;
import com.azure.resourcemanager.containerservice.models.TagsObject;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class OpenShiftManagedClustersClientImpl
implements InnerSupportsGet<OpenShiftManagedClusterInner>,
InnerSupportsListing<OpenShiftManagedClusterInner>,
InnerSupportsDelete<Void>,
OpenShiftManagedClustersClient {
    private final ClientLogger logger = new ClientLogger(OpenShiftManagedClustersClientImpl.class);
    private final OpenShiftManagedClustersService service;
    private final ContainerServiceManagementClientImpl client;

    OpenShiftManagedClustersClientImpl(ContainerServiceManagementClientImpl client) {
        this.service = (OpenShiftManagedClustersService)RestProxy.create(OpenShiftManagedClustersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OpenShiftManagedClusterInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-04-30";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2019-04-30", this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OpenShiftManagedClusterListResult)res.getValue()).value(), ((OpenShiftManagedClusterListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OpenShiftManagedClusterInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-04-30";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2019-04-30", this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OpenShiftManagedClusterListResult)res.getValue()).value(), ((OpenShiftManagedClusterListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<OpenShiftManagedClusterInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<OpenShiftManagedClusterInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OpenShiftManagedClusterInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OpenShiftManagedClusterInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OpenShiftManagedClusterInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2019-04-30";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), "2019-04-30", this.client.getSubscriptionId(), resourceGroupName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OpenShiftManagedClusterListResult)res.getValue()).value(), ((OpenShiftManagedClusterListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OpenShiftManagedClusterInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2019-04-30";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), "2019-04-30", this.client.getSubscriptionId(), resourceGroupName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OpenShiftManagedClusterListResult)res.getValue()).value(), ((OpenShiftManagedClusterListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<OpenShiftManagedClusterInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<OpenShiftManagedClusterInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, context), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OpenShiftManagedClusterInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OpenShiftManagedClusterInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<OpenShiftManagedClusterInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2019-04-30";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), "2019-04-30", this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<OpenShiftManagedClusterInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2019-04-30";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), "2019-04-30", this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OpenShiftManagedClusterInner> getByResourceGroupAsync(String resourceGroupName, String resourceName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, resourceName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((OpenShiftManagedClusterInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OpenShiftManagedClusterInner getByResourceGroup(String resourceGroupName, String resourceName) {
        return (OpenShiftManagedClusterInner)((Object)this.getByResourceGroupAsync(resourceGroupName, resourceName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<OpenShiftManagedClusterInner> getByResourceGroupWithResponse(String resourceGroupName, String resourceName, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, resourceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2019-04-30";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), "2019-04-30", this.client.getSubscriptionId(), resourceGroupName, resourceName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2019-04-30";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), "2019-04-30", this.client.getSubscriptionId(), resourceGroupName, resourceName, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<OpenShiftManagedClusterInner>, OpenShiftManagedClusterInner> beginCreateOrUpdateAsync(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, resourceName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)OpenShiftManagedClusterInner.class), (Type)((Object)OpenShiftManagedClusterInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<OpenShiftManagedClusterInner>, OpenShiftManagedClusterInner> beginCreateOrUpdateAsync(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, resourceName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)OpenShiftManagedClusterInner.class), (Type)((Object)OpenShiftManagedClusterInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<OpenShiftManagedClusterInner>, OpenShiftManagedClusterInner> beginCreateOrUpdate(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, resourceName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<OpenShiftManagedClusterInner>, OpenShiftManagedClusterInner> beginCreateOrUpdate(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, resourceName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OpenShiftManagedClusterInner> createOrUpdateAsync(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, resourceName, parameters).last().flatMap(arg_0 -> ((ContainerServiceManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OpenShiftManagedClusterInner> createOrUpdateAsync(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, resourceName, parameters, context).last().flatMap(arg_0 -> ((ContainerServiceManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OpenShiftManagedClusterInner createOrUpdate(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters) {
        return (OpenShiftManagedClusterInner)((Object)this.createOrUpdateAsync(resourceGroupName, resourceName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OpenShiftManagedClusterInner createOrUpdate(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters, Context context) {
        return (OpenShiftManagedClusterInner)((Object)this.createOrUpdateAsync(resourceGroupName, resourceName, parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateTagsWithResponseAsync(String resourceGroupName, String resourceName, TagsObject parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2019-04-30";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateTags(this.client.getEndpoint(), "2019-04-30", this.client.getSubscriptionId(), resourceGroupName, resourceName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateTagsWithResponseAsync(String resourceGroupName, String resourceName, TagsObject parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2019-04-30";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateTags(this.client.getEndpoint(), "2019-04-30", this.client.getSubscriptionId(), resourceGroupName, resourceName, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<OpenShiftManagedClusterInner>, OpenShiftManagedClusterInner> beginUpdateTagsAsync(String resourceGroupName, String resourceName, TagsObject parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateTagsWithResponseAsync(resourceGroupName, resourceName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)OpenShiftManagedClusterInner.class), (Type)((Object)OpenShiftManagedClusterInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<OpenShiftManagedClusterInner>, OpenShiftManagedClusterInner> beginUpdateTagsAsync(String resourceGroupName, String resourceName, TagsObject parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateTagsWithResponseAsync(resourceGroupName, resourceName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)OpenShiftManagedClusterInner.class), (Type)((Object)OpenShiftManagedClusterInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<OpenShiftManagedClusterInner>, OpenShiftManagedClusterInner> beginUpdateTags(String resourceGroupName, String resourceName, TagsObject parameters) {
        return this.beginUpdateTagsAsync(resourceGroupName, resourceName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<OpenShiftManagedClusterInner>, OpenShiftManagedClusterInner> beginUpdateTags(String resourceGroupName, String resourceName, TagsObject parameters, Context context) {
        return this.beginUpdateTagsAsync(resourceGroupName, resourceName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OpenShiftManagedClusterInner> updateTagsAsync(String resourceGroupName, String resourceName, TagsObject parameters) {
        return this.beginUpdateTagsAsync(resourceGroupName, resourceName, parameters).last().flatMap(arg_0 -> ((ContainerServiceManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OpenShiftManagedClusterInner> updateTagsAsync(String resourceGroupName, String resourceName, TagsObject parameters, Context context) {
        return this.beginUpdateTagsAsync(resourceGroupName, resourceName, parameters, context).last().flatMap(arg_0 -> ((ContainerServiceManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OpenShiftManagedClusterInner updateTags(String resourceGroupName, String resourceName, TagsObject parameters) {
        return (OpenShiftManagedClusterInner)((Object)this.updateTagsAsync(resourceGroupName, resourceName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OpenShiftManagedClusterInner updateTags(String resourceGroupName, String resourceName, TagsObject parameters, Context context) {
        return (OpenShiftManagedClusterInner)((Object)this.updateTagsAsync(resourceGroupName, resourceName, parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2019-04-30";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2019-04-30", this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2019-04-30";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2019-04-30", this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String resourceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, resourceName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String resourceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, resourceName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String resourceName) {
        return this.beginDeleteAsync(resourceGroupName, resourceName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String resourceName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, resourceName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String resourceName) {
        return this.beginDeleteAsync(resourceGroupName, resourceName).last().flatMap(arg_0 -> ((ContainerServiceManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String resourceName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, resourceName, context).last().flatMap(arg_0 -> ((ContainerServiceManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String resourceName) {
        this.deleteAsync(resourceGroupName, resourceName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String resourceName, Context context) {
        this.deleteAsync(resourceGroupName, resourceName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OpenShiftManagedClusterInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OpenShiftManagedClusterListResult)res.getValue()).value(), ((OpenShiftManagedClusterListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OpenShiftManagedClusterInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OpenShiftManagedClusterListResult)res.getValue()).value(), ((OpenShiftManagedClusterListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OpenShiftManagedClusterInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OpenShiftManagedClusterListResult)res.getValue()).value(), ((OpenShiftManagedClusterListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OpenShiftManagedClusterInner>> listByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OpenShiftManagedClusterListResult)res.getValue()).value(), ((OpenShiftManagedClusterListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ContainerServiceMana")
    private static interface OpenShiftManagedClustersService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ContainerService/openShiftManagedClusters")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<OpenShiftManagedClusterListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/openShiftManagedClusters")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<OpenShiftManagedClusterListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/openShiftManagedClusters/{resourceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<OpenShiftManagedClusterInner>> getByResourceGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/openShiftManagedClusters/{resourceName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @BodyParam(value="application/json") OpenShiftManagedClusterInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/openShiftManagedClusters/{resourceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> updateTags(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @BodyParam(value="application/json") TagsObject var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/openShiftManagedClusters/{resourceName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<OpenShiftManagedClusterListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<OpenShiftManagedClusterListResult>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

