/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cosmos.models.ArmResourceProperties;
import com.azure.resourcemanager.cosmos.models.Capability;
import com.azure.resourcemanager.cosmos.models.ConnectorOffer;
import com.azure.resourcemanager.cosmos.models.ConsistencyPolicy;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountKind;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountOfferType;
import com.azure.resourcemanager.cosmos.models.FailoverPolicy;
import com.azure.resourcemanager.cosmos.models.Location;
import com.azure.resourcemanager.cosmos.models.VirtualNetworkRule;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class DatabaseAccountGetResultsInner
extends ArmResourceProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DatabaseAccountGetResultsInner.class);
    @JsonProperty(value="kind")
    private DatabaseAccountKind kind;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.documentEndpoint", access=JsonProperty.Access.WRITE_ONLY)
    private String documentEndpoint;
    @JsonProperty(value="properties.databaseAccountOfferType", access=JsonProperty.Access.WRITE_ONLY)
    private DatabaseAccountOfferType databaseAccountOfferType;
    @JsonProperty(value="properties.ipRangeFilter")
    private String ipRangeFilter;
    @JsonProperty(value="properties.isVirtualNetworkFilterEnabled")
    private Boolean isVirtualNetworkFilterEnabled;
    @JsonProperty(value="properties.enableAutomaticFailover")
    private Boolean enableAutomaticFailover;
    @JsonProperty(value="properties.consistencyPolicy")
    private ConsistencyPolicy consistencyPolicy;
    @JsonProperty(value="properties.capabilities")
    private List<Capability> capabilities;
    @JsonProperty(value="properties.writeLocations", access=JsonProperty.Access.WRITE_ONLY)
    private List<Location> writeLocations;
    @JsonProperty(value="properties.readLocations", access=JsonProperty.Access.WRITE_ONLY)
    private List<Location> readLocations;
    @JsonProperty(value="properties.locations", access=JsonProperty.Access.WRITE_ONLY)
    private List<Location> locations;
    @JsonProperty(value="properties.failoverPolicies", access=JsonProperty.Access.WRITE_ONLY)
    private List<FailoverPolicy> failoverPolicies;
    @JsonProperty(value="properties.virtualNetworkRules")
    private List<VirtualNetworkRule> virtualNetworkRules;
    @JsonProperty(value="properties.enableMultipleWriteLocations")
    private Boolean enableMultipleWriteLocations;
    @JsonProperty(value="properties.enableCassandraConnector")
    private Boolean enableCassandraConnector;
    @JsonProperty(value="properties.connectorOffer")
    private ConnectorOffer connectorOffer;
    @JsonProperty(value="properties.disableKeyBasedMetadataWriteAccess")
    private Boolean disableKeyBasedMetadataWriteAccess;

    public DatabaseAccountKind kind() {
        return this.kind;
    }

    public DatabaseAccountGetResultsInner withKind(DatabaseAccountKind kind) {
        this.kind = kind;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public String documentEndpoint() {
        return this.documentEndpoint;
    }

    public DatabaseAccountOfferType databaseAccountOfferType() {
        return this.databaseAccountOfferType;
    }

    public String ipRangeFilter() {
        return this.ipRangeFilter;
    }

    public DatabaseAccountGetResultsInner withIpRangeFilter(String ipRangeFilter) {
        this.ipRangeFilter = ipRangeFilter;
        return this;
    }

    public Boolean isVirtualNetworkFilterEnabled() {
        return this.isVirtualNetworkFilterEnabled;
    }

    public DatabaseAccountGetResultsInner withIsVirtualNetworkFilterEnabled(Boolean isVirtualNetworkFilterEnabled) {
        this.isVirtualNetworkFilterEnabled = isVirtualNetworkFilterEnabled;
        return this;
    }

    public Boolean enableAutomaticFailover() {
        return this.enableAutomaticFailover;
    }

    public DatabaseAccountGetResultsInner withEnableAutomaticFailover(Boolean enableAutomaticFailover) {
        this.enableAutomaticFailover = enableAutomaticFailover;
        return this;
    }

    public ConsistencyPolicy consistencyPolicy() {
        return this.consistencyPolicy;
    }

    public DatabaseAccountGetResultsInner withConsistencyPolicy(ConsistencyPolicy consistencyPolicy) {
        this.consistencyPolicy = consistencyPolicy;
        return this;
    }

    public List<Capability> capabilities() {
        return this.capabilities;
    }

    public DatabaseAccountGetResultsInner withCapabilities(List<Capability> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public List<Location> writeLocations() {
        return this.writeLocations;
    }

    public List<Location> readLocations() {
        return this.readLocations;
    }

    public List<Location> locations() {
        return this.locations;
    }

    public List<FailoverPolicy> failoverPolicies() {
        return this.failoverPolicies;
    }

    public List<VirtualNetworkRule> virtualNetworkRules() {
        return this.virtualNetworkRules;
    }

    public DatabaseAccountGetResultsInner withVirtualNetworkRules(List<VirtualNetworkRule> virtualNetworkRules) {
        this.virtualNetworkRules = virtualNetworkRules;
        return this;
    }

    public Boolean enableMultipleWriteLocations() {
        return this.enableMultipleWriteLocations;
    }

    public DatabaseAccountGetResultsInner withEnableMultipleWriteLocations(Boolean enableMultipleWriteLocations) {
        this.enableMultipleWriteLocations = enableMultipleWriteLocations;
        return this;
    }

    public Boolean enableCassandraConnector() {
        return this.enableCassandraConnector;
    }

    public DatabaseAccountGetResultsInner withEnableCassandraConnector(Boolean enableCassandraConnector) {
        this.enableCassandraConnector = enableCassandraConnector;
        return this;
    }

    public ConnectorOffer connectorOffer() {
        return this.connectorOffer;
    }

    public DatabaseAccountGetResultsInner withConnectorOffer(ConnectorOffer connectorOffer) {
        this.connectorOffer = connectorOffer;
        return this;
    }

    public Boolean disableKeyBasedMetadataWriteAccess() {
        return this.disableKeyBasedMetadataWriteAccess;
    }

    public DatabaseAccountGetResultsInner withDisableKeyBasedMetadataWriteAccess(Boolean disableKeyBasedMetadataWriteAccess) {
        this.disableKeyBasedMetadataWriteAccess = disableKeyBasedMetadataWriteAccess;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.consistencyPolicy() != null) {
            this.consistencyPolicy().validate();
        }
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
        if (this.writeLocations() != null) {
            this.writeLocations().forEach(e -> e.validate());
        }
        if (this.readLocations() != null) {
            this.readLocations().forEach(e -> e.validate());
        }
        if (this.locations() != null) {
            this.locations().forEach(e -> e.validate());
        }
        if (this.failoverPolicies() != null) {
            this.failoverPolicies().forEach(e -> e.validate());
        }
        if (this.virtualNetworkRules() != null) {
            this.virtualNetworkRules().forEach(e -> e.validate());
        }
    }
}

