/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.management.Region;
import com.azure.core.management.Resource;
import com.azure.resourcemanager.cosmos.CosmosManager;
import com.azure.resourcemanager.cosmos.fluent.CosmosDBManagementClient;
import com.azure.resourcemanager.cosmos.fluent.models.DatabaseAccountGetResultsInner;
import com.azure.resourcemanager.cosmos.implementation.DatabaseAccountListConnectionStringsResultImpl;
import com.azure.resourcemanager.cosmos.implementation.DatabaseAccountListKeysResultImpl;
import com.azure.resourcemanager.cosmos.implementation.DatabaseAccountListReadOnlyKeysResultImpl;
import com.azure.resourcemanager.cosmos.implementation.PrivateEndpointConnectionImpl;
import com.azure.resourcemanager.cosmos.implementation.PrivateEndpointConnectionsImpl;
import com.azure.resourcemanager.cosmos.implementation.PrivateLinkResourceImpl;
import com.azure.resourcemanager.cosmos.implementation.SqlDatabaseImpl;
import com.azure.resourcemanager.cosmos.models.Capability;
import com.azure.resourcemanager.cosmos.models.ConnectorOffer;
import com.azure.resourcemanager.cosmos.models.ConsistencyPolicy;
import com.azure.resourcemanager.cosmos.models.CosmosDBAccount;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountKind;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountListConnectionStringsResult;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountListKeysResult;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountListReadOnlyKeysResult;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountOfferType;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountRegenerateKeyParameters;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountUpdateParameters;
import com.azure.resourcemanager.cosmos.models.DefaultConsistencyLevel;
import com.azure.resourcemanager.cosmos.models.FailoverPolicy;
import com.azure.resourcemanager.cosmos.models.KeyKind;
import com.azure.resourcemanager.cosmos.models.Location;
import com.azure.resourcemanager.cosmos.models.PrivateEndpointConnection;
import com.azure.resourcemanager.cosmos.models.PrivateLinkResource;
import com.azure.resourcemanager.cosmos.models.RegionForOnlineOffline;
import com.azure.resourcemanager.cosmos.models.SqlDatabase;
import com.azure.resourcemanager.cosmos.models.VirtualNetworkRule;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

class CosmosDBAccountImpl
extends GroupableResourceImpl<CosmosDBAccount, DatabaseAccountGetResultsInner, CosmosDBAccountImpl, CosmosManager>
implements CosmosDBAccount,
CosmosDBAccount.Definition,
CosmosDBAccount.Update {
    private List<FailoverPolicy> failoverPolicies = new ArrayList<FailoverPolicy>();
    private boolean hasFailoverPolicyChanges;
    private static final int MAX_DELAY_DUE_TO_MISSING_FAILOVERS = 600;
    private Map<String, VirtualNetworkRule> virtualNetworkRulesMap;
    private PrivateEndpointConnectionsImpl privateEndpointConnections = new PrivateEndpointConnectionsImpl(((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getPrivateEndpointConnections(), this);

    CosmosDBAccountImpl(String name, DatabaseAccountGetResultsInner innerObject, CosmosManager manager) {
        super(CosmosDBAccountImpl.fixDBName(name), (Resource)innerObject, (Manager)manager);
    }

    @Override
    public DatabaseAccountKind kind() {
        return ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).kind();
    }

    @Override
    public String documentEndpoint() {
        return ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).documentEndpoint();
    }

    @Override
    public DatabaseAccountOfferType databaseAccountOfferType() {
        return ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).databaseAccountOfferType();
    }

    @Override
    public String ipRangeFilter() {
        return ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).ipRangeFilter();
    }

    @Override
    public ConsistencyPolicy consistencyPolicy() {
        return ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).consistencyPolicy();
    }

    @Override
    public DefaultConsistencyLevel defaultConsistencyLevel() {
        if (((DatabaseAccountGetResultsInner)((Object)this.innerModel())).consistencyPolicy() == null) {
            throw new RuntimeException("Consistency policy is missing!");
        }
        return ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).consistencyPolicy().defaultConsistencyLevel();
    }

    @Override
    public List<Location> writableReplications() {
        return ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).writeLocations();
    }

    @Override
    public List<Location> readableReplications() {
        return ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).readLocations();
    }

    @Override
    public DatabaseAccountListKeysResult listKeys() {
        return (DatabaseAccountListKeysResult)this.listKeysAsync().block();
    }

    @Override
    public Mono<DatabaseAccountListKeysResult> listKeysAsync() {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().listKeysAsync(this.resourceGroupName(), this.name()).map(DatabaseAccountListKeysResultImpl::new);
    }

    @Override
    public DatabaseAccountListReadOnlyKeysResult listReadOnlyKeys() {
        return (DatabaseAccountListReadOnlyKeysResult)this.listReadOnlyKeysAsync().block();
    }

    @Override
    public Mono<DatabaseAccountListReadOnlyKeysResult> listReadOnlyKeysAsync() {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().listReadOnlyKeysAsync(this.resourceGroupName(), this.name()).map(DatabaseAccountListReadOnlyKeysResultImpl::new);
    }

    @Override
    public DatabaseAccountListConnectionStringsResult listConnectionStrings() {
        return (DatabaseAccountListConnectionStringsResult)this.listConnectionStringsAsync().block();
    }

    @Override
    public Mono<DatabaseAccountListConnectionStringsResult> listConnectionStringsAsync() {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().listConnectionStringsAsync(this.resourceGroupName(), this.name()).map(DatabaseAccountListConnectionStringsResultImpl::new);
    }

    @Override
    public List<SqlDatabase> listSqlDatabases() {
        return (List)this.listSqlDatabasesAsync().collectList().block();
    }

    @Override
    public PagedFlux<SqlDatabase> listSqlDatabasesAsync() {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getSqlResources().listSqlDatabasesAsync(this.resourceGroupName(), this.name()).mapPage(SqlDatabaseImpl::new);
    }

    @Override
    public List<PrivateLinkResource> listPrivateLinkResources() {
        return (List)this.listPrivateLinkResourcesAsync().collectList().block();
    }

    @Override
    public PagedFlux<PrivateLinkResource> listPrivateLinkResourcesAsync() {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getPrivateLinkResources().listByDatabaseAccountAsync(this.resourceGroupName(), this.name()).mapPage(PrivateLinkResourceImpl::new);
    }

    @Override
    public PrivateLinkResource getPrivateLinkResource(String groupName) {
        return (PrivateLinkResource)this.getPrivateLinkResourceAsync(groupName).block();
    }

    @Override
    public Mono<PrivateLinkResource> getPrivateLinkResourceAsync(String groupName) {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getPrivateLinkResources().getAsync(this.resourceGroupName(), this.name(), groupName).map(PrivateLinkResourceImpl::new);
    }

    @Override
    public Map<String, PrivateEndpointConnection> listPrivateEndpointConnection() {
        return (Map)this.listPrivateEndpointConnectionAsync().block();
    }

    @Override
    public Mono<Map<String, PrivateEndpointConnection>> listPrivateEndpointConnectionAsync() {
        return this.privateEndpointConnections.asMapAsync();
    }

    @Override
    public PrivateEndpointConnection getPrivateEndpointConnection(String name) {
        return (PrivateEndpointConnection)this.getPrivateEndpointConnectionAsync(name).block();
    }

    @Override
    public Mono<PrivateEndpointConnection> getPrivateEndpointConnectionAsync(String name) {
        return this.privateEndpointConnections.getImplAsync(name).map(privateEndpointConnection -> privateEndpointConnection);
    }

    @Override
    public boolean multipleWriteLocationsEnabled() {
        return ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).enableMultipleWriteLocations();
    }

    @Override
    public boolean cassandraConnectorEnabled() {
        return ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).enableCassandraConnector();
    }

    @Override
    public ConnectorOffer cassandraConnectorOffer() {
        return ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).connectorOffer();
    }

    @Override
    public boolean keyBasedMetadataWriteAccessDisabled() {
        return ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).disableKeyBasedMetadataWriteAccess();
    }

    @Override
    public List<Capability> capabilities() {
        List<Capability> capabilities = ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).capabilities();
        if (capabilities == null) {
            capabilities = new ArrayList<Capability>();
        }
        return Collections.unmodifiableList(capabilities);
    }

    @Override
    public List<VirtualNetworkRule> virtualNetworkRules() {
        ArrayList result = this.innerModel() != null && ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).virtualNetworkRules() != null ? ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).virtualNetworkRules() : new ArrayList();
        return Collections.unmodifiableList(result);
    }

    @Override
    public void offlineRegion(Region region) {
        ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().offlineRegion(this.resourceGroupName(), this.name(), new RegionForOnlineOffline().withRegion(region.label()));
    }

    @Override
    public Mono<Void> offlineRegionAsync(Region region) {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().offlineRegionAsync(this.resourceGroupName(), this.name(), new RegionForOnlineOffline().withRegion(region.label()));
    }

    @Override
    public void onlineRegion(Region region) {
        ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().onlineRegion(this.resourceGroupName(), this.name(), new RegionForOnlineOffline().withRegion(region.label()));
    }

    @Override
    public Mono<Void> onlineRegionAsync(Region region) {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().onlineRegionAsync(this.resourceGroupName(), this.name(), new RegionForOnlineOffline().withRegion(region.label()));
    }

    @Override
    public void regenerateKey(KeyKind keyKind) {
        ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().regenerateKey(this.resourceGroupName(), this.name(), new DatabaseAccountRegenerateKeyParameters().withKeyKind(keyKind));
    }

    @Override
    public Mono<Void> regenerateKeyAsync(KeyKind keyKind) {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().regenerateKeyAsync(this.resourceGroupName(), this.name(), new DatabaseAccountRegenerateKeyParameters().withKeyKind(keyKind));
    }

    @Override
    public CosmosDBAccountImpl withKind(DatabaseAccountKind kind) {
        ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).withKind(kind);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withKind(DatabaseAccountKind kind, Capability ... capabilities) {
        ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).withKind(kind);
        ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).withCapabilities(Arrays.asList(capabilities));
        return this;
    }

    @Override
    public CosmosDBAccountImpl withDataModelSql() {
        ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).withKind(DatabaseAccountKind.GLOBAL_DOCUMENT_DB);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withDataModelMongoDB() {
        ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).withKind(DatabaseAccountKind.MONGO_DB);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withDataModelCassandra() {
        ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).withKind(DatabaseAccountKind.GLOBAL_DOCUMENT_DB);
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        capabilities.add(new Capability().withName("EnableCassandra"));
        ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).withCapabilities(capabilities);
        this.withTag("defaultExperience", "Cassandra");
        return this;
    }

    @Override
    public CosmosDBAccountImpl withDataModelAzureTable() {
        ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).withKind(DatabaseAccountKind.GLOBAL_DOCUMENT_DB);
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        capabilities.add(new Capability().withName("EnableTable"));
        ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).withCapabilities(capabilities);
        this.withTag("defaultExperience", "Table");
        return this;
    }

    @Override
    public CosmosDBAccountImpl withDataModelGremlin() {
        ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).withKind(DatabaseAccountKind.GLOBAL_DOCUMENT_DB);
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        capabilities.add(new Capability().withName("EnableGremlin"));
        ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).withCapabilities(capabilities);
        this.withTag("defaultExperience", "Graph");
        return this;
    }

    @Override
    public CosmosDBAccountImpl withIpRangeFilter(String ipRangeFilter) {
        ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).withIpRangeFilter(ipRangeFilter);
        return this;
    }

    protected Mono<DatabaseAccountGetResultsInner> getInnerAsync() {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public CosmosDBAccountImpl withWriteReplication(Region region) {
        FailoverPolicy failoverPolicyInner = new FailoverPolicy();
        failoverPolicyInner.withLocationName(region.name());
        this.hasFailoverPolicyChanges = true;
        this.failoverPolicies.add(failoverPolicyInner);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withReadReplication(Region region) {
        this.ensureFailoverIsInitialized();
        FailoverPolicy failoverPolicyInner = new FailoverPolicy();
        failoverPolicyInner.withLocationName(region.name());
        failoverPolicyInner.withFailoverPriority(this.failoverPolicies.size());
        this.hasFailoverPolicyChanges = true;
        this.failoverPolicies.add(failoverPolicyInner);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withoutReadReplication(Region region) {
        this.ensureFailoverIsInitialized();
        for (int i = 1; i < this.failoverPolicies.size(); ++i) {
            String locName;
            if (this.failoverPolicies.get(i).locationName() == null || !(locName = CosmosDBAccountImpl.formatLocationName(this.failoverPolicies.get(i).locationName())).equals(region.name())) continue;
            this.failoverPolicies.remove(i);
        }
        return this;
    }

    @Override
    public CosmosDBAccountImpl withEventualConsistency() {
        this.setConsistencyPolicy(DefaultConsistencyLevel.EVENTUAL, 0L, 0);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withSessionConsistency() {
        this.setConsistencyPolicy(DefaultConsistencyLevel.SESSION, 0L, 0);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withBoundedStalenessConsistency(long maxStalenessPrefix, int maxIntervalInSeconds) {
        this.setConsistencyPolicy(DefaultConsistencyLevel.BOUNDED_STALENESS, maxStalenessPrefix, maxIntervalInSeconds);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withStrongConsistency() {
        this.setConsistencyPolicy(DefaultConsistencyLevel.STRONG, 0L, 0);
        return this;
    }

    public PrivateEndpointConnectionImpl defineNewPrivateEndpointConnection(String name) {
        return this.privateEndpointConnections.define(name);
    }

    @Override
    public PrivateEndpointConnectionImpl updatePrivateEndpointConnection(String name) {
        return this.privateEndpointConnections.update(name);
    }

    @Override
    public CosmosDBAccountImpl withoutPrivateEndpointConnection(String name) {
        this.privateEndpointConnections.remove(name);
        return this;
    }

    CosmosDBAccountImpl withPrivateEndpointConnection(PrivateEndpointConnectionImpl privateEndpointConnection) {
        this.privateEndpointConnections.addPrivateEndpointConnection(privateEndpointConnection);
        return this;
    }

    public Mono<CosmosDBAccount> createResourceAsync() {
        return this.doDatabaseUpdateCreate();
    }

    private DatabaseAccountCreateUpdateParameters createUpdateParametersInner(DatabaseAccountGetResultsInner inner) {
        this.ensureFailoverIsInitialized();
        DatabaseAccountCreateUpdateParameters createUpdateParametersInner = new DatabaseAccountCreateUpdateParameters();
        createUpdateParametersInner.withLocation(this.regionName().toLowerCase(Locale.ROOT));
        createUpdateParametersInner.withConsistencyPolicy(inner.consistencyPolicy());
        createUpdateParametersInner.withIpRangeFilter(inner.ipRangeFilter());
        createUpdateParametersInner.withKind(inner.kind());
        createUpdateParametersInner.withCapabilities(inner.capabilities());
        createUpdateParametersInner.withTags(inner.tags());
        createUpdateParametersInner.withEnableMultipleWriteLocations(inner.enableMultipleWriteLocations());
        this.addLocationsForParameters(new CreateUpdateLocationParameters(createUpdateParametersInner), this.failoverPolicies);
        createUpdateParametersInner.withIsVirtualNetworkFilterEnabled(inner.isVirtualNetworkFilterEnabled());
        createUpdateParametersInner.withEnableCassandraConnector(inner.enableCassandraConnector());
        createUpdateParametersInner.withConnectorOffer(inner.connectorOffer());
        createUpdateParametersInner.withEnableAutomaticFailover(inner.enableAutomaticFailover());
        createUpdateParametersInner.withDisableKeyBasedMetadataWriteAccess(inner.disableKeyBasedMetadataWriteAccess());
        if (this.virtualNetworkRulesMap != null) {
            createUpdateParametersInner.withVirtualNetworkRules(new ArrayList<VirtualNetworkRule>(this.virtualNetworkRulesMap.values()));
            this.virtualNetworkRulesMap = null;
        }
        return createUpdateParametersInner;
    }

    private DatabaseAccountUpdateParameters updateParametersInner(DatabaseAccountGetResultsInner inner) {
        this.ensureFailoverIsInitialized();
        DatabaseAccountUpdateParameters updateParameters = new DatabaseAccountUpdateParameters();
        updateParameters.withTags(inner.tags());
        updateParameters.withLocation(this.regionName().toLowerCase(Locale.ROOT));
        updateParameters.withConsistencyPolicy(inner.consistencyPolicy());
        updateParameters.withIpRangeFilter(inner.ipRangeFilter());
        updateParameters.withIsVirtualNetworkFilterEnabled(inner.isVirtualNetworkFilterEnabled());
        updateParameters.withEnableAutomaticFailover(inner.enableAutomaticFailover());
        updateParameters.withCapabilities(inner.capabilities());
        updateParameters.withEnableMultipleWriteLocations(inner.enableMultipleWriteLocations());
        updateParameters.withEnableCassandraConnector(inner.enableCassandraConnector());
        updateParameters.withConnectorOffer(inner.connectorOffer());
        updateParameters.withDisableKeyBasedMetadataWriteAccess(inner.disableKeyBasedMetadataWriteAccess());
        if (this.virtualNetworkRulesMap != null) {
            updateParameters.withVirtualNetworkRules(new ArrayList<VirtualNetworkRule>(this.virtualNetworkRulesMap.values()));
            this.virtualNetworkRulesMap = null;
        }
        this.addLocationsForParameters(new UpdateLocationParameters(updateParameters), this.failoverPolicies);
        return updateParameters;
    }

    private static String fixDBName(String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    private void setConsistencyPolicy(DefaultConsistencyLevel level, long maxStalenessPrefix, int maxIntervalInSeconds) {
        ConsistencyPolicy policy = new ConsistencyPolicy();
        policy.withDefaultConsistencyLevel(level);
        if (level == DefaultConsistencyLevel.BOUNDED_STALENESS) {
            policy.withMaxStalenessPrefix(maxStalenessPrefix);
            policy.withMaxIntervalInSeconds(maxIntervalInSeconds);
        }
        ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).withConsistencyPolicy(policy);
    }

    private void addLocationsForParameters(HasLocations locationParameters, List<FailoverPolicy> failoverPolicies) {
        ArrayList<Location> locations = new ArrayList<Location>();
        if (failoverPolicies.size() > 0) {
            for (int i = 0; i < failoverPolicies.size(); ++i) {
                FailoverPolicy policyInner = failoverPolicies.get(i);
                Location location = new Location();
                location.withFailoverPriority(i);
                location.withLocationName(policyInner.locationName());
                locations.add(location);
            }
        } else {
            Location location = new Location();
            location.withFailoverPriority(0);
            location.withLocationName(locationParameters.location());
            locations.add(location);
        }
        locationParameters.withLocations(locations);
    }

    private static String formatLocationName(String locationName) {
        return locationName.replace(" ", "").toLowerCase(Locale.ROOT);
    }

    private Mono<CosmosDBAccount> doDatabaseUpdateCreate() {
        CosmosDBAccountImpl self = this;
        ArrayList<Integer> data = new ArrayList<Integer>();
        data.add(0);
        Mono<DatabaseAccountGetResultsInner> request = null;
        HasLocations locationParameters = null;
        if (this.isInCreateMode()) {
            DatabaseAccountCreateUpdateParameters createUpdateParametersInner = this.createUpdateParametersInner((DatabaseAccountGetResultsInner)((Object)this.innerModel()));
            request = ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().createOrUpdateAsync(this.resourceGroupName(), this.name(), createUpdateParametersInner);
            locationParameters = new CreateUpdateLocationParameters(createUpdateParametersInner);
        } else {
            DatabaseAccountUpdateParameters updateParametersInner = this.updateParametersInner((DatabaseAccountGetResultsInner)((Object)this.innerModel()));
            request = ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().updateAsync(this.resourceGroupName(), this.name(), updateParametersInner);
            locationParameters = new UpdateLocationParameters(updateParametersInner);
        }
        Set locations = locationParameters.locations().stream().map(location -> CosmosDBAccountImpl.formatLocationName(location.locationName())).collect(Collectors.toSet());
        return request.flatMap(databaseAccountInner -> {
            self.failoverPolicies.clear();
            self.hasFailoverPolicyChanges = false;
            return ((CosmosManager)this.manager()).databaseAccounts().getByResourceGroupAsync(this.resourceGroupName(), this.name()).flatMap(databaseAccount -> {
                if (600 > (Integer)data.get(0) && (databaseAccount.id() == null || databaseAccount.id().length() == 0 || locations.size() != ((DatabaseAccountGetResultsInner)((Object)((Object)((Object)databaseAccount.innerModel())))).failoverPolicies().size())) {
                    return Mono.empty();
                }
                if (this.isAFinalProvisioningState(((DatabaseAccountGetResultsInner)((Object)((Object)((Object)databaseAccount.innerModel())))).provisioningState())) {
                    for (Location location : databaseAccount.readableReplications()) {
                        if (!this.isAFinalProvisioningState(location.provisioningState())) {
                            return Mono.empty();
                        }
                        if (locations.contains(CosmosDBAccountImpl.formatLocationName(location.locationName()))) continue;
                        return Mono.empty();
                    }
                } else {
                    return Mono.empty();
                }
                self.setInner((Object)((DatabaseAccountGetResultsInner)((Object)((Object)((Object)databaseAccount.innerModel())))));
                return Mono.just((Object)databaseAccount);
            }).repeatWhenEmpty(longFlux -> longFlux.flatMap(index -> {
                data.set(0, (Integer)data.get(0) + 30);
                return Mono.delay((Duration)ResourceManagerUtils.InternalRuntimeContext.getDelayDuration((Duration)((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDefaultPollInterval()));
            }));
        });
    }

    private void ensureFailoverIsInitialized() {
        if (this.isInCreateMode()) {
            return;
        }
        if (!this.hasFailoverPolicyChanges) {
            this.failoverPolicies.clear();
            FailoverPolicy[] policyInners = new FailoverPolicy[((DatabaseAccountGetResultsInner)((Object)this.innerModel())).failoverPolicies().size()];
            ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).failoverPolicies().toArray(policyInners);
            Arrays.sort(policyInners, Comparator.comparing(FailoverPolicy::failoverPriority));
            for (int i = 0; i < policyInners.length; ++i) {
                this.failoverPolicies.add(policyInners[i]);
            }
            this.hasFailoverPolicyChanges = true;
        }
    }

    private boolean isAFinalProvisioningState(String state) {
        switch (state.toLowerCase(Locale.ROOT)) {
            case "succeeded": 
            case "canceled": 
            case "failed": {
                return true;
            }
        }
        return false;
    }

    private Map<String, VirtualNetworkRule> ensureVirtualNetworkRules() {
        if (this.virtualNetworkRulesMap == null) {
            this.virtualNetworkRulesMap = new HashMap<String, VirtualNetworkRule>();
            if (this.innerModel() != null && ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).virtualNetworkRules() != null) {
                for (VirtualNetworkRule virtualNetworkRule : ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).virtualNetworkRules()) {
                    this.virtualNetworkRulesMap.put(virtualNetworkRule.id(), virtualNetworkRule);
                }
            }
        }
        return this.virtualNetworkRulesMap;
    }

    @Override
    public CosmosDBAccountImpl withVirtualNetwork(String virtualNetworkId, String subnetName) {
        ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).withIsVirtualNetworkFilterEnabled(true);
        String vnetId = virtualNetworkId + "/subnets/" + subnetName;
        this.ensureVirtualNetworkRules().put(vnetId, new VirtualNetworkRule().withId(vnetId));
        return this;
    }

    @Override
    public CosmosDBAccountImpl withoutVirtualNetwork(String virtualNetworkId, String subnetName) {
        Map<String, VirtualNetworkRule> vnetRules = this.ensureVirtualNetworkRules();
        vnetRules.remove(virtualNetworkId + "/subnets/" + subnetName);
        if (vnetRules.size() == 0) {
            ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).withIsVirtualNetworkFilterEnabled(false);
        }
        return this;
    }

    @Override
    public CosmosDBAccountImpl withVirtualNetworkRules(List<VirtualNetworkRule> virtualNetworkRules) {
        Map<String, VirtualNetworkRule> vnetRules = this.ensureVirtualNetworkRules();
        if (virtualNetworkRules == null || virtualNetworkRules.isEmpty()) {
            vnetRules.clear();
            ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).withIsVirtualNetworkFilterEnabled(false);
            return this;
        }
        ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).withIsVirtualNetworkFilterEnabled(true);
        for (VirtualNetworkRule vnetRule : virtualNetworkRules) {
            this.virtualNetworkRulesMap.put(vnetRule.id(), vnetRule);
        }
        return this;
    }

    @Override
    public CosmosDBAccountImpl withMultipleWriteLocationsEnabled(boolean enabled) {
        ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).withEnableMultipleWriteLocations(enabled);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withCassandraConnector(ConnectorOffer connectorOffer) {
        ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).withEnableCassandraConnector(true);
        ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).withConnectorOffer(connectorOffer);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withoutCassandraConnector() {
        ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).withEnableCassandraConnector(false);
        ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).withConnectorOffer(null);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withDisableKeyBaseMetadataWriteAccess(boolean disabled) {
        ((DatabaseAccountGetResultsInner)((Object)this.innerModel())).withDisableKeyBasedMetadataWriteAccess(disabled);
        return this;
    }

    static class UpdateLocationParameters
    implements HasLocations {
        private DatabaseAccountUpdateParameters parameters;

        UpdateLocationParameters(DatabaseAccountUpdateParameters parametersObject) {
            this.parameters = parametersObject;
        }

        @Override
        public String location() {
            return this.parameters.location();
        }

        @Override
        public List<Location> locations() {
            return this.parameters.locations();
        }

        @Override
        public void withLocations(List<Location> locations) {
            this.parameters.withLocations(locations);
        }
    }

    static class CreateUpdateLocationParameters
    implements HasLocations {
        private DatabaseAccountCreateUpdateParameters parameters;

        CreateUpdateLocationParameters(DatabaseAccountCreateUpdateParameters parametersObject) {
            this.parameters = parametersObject;
        }

        @Override
        public String location() {
            return this.parameters.location();
        }

        @Override
        public List<Location> locations() {
            return this.parameters.locations();
        }

        @Override
        public void withLocations(List<Location> locations) {
            this.parameters.withLocations(locations);
        }
    }

    static interface HasLocations {
        public String location();

        public List<Location> locations();

        public void withLocations(List<Location> var1);
    }
}

