/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cosmos.fluent.DatabasesClient;
import com.azure.resourcemanager.cosmos.fluent.models.MetricDefinitionInner;
import com.azure.resourcemanager.cosmos.fluent.models.MetricInner;
import com.azure.resourcemanager.cosmos.fluent.models.UsageInner;
import com.azure.resourcemanager.cosmos.implementation.CosmosDBManagementClientImpl;
import com.azure.resourcemanager.cosmos.models.MetricDefinitionsListResult;
import com.azure.resourcemanager.cosmos.models.MetricListResult;
import com.azure.resourcemanager.cosmos.models.UsagesResult;
import reactor.core.publisher.Mono;

public final class DatabasesClientImpl
implements DatabasesClient {
    private final ClientLogger logger = new ClientLogger(DatabasesClientImpl.class);
    private final DatabasesService service;
    private final CosmosDBManagementClientImpl client;

    DatabasesClientImpl(CosmosDBManagementClientImpl client) {
        this.service = (DatabasesService)RestProxy.create(DatabasesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<MetricInner>> listMetricsSinglePageAsync(String resourceGroupName, String accountName, String databaseRid, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseRid == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseRid is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.listMetrics(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseRid, "2019-08-01", filter, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricListResult)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MetricInner>> listMetricsSinglePageAsync(String resourceGroupName, String accountName, String databaseRid, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseRid == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseRid is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.listMetrics(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseRid, "2019-08-01", filter, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricListResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<MetricInner> listMetricsAsync(String resourceGroupName, String accountName, String databaseRid, String filter) {
        return new PagedFlux(() -> this.listMetricsSinglePageAsync(resourceGroupName, accountName, databaseRid, filter));
    }

    private PagedFlux<MetricInner> listMetricsAsync(String resourceGroupName, String accountName, String databaseRid, String filter, Context context) {
        return new PagedFlux(() -> this.listMetricsSinglePageAsync(resourceGroupName, accountName, databaseRid, filter, context));
    }

    @Override
    public PagedIterable<MetricInner> listMetrics(String resourceGroupName, String accountName, String databaseRid, String filter) {
        return new PagedIterable(this.listMetricsAsync(resourceGroupName, accountName, databaseRid, filter));
    }

    @Override
    public PagedIterable<MetricInner> listMetrics(String resourceGroupName, String accountName, String databaseRid, String filter, Context context) {
        return new PagedIterable(this.listMetricsAsync(resourceGroupName, accountName, databaseRid, filter, context));
    }

    private Mono<PagedResponse<UsageInner>> listUsagesSinglePageAsync(String resourceGroupName, String accountName, String databaseRid, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseRid == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseRid is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.listUsages(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseRid, "2019-08-01", filter, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UsagesResult)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<UsageInner>> listUsagesSinglePageAsync(String resourceGroupName, String accountName, String databaseRid, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseRid == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseRid is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.listUsages(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseRid, "2019-08-01", filter, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UsagesResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<UsageInner> listUsagesAsync(String resourceGroupName, String accountName, String databaseRid, String filter) {
        return new PagedFlux(() -> this.listUsagesSinglePageAsync(resourceGroupName, accountName, databaseRid, filter));
    }

    @Override
    public PagedFlux<UsageInner> listUsagesAsync(String resourceGroupName, String accountName, String databaseRid) {
        String filter = null;
        return new PagedFlux(() -> this.listUsagesSinglePageAsync(resourceGroupName, accountName, databaseRid, filter));
    }

    private PagedFlux<UsageInner> listUsagesAsync(String resourceGroupName, String accountName, String databaseRid, String filter, Context context) {
        return new PagedFlux(() -> this.listUsagesSinglePageAsync(resourceGroupName, accountName, databaseRid, filter, context));
    }

    @Override
    public PagedIterable<UsageInner> listUsages(String resourceGroupName, String accountName, String databaseRid, String filter, Context context) {
        return new PagedIterable(this.listUsagesAsync(resourceGroupName, accountName, databaseRid, filter, context));
    }

    @Override
    public PagedIterable<UsageInner> listUsages(String resourceGroupName, String accountName, String databaseRid) {
        String filter = null;
        return new PagedIterable(this.listUsagesAsync(resourceGroupName, accountName, databaseRid, filter));
    }

    private Mono<PagedResponse<MetricDefinitionInner>> listMetricDefinitionsSinglePageAsync(String resourceGroupName, String accountName, String databaseRid) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseRid == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseRid is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.listMetricDefinitions(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseRid, "2019-08-01", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricDefinitionsListResult)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MetricDefinitionInner>> listMetricDefinitionsSinglePageAsync(String resourceGroupName, String accountName, String databaseRid, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseRid == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseRid is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.listMetricDefinitions(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseRid, "2019-08-01", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricDefinitionsListResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<MetricDefinitionInner> listMetricDefinitionsAsync(String resourceGroupName, String accountName, String databaseRid) {
        return new PagedFlux(() -> this.listMetricDefinitionsSinglePageAsync(resourceGroupName, accountName, databaseRid));
    }

    private PagedFlux<MetricDefinitionInner> listMetricDefinitionsAsync(String resourceGroupName, String accountName, String databaseRid, Context context) {
        return new PagedFlux(() -> this.listMetricDefinitionsSinglePageAsync(resourceGroupName, accountName, databaseRid, context));
    }

    @Override
    public PagedIterable<MetricDefinitionInner> listMetricDefinitions(String resourceGroupName, String accountName, String databaseRid) {
        return new PagedIterable(this.listMetricDefinitionsAsync(resourceGroupName, accountName, databaseRid));
    }

    @Override
    public PagedIterable<MetricDefinitionInner> listMetricDefinitions(String resourceGroupName, String accountName, String databaseRid, Context context) {
        return new PagedIterable(this.listMetricDefinitionsAsync(resourceGroupName, accountName, databaseRid, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CosmosDBManagementCl")
    private static interface DatabasesService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/databases/{databaseRid}/metrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MetricListResult>> listMetrics(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseRid") String var5, @QueryParam(value="api-version") String var6, @QueryParam(value="$filter") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/databases/{databaseRid}/usages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<UsagesResult>> listUsages(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseRid") String var5, @QueryParam(value="api-version") String var6, @QueryParam(value="$filter") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/databases/{databaseRid}/metricDefinitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MetricDefinitionsListResult>> listMetricDefinitions(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseRid") String var5, @QueryParam(value="api-version") String var6, Context var7);
    }
}

