/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cosmos.fluent.PartitionKeyRangeIdsClient;
import com.azure.resourcemanager.cosmos.fluent.models.PartitionMetricInner;
import com.azure.resourcemanager.cosmos.implementation.CosmosDBManagementClientImpl;
import com.azure.resourcemanager.cosmos.models.PartitionMetricListResult;
import reactor.core.publisher.Mono;

public final class PartitionKeyRangeIdsClientImpl
implements PartitionKeyRangeIdsClient {
    private final ClientLogger logger = new ClientLogger(PartitionKeyRangeIdsClientImpl.class);
    private final PartitionKeyRangeIdsService service;
    private final CosmosDBManagementClientImpl client;

    PartitionKeyRangeIdsClientImpl(CosmosDBManagementClientImpl client) {
        this.service = (PartitionKeyRangeIdsService)RestProxy.create(PartitionKeyRangeIdsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<PartitionMetricInner>> listMetricsSinglePageAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String partitionKeyRangeId, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseRid == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseRid is required and cannot be null."));
        }
        if (collectionRid == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter collectionRid is required and cannot be null."));
        }
        if (partitionKeyRangeId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter partitionKeyRangeId is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.listMetrics(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseRid, collectionRid, partitionKeyRangeId, "2019-08-01", filter, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PartitionMetricListResult)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<PartitionMetricInner>> listMetricsSinglePageAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String partitionKeyRangeId, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseRid == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseRid is required and cannot be null."));
        }
        if (collectionRid == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter collectionRid is required and cannot be null."));
        }
        if (partitionKeyRangeId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter partitionKeyRangeId is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.listMetrics(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseRid, collectionRid, partitionKeyRangeId, "2019-08-01", filter, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PartitionMetricListResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<PartitionMetricInner> listMetricsAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String partitionKeyRangeId, String filter) {
        return new PagedFlux(() -> this.listMetricsSinglePageAsync(resourceGroupName, accountName, databaseRid, collectionRid, partitionKeyRangeId, filter));
    }

    private PagedFlux<PartitionMetricInner> listMetricsAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String partitionKeyRangeId, String filter, Context context) {
        return new PagedFlux(() -> this.listMetricsSinglePageAsync(resourceGroupName, accountName, databaseRid, collectionRid, partitionKeyRangeId, filter, context));
    }

    @Override
    public PagedIterable<PartitionMetricInner> listMetrics(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String partitionKeyRangeId, String filter) {
        return new PagedIterable(this.listMetricsAsync(resourceGroupName, accountName, databaseRid, collectionRid, partitionKeyRangeId, filter));
    }

    @Override
    public PagedIterable<PartitionMetricInner> listMetrics(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String partitionKeyRangeId, String filter, Context context) {
        return new PagedIterable(this.listMetricsAsync(resourceGroupName, accountName, databaseRid, collectionRid, partitionKeyRangeId, filter, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CosmosDBManagementCl")
    private static interface PartitionKeyRangeIdsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/databases/{databaseRid}/collections/{collectionRid}/partitionKeyRangeId/{partitionKeyRangeId}/metrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PartitionMetricListResult>> listMetrics(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseRid") String var5, @PathParam(value="collectionRid") String var6, @PathParam(value="partitionKeyRangeId") String var7, @QueryParam(value="api-version") String var8, @QueryParam(value="$filter") String var9, Context var10);
    }
}

