/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.resourcemanager.cosmos.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.cosmos.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.cosmos.implementation.CosmosDBAccountImpl;
import com.azure.resourcemanager.cosmos.implementation.PrivateEndpointConnectionImpl;
import com.azure.resourcemanager.cosmos.models.CosmosDBAccount;
import com.azure.resourcemanager.cosmos.models.PrivateEndpointConnection;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ExternalChildResourcesCachedImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class PrivateEndpointConnectionsImpl
extends ExternalChildResourcesCachedImpl<PrivateEndpointConnectionImpl, PrivateEndpointConnection, PrivateEndpointConnectionInner, CosmosDBAccountImpl, CosmosDBAccount> {
    private final PrivateEndpointConnectionsClient client;

    PrivateEndpointConnectionsImpl(PrivateEndpointConnectionsClient client, CosmosDBAccountImpl parent) {
        super((Object)parent, parent.taskGroup(), "PrivateEndpointConnection");
        this.client = client;
    }

    public PrivateEndpointConnectionImpl define(String name) {
        return (PrivateEndpointConnectionImpl)this.prepareInlineDefine(name);
    }

    public PrivateEndpointConnectionImpl update(String name) {
        if (this.collection().size() == 0) {
            this.cacheCollection();
        }
        return (PrivateEndpointConnectionImpl)this.prepareInlineUpdate(name);
    }

    public void remove(String name) {
        if (this.collection().size() == 0) {
            this.cacheCollection();
        }
        this.prepareInlineRemove(name);
    }

    public Map<String, PrivateEndpointConnection> asMap() {
        return (Map)this.asMapAsync().block();
    }

    public Mono<Map<String, PrivateEndpointConnection>> asMapAsync() {
        return this.listAsync().collectList().map(privateEndpointConnections -> {
            HashMap<String, PrivateEndpointConnectionImpl> privateEndpointConnectionMap = new HashMap<String, PrivateEndpointConnectionImpl>();
            for (PrivateEndpointConnectionImpl privateEndpointConnection : privateEndpointConnections) {
                privateEndpointConnectionMap.put(privateEndpointConnection.name(), privateEndpointConnection);
            }
            return privateEndpointConnectionMap;
        });
    }

    public PagedFlux<PrivateEndpointConnectionImpl> listAsync() {
        PrivateEndpointConnectionsImpl self = this;
        return this.client.listByDatabaseAccountAsync(((CosmosDBAccountImpl)this.getParent()).resourceGroupName(), ((CosmosDBAccountImpl)this.getParent()).name()).mapPage(inner -> {
            PrivateEndpointConnectionImpl childResource = new PrivateEndpointConnectionImpl(inner.name(), (CosmosDBAccountImpl)self.getParent(), (PrivateEndpointConnectionInner)((Object)inner), this.client);
            self.addPrivateEndpointConnection(childResource);
            return childResource;
        });
    }

    public Mono<PrivateEndpointConnectionImpl> getImplAsync(String name) {
        PrivateEndpointConnectionsImpl self = this;
        return this.client.getAsync(((CosmosDBAccountImpl)this.getParent()).resourceGroupName(), ((CosmosDBAccountImpl)this.getParent()).name(), name).map(inner -> {
            PrivateEndpointConnectionImpl childResource = new PrivateEndpointConnectionImpl(inner.name(), (CosmosDBAccountImpl)this.getParent(), (PrivateEndpointConnectionInner)((Object)inner), this.client);
            self.addPrivateEndpointConnection(childResource);
            return childResource;
        });
    }

    protected Flux<PrivateEndpointConnectionImpl> listChildResourcesAsync() {
        return this.listAsync();
    }

    protected List<PrivateEndpointConnectionImpl> listChildResources() {
        return (List)this.listAsync().collectList().block();
    }

    protected PrivateEndpointConnectionImpl newChildResource(String name) {
        return new PrivateEndpointConnectionImpl(name, (CosmosDBAccountImpl)this.getParent(), new PrivateEndpointConnectionInner(), this.client);
    }

    public void addPrivateEndpointConnection(PrivateEndpointConnectionImpl privateEndpointConnection) {
        this.addChildResource(privateEndpointConnection);
    }
}

