/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cosmos.fluent.SqlResourcesClient;
import com.azure.resourcemanager.cosmos.fluent.models.SqlContainerGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.SqlDatabaseGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.SqlStoredProcedureGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.SqlTriggerGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.SqlUserDefinedFunctionGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.ThroughputSettingsGetResultsInner;
import com.azure.resourcemanager.cosmos.implementation.CosmosDBManagementClientImpl;
import com.azure.resourcemanager.cosmos.models.SqlContainerCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.SqlContainerListResult;
import com.azure.resourcemanager.cosmos.models.SqlDatabaseCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.SqlDatabaseListResult;
import com.azure.resourcemanager.cosmos.models.SqlStoredProcedureCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.SqlStoredProcedureListResult;
import com.azure.resourcemanager.cosmos.models.SqlTriggerCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.SqlTriggerListResult;
import com.azure.resourcemanager.cosmos.models.SqlUserDefinedFunctionCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.SqlUserDefinedFunctionListResult;
import com.azure.resourcemanager.cosmos.models.ThroughputSettingsUpdateParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class SqlResourcesClientImpl
implements SqlResourcesClient {
    private final ClientLogger logger = new ClientLogger(SqlResourcesClientImpl.class);
    private final SqlResourcesService service;
    private final CosmosDBManagementClientImpl client;

    SqlResourcesClientImpl(CosmosDBManagementClientImpl client) {
        this.service = (SqlResourcesService)RestProxy.create(SqlResourcesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<SqlDatabaseGetResultsInner>> listSqlDatabasesSinglePageAsync(String resourceGroupName, String accountName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.listSqlDatabases(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, "2019-08-01", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlDatabaseListResult)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<SqlDatabaseGetResultsInner>> listSqlDatabasesSinglePageAsync(String resourceGroupName, String accountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.listSqlDatabases(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, "2019-08-01", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlDatabaseListResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<SqlDatabaseGetResultsInner> listSqlDatabasesAsync(String resourceGroupName, String accountName) {
        return new PagedFlux(() -> this.listSqlDatabasesSinglePageAsync(resourceGroupName, accountName));
    }

    private PagedFlux<SqlDatabaseGetResultsInner> listSqlDatabasesAsync(String resourceGroupName, String accountName, Context context) {
        return new PagedFlux(() -> this.listSqlDatabasesSinglePageAsync(resourceGroupName, accountName, context));
    }

    @Override
    public PagedIterable<SqlDatabaseGetResultsInner> listSqlDatabases(String resourceGroupName, String accountName) {
        return new PagedIterable(this.listSqlDatabasesAsync(resourceGroupName, accountName));
    }

    @Override
    public PagedIterable<SqlDatabaseGetResultsInner> listSqlDatabases(String resourceGroupName, String accountName, Context context) {
        return new PagedIterable(this.listSqlDatabasesAsync(resourceGroupName, accountName, context));
    }

    @Override
    public Mono<Response<SqlDatabaseGetResultsInner>> getSqlDatabaseWithResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.getSqlDatabase(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<SqlDatabaseGetResultsInner>> getSqlDatabaseWithResponseAsync(String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.getSqlDatabase(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", context);
    }

    @Override
    public Mono<SqlDatabaseGetResultsInner> getSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.getSqlDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SqlDatabaseGetResultsInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public SqlDatabaseGetResultsInner getSqlDatabase(String resourceGroupName, String accountName, String databaseName) {
        return (SqlDatabaseGetResultsInner)((Object)this.getSqlDatabaseAsync(resourceGroupName, accountName, databaseName).block());
    }

    @Override
    public Response<SqlDatabaseGetResultsInner> getSqlDatabaseWithResponse(String resourceGroupName, String accountName, String databaseName, Context context) {
        return (Response)this.getSqlDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createUpdateSqlDatabaseWithResponseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (createUpdateSqlDatabaseParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter createUpdateSqlDatabaseParameters is required and cannot be null."));
        }
        createUpdateSqlDatabaseParameters.validate();
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.createUpdateSqlDatabase(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", createUpdateSqlDatabaseParameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> createUpdateSqlDatabaseWithResponseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (createUpdateSqlDatabaseParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter createUpdateSqlDatabaseParameters is required and cannot be null."));
        }
        createUpdateSqlDatabaseParameters.validate();
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.createUpdateSqlDatabase(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", createUpdateSqlDatabaseParameters, context);
    }

    @Override
    public PollerFlux<PollResult<SqlDatabaseGetResultsInner>, SqlDatabaseGetResultsInner> beginCreateUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createUpdateSqlDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SqlDatabaseGetResultsInner.class), (Type)((Object)SqlDatabaseGetResultsInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<SqlDatabaseGetResultsInner>, SqlDatabaseGetResultsInner> beginCreateUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createUpdateSqlDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SqlDatabaseGetResultsInner.class), (Type)((Object)SqlDatabaseGetResultsInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<SqlDatabaseGetResultsInner>, SqlDatabaseGetResultsInner> beginCreateUpdateSqlDatabase(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return this.beginCreateUpdateSqlDatabaseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<SqlDatabaseGetResultsInner>, SqlDatabaseGetResultsInner> beginCreateUpdateSqlDatabase(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters, Context context) {
        return this.beginCreateUpdateSqlDatabaseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters, context).getSyncPoller();
    }

    @Override
    public Mono<SqlDatabaseGetResultsInner> createUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return this.beginCreateUpdateSqlDatabaseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<SqlDatabaseGetResultsInner> createUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters, Context context) {
        return this.beginCreateUpdateSqlDatabaseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public SqlDatabaseGetResultsInner createUpdateSqlDatabase(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return (SqlDatabaseGetResultsInner)((Object)this.createUpdateSqlDatabaseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters).block());
    }

    @Override
    public SqlDatabaseGetResultsInner createUpdateSqlDatabase(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters, Context context) {
        return (SqlDatabaseGetResultsInner)((Object)this.createUpdateSqlDatabaseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteSqlDatabaseWithResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.deleteSqlDatabase(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteSqlDatabaseWithResponseAsync(String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.deleteSqlDatabase(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteSqlDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteSqlDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeleteSqlDatabase(String resourceGroupName, String accountName, String databaseName) {
        return this.beginDeleteSqlDatabaseAsync(resourceGroupName, accountName, databaseName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeleteSqlDatabase(String resourceGroupName, String accountName, String databaseName, Context context) {
        return this.beginDeleteSqlDatabaseAsync(resourceGroupName, accountName, databaseName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.beginDeleteSqlDatabaseAsync(resourceGroupName, accountName, databaseName).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, Context context) {
        return this.beginDeleteSqlDatabaseAsync(resourceGroupName, accountName, databaseName, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void deleteSqlDatabase(String resourceGroupName, String accountName, String databaseName) {
        this.deleteSqlDatabaseAsync(resourceGroupName, accountName, databaseName).block();
    }

    @Override
    public void deleteSqlDatabase(String resourceGroupName, String accountName, String databaseName, Context context) {
        this.deleteSqlDatabaseAsync(resourceGroupName, accountName, databaseName, context).block();
    }

    @Override
    public Mono<Response<ThroughputSettingsGetResultsInner>> getSqlDatabaseThroughputWithResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.getSqlDatabaseThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ThroughputSettingsGetResultsInner>> getSqlDatabaseThroughputWithResponseAsync(String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.getSqlDatabaseThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", context);
    }

    @Override
    public Mono<ThroughputSettingsGetResultsInner> getSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.getSqlDatabaseThroughputWithResponseAsync(resourceGroupName, accountName, databaseName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ThroughputSettingsGetResultsInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public ThroughputSettingsGetResultsInner getSqlDatabaseThroughput(String resourceGroupName, String accountName, String databaseName) {
        return (ThroughputSettingsGetResultsInner)((Object)this.getSqlDatabaseThroughputAsync(resourceGroupName, accountName, databaseName).block());
    }

    @Override
    public Response<ThroughputSettingsGetResultsInner> getSqlDatabaseThroughputWithResponse(String resourceGroupName, String accountName, String databaseName, Context context) {
        return (Response)this.getSqlDatabaseThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> updateSqlDatabaseThroughputWithResponseAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null."));
        }
        updateThroughputParameters.validate();
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.updateSqlDatabaseThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", updateThroughputParameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> updateSqlDatabaseThroughputWithResponseAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null."));
        }
        updateThroughputParameters.validate();
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.updateSqlDatabaseThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", updateThroughputParameters, context);
    }

    @Override
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginUpdateSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateSqlDatabaseThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ThroughputSettingsGetResultsInner.class), (Type)((Object)ThroughputSettingsGetResultsInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginUpdateSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateSqlDatabaseThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ThroughputSettingsGetResultsInner.class), (Type)((Object)ThroughputSettingsGetResultsInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginUpdateSqlDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.beginUpdateSqlDatabaseThroughputAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginUpdateSqlDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        return this.beginUpdateSqlDatabaseThroughputAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters, context).getSyncPoller();
    }

    @Override
    public Mono<ThroughputSettingsGetResultsInner> updateSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.beginUpdateSqlDatabaseThroughputAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<ThroughputSettingsGetResultsInner> updateSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        return this.beginUpdateSqlDatabaseThroughputAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public ThroughputSettingsGetResultsInner updateSqlDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return (ThroughputSettingsGetResultsInner)((Object)this.updateSqlDatabaseThroughputAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters).block());
    }

    @Override
    public ThroughputSettingsGetResultsInner updateSqlDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        return (ThroughputSettingsGetResultsInner)((Object)this.updateSqlDatabaseThroughputAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters, context).block());
    }

    private Mono<PagedResponse<SqlContainerGetResultsInner>> listSqlContainersSinglePageAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.listSqlContainers(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlContainerListResult)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<SqlContainerGetResultsInner>> listSqlContainersSinglePageAsync(String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.listSqlContainers(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlContainerListResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<SqlContainerGetResultsInner> listSqlContainersAsync(String resourceGroupName, String accountName, String databaseName) {
        return new PagedFlux(() -> this.listSqlContainersSinglePageAsync(resourceGroupName, accountName, databaseName));
    }

    private PagedFlux<SqlContainerGetResultsInner> listSqlContainersAsync(String resourceGroupName, String accountName, String databaseName, Context context) {
        return new PagedFlux(() -> this.listSqlContainersSinglePageAsync(resourceGroupName, accountName, databaseName, context));
    }

    @Override
    public PagedIterable<SqlContainerGetResultsInner> listSqlContainers(String resourceGroupName, String accountName, String databaseName) {
        return new PagedIterable(this.listSqlContainersAsync(resourceGroupName, accountName, databaseName));
    }

    @Override
    public PagedIterable<SqlContainerGetResultsInner> listSqlContainers(String resourceGroupName, String accountName, String databaseName, Context context) {
        return new PagedIterable(this.listSqlContainersAsync(resourceGroupName, accountName, databaseName, context));
    }

    @Override
    public Mono<Response<SqlContainerGetResultsInner>> getSqlContainerWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.getSqlContainer(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<SqlContainerGetResultsInner>> getSqlContainerWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.getSqlContainer(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", context);
    }

    @Override
    public Mono<SqlContainerGetResultsInner> getSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return this.getSqlContainerWithResponseAsync(resourceGroupName, accountName, databaseName, containerName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SqlContainerGetResultsInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public SqlContainerGetResultsInner getSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return (SqlContainerGetResultsInner)((Object)this.getSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName).block());
    }

    @Override
    public Response<SqlContainerGetResultsInner> getSqlContainerWithResponse(String resourceGroupName, String accountName, String databaseName, String containerName, Context context) {
        return (Response)this.getSqlContainerWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createUpdateSqlContainerWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (createUpdateSqlContainerParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter createUpdateSqlContainerParameters is required and cannot be null."));
        }
        createUpdateSqlContainerParameters.validate();
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.createUpdateSqlContainer(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", createUpdateSqlContainerParameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> createUpdateSqlContainerWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (createUpdateSqlContainerParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter createUpdateSqlContainerParameters is required and cannot be null."));
        }
        createUpdateSqlContainerParameters.validate();
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.createUpdateSqlContainer(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", createUpdateSqlContainerParameters, context);
    }

    @Override
    public PollerFlux<PollResult<SqlContainerGetResultsInner>, SqlContainerGetResultsInner> beginCreateUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createUpdateSqlContainerWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SqlContainerGetResultsInner.class), (Type)((Object)SqlContainerGetResultsInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<SqlContainerGetResultsInner>, SqlContainerGetResultsInner> beginCreateUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createUpdateSqlContainerWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SqlContainerGetResultsInner.class), (Type)((Object)SqlContainerGetResultsInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<SqlContainerGetResultsInner>, SqlContainerGetResultsInner> beginCreateUpdateSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return this.beginCreateUpdateSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<SqlContainerGetResultsInner>, SqlContainerGetResultsInner> beginCreateUpdateSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters, Context context) {
        return this.beginCreateUpdateSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters, context).getSyncPoller();
    }

    @Override
    public Mono<SqlContainerGetResultsInner> createUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return this.beginCreateUpdateSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<SqlContainerGetResultsInner> createUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters, Context context) {
        return this.beginCreateUpdateSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public SqlContainerGetResultsInner createUpdateSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return (SqlContainerGetResultsInner)((Object)this.createUpdateSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters).block());
    }

    @Override
    public SqlContainerGetResultsInner createUpdateSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters, Context context) {
        return (SqlContainerGetResultsInner)((Object)this.createUpdateSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteSqlContainerWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.deleteSqlContainer(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteSqlContainerWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.deleteSqlContainer(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteSqlContainerWithResponseAsync(resourceGroupName, accountName, databaseName, containerName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteSqlContainerWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeleteSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return this.beginDeleteSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeleteSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName, Context context) {
        return this.beginDeleteSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return this.beginDeleteSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, Context context) {
        return this.beginDeleteSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void deleteSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName) {
        this.deleteSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName).block();
    }

    @Override
    public void deleteSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName, Context context) {
        this.deleteSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName, context).block();
    }

    @Override
    public Mono<Response<ThroughputSettingsGetResultsInner>> getSqlContainerThroughputWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.getSqlContainerThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ThroughputSettingsGetResultsInner>> getSqlContainerThroughputWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.getSqlContainerThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", context);
    }

    @Override
    public Mono<ThroughputSettingsGetResultsInner> getSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return this.getSqlContainerThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, containerName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ThroughputSettingsGetResultsInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public ThroughputSettingsGetResultsInner getSqlContainerThroughput(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return (ThroughputSettingsGetResultsInner)((Object)this.getSqlContainerThroughputAsync(resourceGroupName, accountName, databaseName, containerName).block());
    }

    @Override
    public Response<ThroughputSettingsGetResultsInner> getSqlContainerThroughputWithResponse(String resourceGroupName, String accountName, String databaseName, String containerName, Context context) {
        return (Response)this.getSqlContainerThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> updateSqlContainerThroughputWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null."));
        }
        updateThroughputParameters.validate();
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.updateSqlContainerThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", updateThroughputParameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> updateSqlContainerThroughputWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null."));
        }
        updateThroughputParameters.validate();
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.updateSqlContainerThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", updateThroughputParameters, context);
    }

    @Override
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginUpdateSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateSqlContainerThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, updateThroughputParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ThroughputSettingsGetResultsInner.class), (Type)((Object)ThroughputSettingsGetResultsInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginUpdateSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateSqlContainerThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, updateThroughputParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ThroughputSettingsGetResultsInner.class), (Type)((Object)ThroughputSettingsGetResultsInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginUpdateSqlContainerThroughput(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.beginUpdateSqlContainerThroughputAsync(resourceGroupName, accountName, databaseName, containerName, updateThroughputParameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginUpdateSqlContainerThroughput(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        return this.beginUpdateSqlContainerThroughputAsync(resourceGroupName, accountName, databaseName, containerName, updateThroughputParameters, context).getSyncPoller();
    }

    @Override
    public Mono<ThroughputSettingsGetResultsInner> updateSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.beginUpdateSqlContainerThroughputAsync(resourceGroupName, accountName, databaseName, containerName, updateThroughputParameters).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<ThroughputSettingsGetResultsInner> updateSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        return this.beginUpdateSqlContainerThroughputAsync(resourceGroupName, accountName, databaseName, containerName, updateThroughputParameters, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public ThroughputSettingsGetResultsInner updateSqlContainerThroughput(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return (ThroughputSettingsGetResultsInner)((Object)this.updateSqlContainerThroughputAsync(resourceGroupName, accountName, databaseName, containerName, updateThroughputParameters).block());
    }

    @Override
    public ThroughputSettingsGetResultsInner updateSqlContainerThroughput(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        return (ThroughputSettingsGetResultsInner)((Object)this.updateSqlContainerThroughputAsync(resourceGroupName, accountName, databaseName, containerName, updateThroughputParameters, context).block());
    }

    private Mono<PagedResponse<SqlStoredProcedureGetResultsInner>> listSqlStoredProceduresSinglePageAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.listSqlStoredProcedures(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlStoredProcedureListResult)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<SqlStoredProcedureGetResultsInner>> listSqlStoredProceduresSinglePageAsync(String resourceGroupName, String accountName, String databaseName, String containerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.listSqlStoredProcedures(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlStoredProcedureListResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<SqlStoredProcedureGetResultsInner> listSqlStoredProceduresAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return new PagedFlux(() -> this.listSqlStoredProceduresSinglePageAsync(resourceGroupName, accountName, databaseName, containerName));
    }

    private PagedFlux<SqlStoredProcedureGetResultsInner> listSqlStoredProceduresAsync(String resourceGroupName, String accountName, String databaseName, String containerName, Context context) {
        return new PagedFlux(() -> this.listSqlStoredProceduresSinglePageAsync(resourceGroupName, accountName, databaseName, containerName, context));
    }

    @Override
    public PagedIterable<SqlStoredProcedureGetResultsInner> listSqlStoredProcedures(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return new PagedIterable(this.listSqlStoredProceduresAsync(resourceGroupName, accountName, databaseName, containerName));
    }

    @Override
    public PagedIterable<SqlStoredProcedureGetResultsInner> listSqlStoredProcedures(String resourceGroupName, String accountName, String databaseName, String containerName, Context context) {
        return new PagedIterable(this.listSqlStoredProceduresAsync(resourceGroupName, accountName, databaseName, containerName, context));
    }

    @Override
    public Mono<Response<SqlStoredProcedureGetResultsInner>> getSqlStoredProcedureWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (storedProcedureName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storedProcedureName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.getSqlStoredProcedure(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, storedProcedureName, "2019-08-01", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<SqlStoredProcedureGetResultsInner>> getSqlStoredProcedureWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (storedProcedureName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storedProcedureName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.getSqlStoredProcedure(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, storedProcedureName, "2019-08-01", context);
    }

    @Override
    public Mono<SqlStoredProcedureGetResultsInner> getSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        return this.getSqlStoredProcedureWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SqlStoredProcedureGetResultsInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public SqlStoredProcedureGetResultsInner getSqlStoredProcedure(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        return (SqlStoredProcedureGetResultsInner)((Object)this.getSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName).block());
    }

    @Override
    public Response<SqlStoredProcedureGetResultsInner> getSqlStoredProcedureWithResponse(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, Context context) {
        return (Response)this.getSqlStoredProcedureWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createUpdateSqlStoredProcedureWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (storedProcedureName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storedProcedureName is required and cannot be null."));
        }
        if (createUpdateSqlStoredProcedureParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter createUpdateSqlStoredProcedureParameters is required and cannot be null."));
        }
        createUpdateSqlStoredProcedureParameters.validate();
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.createUpdateSqlStoredProcedure(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, storedProcedureName, "2019-08-01", createUpdateSqlStoredProcedureParameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> createUpdateSqlStoredProcedureWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (storedProcedureName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storedProcedureName is required and cannot be null."));
        }
        if (createUpdateSqlStoredProcedureParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter createUpdateSqlStoredProcedureParameters is required and cannot be null."));
        }
        createUpdateSqlStoredProcedureParameters.validate();
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.createUpdateSqlStoredProcedure(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, storedProcedureName, "2019-08-01", createUpdateSqlStoredProcedureParameters, context);
    }

    @Override
    public PollerFlux<PollResult<SqlStoredProcedureGetResultsInner>, SqlStoredProcedureGetResultsInner> beginCreateUpdateSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createUpdateSqlStoredProcedureWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, createUpdateSqlStoredProcedureParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SqlStoredProcedureGetResultsInner.class), (Type)((Object)SqlStoredProcedureGetResultsInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<SqlStoredProcedureGetResultsInner>, SqlStoredProcedureGetResultsInner> beginCreateUpdateSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createUpdateSqlStoredProcedureWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, createUpdateSqlStoredProcedureParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SqlStoredProcedureGetResultsInner.class), (Type)((Object)SqlStoredProcedureGetResultsInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<SqlStoredProcedureGetResultsInner>, SqlStoredProcedureGetResultsInner> beginCreateUpdateSqlStoredProcedure(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters) {
        return this.beginCreateUpdateSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, createUpdateSqlStoredProcedureParameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<SqlStoredProcedureGetResultsInner>, SqlStoredProcedureGetResultsInner> beginCreateUpdateSqlStoredProcedure(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters, Context context) {
        return this.beginCreateUpdateSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, createUpdateSqlStoredProcedureParameters, context).getSyncPoller();
    }

    @Override
    public Mono<SqlStoredProcedureGetResultsInner> createUpdateSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters) {
        return this.beginCreateUpdateSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, createUpdateSqlStoredProcedureParameters).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<SqlStoredProcedureGetResultsInner> createUpdateSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters, Context context) {
        return this.beginCreateUpdateSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, createUpdateSqlStoredProcedureParameters, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public SqlStoredProcedureGetResultsInner createUpdateSqlStoredProcedure(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters) {
        return (SqlStoredProcedureGetResultsInner)((Object)this.createUpdateSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, createUpdateSqlStoredProcedureParameters).block());
    }

    @Override
    public SqlStoredProcedureGetResultsInner createUpdateSqlStoredProcedure(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters, Context context) {
        return (SqlStoredProcedureGetResultsInner)((Object)this.createUpdateSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, createUpdateSqlStoredProcedureParameters, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteSqlStoredProcedureWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (storedProcedureName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storedProcedureName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.deleteSqlStoredProcedure(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, storedProcedureName, "2019-08-01", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteSqlStoredProcedureWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (storedProcedureName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storedProcedureName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.deleteSqlStoredProcedure(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, storedProcedureName, "2019-08-01", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteSqlStoredProcedureWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteSqlStoredProcedureWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeleteSqlStoredProcedure(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        return this.beginDeleteSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeleteSqlStoredProcedure(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, Context context) {
        return this.beginDeleteSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        return this.beginDeleteSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, Context context) {
        return this.beginDeleteSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void deleteSqlStoredProcedure(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        this.deleteSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName).block();
    }

    @Override
    public void deleteSqlStoredProcedure(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, Context context) {
        this.deleteSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, context).block();
    }

    private Mono<PagedResponse<SqlUserDefinedFunctionGetResultsInner>> listSqlUserDefinedFunctionsSinglePageAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.listSqlUserDefinedFunctions(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlUserDefinedFunctionListResult)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<SqlUserDefinedFunctionGetResultsInner>> listSqlUserDefinedFunctionsSinglePageAsync(String resourceGroupName, String accountName, String databaseName, String containerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.listSqlUserDefinedFunctions(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlUserDefinedFunctionListResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<SqlUserDefinedFunctionGetResultsInner> listSqlUserDefinedFunctionsAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return new PagedFlux(() -> this.listSqlUserDefinedFunctionsSinglePageAsync(resourceGroupName, accountName, databaseName, containerName));
    }

    private PagedFlux<SqlUserDefinedFunctionGetResultsInner> listSqlUserDefinedFunctionsAsync(String resourceGroupName, String accountName, String databaseName, String containerName, Context context) {
        return new PagedFlux(() -> this.listSqlUserDefinedFunctionsSinglePageAsync(resourceGroupName, accountName, databaseName, containerName, context));
    }

    @Override
    public PagedIterable<SqlUserDefinedFunctionGetResultsInner> listSqlUserDefinedFunctions(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return new PagedIterable(this.listSqlUserDefinedFunctionsAsync(resourceGroupName, accountName, databaseName, containerName));
    }

    @Override
    public PagedIterable<SqlUserDefinedFunctionGetResultsInner> listSqlUserDefinedFunctions(String resourceGroupName, String accountName, String databaseName, String containerName, Context context) {
        return new PagedIterable(this.listSqlUserDefinedFunctionsAsync(resourceGroupName, accountName, databaseName, containerName, context));
    }

    @Override
    public Mono<Response<SqlUserDefinedFunctionGetResultsInner>> getSqlUserDefinedFunctionWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (userDefinedFunctionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userDefinedFunctionName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.getSqlUserDefinedFunction(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, "2019-08-01", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<SqlUserDefinedFunctionGetResultsInner>> getSqlUserDefinedFunctionWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (userDefinedFunctionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userDefinedFunctionName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.getSqlUserDefinedFunction(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, "2019-08-01", context);
    }

    @Override
    public Mono<SqlUserDefinedFunctionGetResultsInner> getSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        return this.getSqlUserDefinedFunctionWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SqlUserDefinedFunctionGetResultsInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public SqlUserDefinedFunctionGetResultsInner getSqlUserDefinedFunction(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        return (SqlUserDefinedFunctionGetResultsInner)((Object)this.getSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName).block());
    }

    @Override
    public Response<SqlUserDefinedFunctionGetResultsInner> getSqlUserDefinedFunctionWithResponse(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, Context context) {
        return (Response)this.getSqlUserDefinedFunctionWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createUpdateSqlUserDefinedFunctionWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (userDefinedFunctionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userDefinedFunctionName is required and cannot be null."));
        }
        if (createUpdateSqlUserDefinedFunctionParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter createUpdateSqlUserDefinedFunctionParameters is required and cannot be null."));
        }
        createUpdateSqlUserDefinedFunctionParameters.validate();
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.createUpdateSqlUserDefinedFunction(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, "2019-08-01", createUpdateSqlUserDefinedFunctionParameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> createUpdateSqlUserDefinedFunctionWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (userDefinedFunctionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userDefinedFunctionName is required and cannot be null."));
        }
        if (createUpdateSqlUserDefinedFunctionParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter createUpdateSqlUserDefinedFunctionParameters is required and cannot be null."));
        }
        createUpdateSqlUserDefinedFunctionParameters.validate();
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.createUpdateSqlUserDefinedFunction(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, "2019-08-01", createUpdateSqlUserDefinedFunctionParameters, context);
    }

    @Override
    public PollerFlux<PollResult<SqlUserDefinedFunctionGetResultsInner>, SqlUserDefinedFunctionGetResultsInner> beginCreateUpdateSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createUpdateSqlUserDefinedFunctionWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SqlUserDefinedFunctionGetResultsInner.class), (Type)((Object)SqlUserDefinedFunctionGetResultsInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<SqlUserDefinedFunctionGetResultsInner>, SqlUserDefinedFunctionGetResultsInner> beginCreateUpdateSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createUpdateSqlUserDefinedFunctionWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SqlUserDefinedFunctionGetResultsInner.class), (Type)((Object)SqlUserDefinedFunctionGetResultsInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<SqlUserDefinedFunctionGetResultsInner>, SqlUserDefinedFunctionGetResultsInner> beginCreateUpdateSqlUserDefinedFunction(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters) {
        return this.beginCreateUpdateSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<SqlUserDefinedFunctionGetResultsInner>, SqlUserDefinedFunctionGetResultsInner> beginCreateUpdateSqlUserDefinedFunction(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters, Context context) {
        return this.beginCreateUpdateSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters, context).getSyncPoller();
    }

    @Override
    public Mono<SqlUserDefinedFunctionGetResultsInner> createUpdateSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters) {
        return this.beginCreateUpdateSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<SqlUserDefinedFunctionGetResultsInner> createUpdateSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters, Context context) {
        return this.beginCreateUpdateSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public SqlUserDefinedFunctionGetResultsInner createUpdateSqlUserDefinedFunction(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters) {
        return (SqlUserDefinedFunctionGetResultsInner)((Object)this.createUpdateSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters).block());
    }

    @Override
    public SqlUserDefinedFunctionGetResultsInner createUpdateSqlUserDefinedFunction(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters, Context context) {
        return (SqlUserDefinedFunctionGetResultsInner)((Object)this.createUpdateSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteSqlUserDefinedFunctionWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (userDefinedFunctionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userDefinedFunctionName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.deleteSqlUserDefinedFunction(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, "2019-08-01", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteSqlUserDefinedFunctionWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (userDefinedFunctionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userDefinedFunctionName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.deleteSqlUserDefinedFunction(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, "2019-08-01", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteSqlUserDefinedFunctionWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteSqlUserDefinedFunctionWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeleteSqlUserDefinedFunction(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        return this.beginDeleteSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeleteSqlUserDefinedFunction(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, Context context) {
        return this.beginDeleteSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        return this.beginDeleteSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, Context context) {
        return this.beginDeleteSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void deleteSqlUserDefinedFunction(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        this.deleteSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName).block();
    }

    @Override
    public void deleteSqlUserDefinedFunction(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, Context context) {
        this.deleteSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, context).block();
    }

    private Mono<PagedResponse<SqlTriggerGetResultsInner>> listSqlTriggersSinglePageAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.listSqlTriggers(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlTriggerListResult)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<SqlTriggerGetResultsInner>> listSqlTriggersSinglePageAsync(String resourceGroupName, String accountName, String databaseName, String containerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.listSqlTriggers(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlTriggerListResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<SqlTriggerGetResultsInner> listSqlTriggersAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return new PagedFlux(() -> this.listSqlTriggersSinglePageAsync(resourceGroupName, accountName, databaseName, containerName));
    }

    private PagedFlux<SqlTriggerGetResultsInner> listSqlTriggersAsync(String resourceGroupName, String accountName, String databaseName, String containerName, Context context) {
        return new PagedFlux(() -> this.listSqlTriggersSinglePageAsync(resourceGroupName, accountName, databaseName, containerName, context));
    }

    @Override
    public PagedIterable<SqlTriggerGetResultsInner> listSqlTriggers(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return new PagedIterable(this.listSqlTriggersAsync(resourceGroupName, accountName, databaseName, containerName));
    }

    @Override
    public PagedIterable<SqlTriggerGetResultsInner> listSqlTriggers(String resourceGroupName, String accountName, String databaseName, String containerName, Context context) {
        return new PagedIterable(this.listSqlTriggersAsync(resourceGroupName, accountName, databaseName, containerName, context));
    }

    @Override
    public Mono<Response<SqlTriggerGetResultsInner>> getSqlTriggerWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (triggerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter triggerName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.getSqlTrigger(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, triggerName, "2019-08-01", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<SqlTriggerGetResultsInner>> getSqlTriggerWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (triggerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter triggerName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.getSqlTrigger(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, triggerName, "2019-08-01", context);
    }

    @Override
    public Mono<SqlTriggerGetResultsInner> getSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        return this.getSqlTriggerWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SqlTriggerGetResultsInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public SqlTriggerGetResultsInner getSqlTrigger(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        return (SqlTriggerGetResultsInner)((Object)this.getSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName, triggerName).block());
    }

    @Override
    public Response<SqlTriggerGetResultsInner> getSqlTriggerWithResponse(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, Context context) {
        return (Response)this.getSqlTriggerWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createUpdateSqlTriggerWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (triggerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter triggerName is required and cannot be null."));
        }
        if (createUpdateSqlTriggerParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter createUpdateSqlTriggerParameters is required and cannot be null."));
        }
        createUpdateSqlTriggerParameters.validate();
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.createUpdateSqlTrigger(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, triggerName, "2019-08-01", createUpdateSqlTriggerParameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> createUpdateSqlTriggerWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (triggerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter triggerName is required and cannot be null."));
        }
        if (createUpdateSqlTriggerParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter createUpdateSqlTriggerParameters is required and cannot be null."));
        }
        createUpdateSqlTriggerParameters.validate();
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.createUpdateSqlTrigger(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, triggerName, "2019-08-01", createUpdateSqlTriggerParameters, context);
    }

    @Override
    public PollerFlux<PollResult<SqlTriggerGetResultsInner>, SqlTriggerGetResultsInner> beginCreateUpdateSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createUpdateSqlTriggerWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, createUpdateSqlTriggerParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SqlTriggerGetResultsInner.class), (Type)((Object)SqlTriggerGetResultsInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<SqlTriggerGetResultsInner>, SqlTriggerGetResultsInner> beginCreateUpdateSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createUpdateSqlTriggerWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, createUpdateSqlTriggerParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SqlTriggerGetResultsInner.class), (Type)((Object)SqlTriggerGetResultsInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<SqlTriggerGetResultsInner>, SqlTriggerGetResultsInner> beginCreateUpdateSqlTrigger(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters) {
        return this.beginCreateUpdateSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, createUpdateSqlTriggerParameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<SqlTriggerGetResultsInner>, SqlTriggerGetResultsInner> beginCreateUpdateSqlTrigger(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters, Context context) {
        return this.beginCreateUpdateSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, createUpdateSqlTriggerParameters, context).getSyncPoller();
    }

    @Override
    public Mono<SqlTriggerGetResultsInner> createUpdateSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters) {
        return this.beginCreateUpdateSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, createUpdateSqlTriggerParameters).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<SqlTriggerGetResultsInner> createUpdateSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters, Context context) {
        return this.beginCreateUpdateSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, createUpdateSqlTriggerParameters, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public SqlTriggerGetResultsInner createUpdateSqlTrigger(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters) {
        return (SqlTriggerGetResultsInner)((Object)this.createUpdateSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, createUpdateSqlTriggerParameters).block());
    }

    @Override
    public SqlTriggerGetResultsInner createUpdateSqlTrigger(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters, Context context) {
        return (SqlTriggerGetResultsInner)((Object)this.createUpdateSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, createUpdateSqlTriggerParameters, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteSqlTriggerWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (triggerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter triggerName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.deleteSqlTrigger(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, triggerName, "2019-08-01", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteSqlTriggerWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (triggerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter triggerName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.deleteSqlTrigger(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName, triggerName, "2019-08-01", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteSqlTriggerWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteSqlTriggerWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeleteSqlTrigger(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        return this.beginDeleteSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName, triggerName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeleteSqlTrigger(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, Context context) {
        return this.beginDeleteSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        return this.beginDeleteSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName, triggerName).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, Context context) {
        return this.beginDeleteSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void deleteSqlTrigger(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        this.deleteSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName, triggerName).block();
    }

    @Override
    public void deleteSqlTrigger(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, Context context) {
        this.deleteSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CosmosDBManagementCl")
    private static interface SqlResourcesService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlDatabaseListResult>> listSqlDatabases(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlDatabaseGetResultsInner>> getSqlDatabase(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createUpdateSqlDatabase(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") SqlDatabaseCreateUpdateParameters var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> deleteSqlDatabase(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/throughputSettings/default")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ThroughputSettingsGetResultsInner>> getSqlDatabaseThroughput(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/throughputSettings/default")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> updateSqlDatabaseThroughput(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ThroughputSettingsUpdateParameters var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlContainerListResult>> listSqlContainers(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlContainerGetResultsInner>> getSqlContainer(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="containerName") String var6, @QueryParam(value="api-version") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createUpdateSqlContainer(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="containerName") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") SqlContainerCreateUpdateParameters var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> deleteSqlContainer(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="containerName") String var6, @QueryParam(value="api-version") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/throughputSettings/default")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ThroughputSettingsGetResultsInner>> getSqlContainerThroughput(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="containerName") String var6, @QueryParam(value="api-version") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/throughputSettings/default")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> updateSqlContainerThroughput(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="containerName") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") ThroughputSettingsUpdateParameters var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlStoredProcedureListResult>> listSqlStoredProcedures(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="containerName") String var6, @QueryParam(value="api-version") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures/{storedProcedureName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlStoredProcedureGetResultsInner>> getSqlStoredProcedure(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="containerName") String var6, @PathParam(value="storedProcedureName") String var7, @QueryParam(value="api-version") String var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures/{storedProcedureName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createUpdateSqlStoredProcedure(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="containerName") String var6, @PathParam(value="storedProcedureName") String var7, @QueryParam(value="api-version") String var8, @BodyParam(value="application/json") SqlStoredProcedureCreateUpdateParameters var9, Context var10);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures/{storedProcedureName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> deleteSqlStoredProcedure(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="containerName") String var6, @PathParam(value="storedProcedureName") String var7, @QueryParam(value="api-version") String var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlUserDefinedFunctionListResult>> listSqlUserDefinedFunctions(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="containerName") String var6, @QueryParam(value="api-version") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions/{userDefinedFunctionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlUserDefinedFunctionGetResultsInner>> getSqlUserDefinedFunction(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="containerName") String var6, @PathParam(value="userDefinedFunctionName") String var7, @QueryParam(value="api-version") String var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions/{userDefinedFunctionName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createUpdateSqlUserDefinedFunction(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="containerName") String var6, @PathParam(value="userDefinedFunctionName") String var7, @QueryParam(value="api-version") String var8, @BodyParam(value="application/json") SqlUserDefinedFunctionCreateUpdateParameters var9, Context var10);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions/{userDefinedFunctionName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> deleteSqlUserDefinedFunction(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="containerName") String var6, @PathParam(value="userDefinedFunctionName") String var7, @QueryParam(value="api-version") String var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlTriggerListResult>> listSqlTriggers(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="containerName") String var6, @QueryParam(value="api-version") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers/{triggerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlTriggerGetResultsInner>> getSqlTrigger(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="containerName") String var6, @PathParam(value="triggerName") String var7, @QueryParam(value="api-version") String var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers/{triggerName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createUpdateSqlTrigger(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="containerName") String var6, @PathParam(value="triggerName") String var7, @QueryParam(value="api-version") String var8, @BodyParam(value="application/json") SqlTriggerCreateUpdateParameters var9, Context var10);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers/{triggerName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> deleteSqlTrigger(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="containerName") String var6, @PathParam(value="triggerName") String var7, @QueryParam(value="api-version") String var8, Context var9);
    }
}

