/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cosmos.fluent.TableResourcesClient;
import com.azure.resourcemanager.cosmos.fluent.models.TableGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.ThroughputSettingsGetResultsInner;
import com.azure.resourcemanager.cosmos.implementation.CosmosDBManagementClientImpl;
import com.azure.resourcemanager.cosmos.models.TableCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.TableListResult;
import com.azure.resourcemanager.cosmos.models.ThroughputSettingsUpdateParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class TableResourcesClientImpl
implements TableResourcesClient {
    private final ClientLogger logger = new ClientLogger(TableResourcesClientImpl.class);
    private final TableResourcesService service;
    private final CosmosDBManagementClientImpl client;

    TableResourcesClientImpl(CosmosDBManagementClientImpl client) {
        this.service = (TableResourcesService)RestProxy.create(TableResourcesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<TableGetResultsInner>> listTablesSinglePageAsync(String resourceGroupName, String accountName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.listTables(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, "2019-08-01", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TableListResult)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<TableGetResultsInner>> listTablesSinglePageAsync(String resourceGroupName, String accountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.listTables(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, "2019-08-01", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TableListResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<TableGetResultsInner> listTablesAsync(String resourceGroupName, String accountName) {
        return new PagedFlux(() -> this.listTablesSinglePageAsync(resourceGroupName, accountName));
    }

    private PagedFlux<TableGetResultsInner> listTablesAsync(String resourceGroupName, String accountName, Context context) {
        return new PagedFlux(() -> this.listTablesSinglePageAsync(resourceGroupName, accountName, context));
    }

    @Override
    public PagedIterable<TableGetResultsInner> listTables(String resourceGroupName, String accountName) {
        return new PagedIterable(this.listTablesAsync(resourceGroupName, accountName));
    }

    @Override
    public PagedIterable<TableGetResultsInner> listTables(String resourceGroupName, String accountName, Context context) {
        return new PagedIterable(this.listTablesAsync(resourceGroupName, accountName, context));
    }

    @Override
    public Mono<Response<TableGetResultsInner>> getTableWithResponseAsync(String resourceGroupName, String accountName, String tableName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (tableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tableName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.getTable(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, tableName, "2019-08-01", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<TableGetResultsInner>> getTableWithResponseAsync(String resourceGroupName, String accountName, String tableName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (tableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tableName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.getTable(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, tableName, "2019-08-01", context);
    }

    @Override
    public Mono<TableGetResultsInner> getTableAsync(String resourceGroupName, String accountName, String tableName) {
        return this.getTableWithResponseAsync(resourceGroupName, accountName, tableName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((TableGetResultsInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public TableGetResultsInner getTable(String resourceGroupName, String accountName, String tableName) {
        return (TableGetResultsInner)((Object)this.getTableAsync(resourceGroupName, accountName, tableName).block());
    }

    @Override
    public Response<TableGetResultsInner> getTableWithResponse(String resourceGroupName, String accountName, String tableName, Context context) {
        return (Response)this.getTableWithResponseAsync(resourceGroupName, accountName, tableName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createUpdateTableWithResponseAsync(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (tableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tableName is required and cannot be null."));
        }
        if (createUpdateTableParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter createUpdateTableParameters is required and cannot be null."));
        }
        createUpdateTableParameters.validate();
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.createUpdateTable(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, tableName, "2019-08-01", createUpdateTableParameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> createUpdateTableWithResponseAsync(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (tableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tableName is required and cannot be null."));
        }
        if (createUpdateTableParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter createUpdateTableParameters is required and cannot be null."));
        }
        createUpdateTableParameters.validate();
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.createUpdateTable(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, tableName, "2019-08-01", createUpdateTableParameters, context);
    }

    @Override
    public PollerFlux<PollResult<TableGetResultsInner>, TableGetResultsInner> beginCreateUpdateTableAsync(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createUpdateTableWithResponseAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)TableGetResultsInner.class), (Type)((Object)TableGetResultsInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<TableGetResultsInner>, TableGetResultsInner> beginCreateUpdateTableAsync(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createUpdateTableWithResponseAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)TableGetResultsInner.class), (Type)((Object)TableGetResultsInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<TableGetResultsInner>, TableGetResultsInner> beginCreateUpdateTable(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters) {
        return this.beginCreateUpdateTableAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<TableGetResultsInner>, TableGetResultsInner> beginCreateUpdateTable(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters, Context context) {
        return this.beginCreateUpdateTableAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters, context).getSyncPoller();
    }

    @Override
    public Mono<TableGetResultsInner> createUpdateTableAsync(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters) {
        return this.beginCreateUpdateTableAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<TableGetResultsInner> createUpdateTableAsync(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters, Context context) {
        return this.beginCreateUpdateTableAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public TableGetResultsInner createUpdateTable(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters) {
        return (TableGetResultsInner)((Object)this.createUpdateTableAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters).block());
    }

    @Override
    public TableGetResultsInner createUpdateTable(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters, Context context) {
        return (TableGetResultsInner)((Object)this.createUpdateTableAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteTableWithResponseAsync(String resourceGroupName, String accountName, String tableName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (tableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tableName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.deleteTable(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, tableName, "2019-08-01", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteTableWithResponseAsync(String resourceGroupName, String accountName, String tableName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (tableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tableName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.deleteTable(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, tableName, "2019-08-01", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteTableAsync(String resourceGroupName, String accountName, String tableName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteTableWithResponseAsync(resourceGroupName, accountName, tableName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteTableAsync(String resourceGroupName, String accountName, String tableName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteTableWithResponseAsync(resourceGroupName, accountName, tableName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeleteTable(String resourceGroupName, String accountName, String tableName) {
        return this.beginDeleteTableAsync(resourceGroupName, accountName, tableName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeleteTable(String resourceGroupName, String accountName, String tableName, Context context) {
        return this.beginDeleteTableAsync(resourceGroupName, accountName, tableName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteTableAsync(String resourceGroupName, String accountName, String tableName) {
        return this.beginDeleteTableAsync(resourceGroupName, accountName, tableName).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteTableAsync(String resourceGroupName, String accountName, String tableName, Context context) {
        return this.beginDeleteTableAsync(resourceGroupName, accountName, tableName, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void deleteTable(String resourceGroupName, String accountName, String tableName) {
        this.deleteTableAsync(resourceGroupName, accountName, tableName).block();
    }

    @Override
    public void deleteTable(String resourceGroupName, String accountName, String tableName, Context context) {
        this.deleteTableAsync(resourceGroupName, accountName, tableName, context).block();
    }

    @Override
    public Mono<Response<ThroughputSettingsGetResultsInner>> getTableThroughputWithResponseAsync(String resourceGroupName, String accountName, String tableName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (tableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tableName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.getTableThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, tableName, "2019-08-01", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ThroughputSettingsGetResultsInner>> getTableThroughputWithResponseAsync(String resourceGroupName, String accountName, String tableName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (tableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tableName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.getTableThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, tableName, "2019-08-01", context);
    }

    @Override
    public Mono<ThroughputSettingsGetResultsInner> getTableThroughputAsync(String resourceGroupName, String accountName, String tableName) {
        return this.getTableThroughputWithResponseAsync(resourceGroupName, accountName, tableName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ThroughputSettingsGetResultsInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public ThroughputSettingsGetResultsInner getTableThroughput(String resourceGroupName, String accountName, String tableName) {
        return (ThroughputSettingsGetResultsInner)((Object)this.getTableThroughputAsync(resourceGroupName, accountName, tableName).block());
    }

    @Override
    public Response<ThroughputSettingsGetResultsInner> getTableThroughputWithResponse(String resourceGroupName, String accountName, String tableName, Context context) {
        return (Response)this.getTableThroughputWithResponseAsync(resourceGroupName, accountName, tableName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> updateTableThroughputWithResponseAsync(String resourceGroupName, String accountName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (tableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tableName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null."));
        }
        updateThroughputParameters.validate();
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.updateTableThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, tableName, "2019-08-01", updateThroughputParameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> updateTableThroughputWithResponseAsync(String resourceGroupName, String accountName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (tableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tableName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null."));
        }
        updateThroughputParameters.validate();
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.updateTableThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, tableName, "2019-08-01", updateThroughputParameters, context);
    }

    @Override
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginUpdateTableThroughputAsync(String resourceGroupName, String accountName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateTableThroughputWithResponseAsync(resourceGroupName, accountName, tableName, updateThroughputParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ThroughputSettingsGetResultsInner.class), (Type)((Object)ThroughputSettingsGetResultsInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginUpdateTableThroughputAsync(String resourceGroupName, String accountName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateTableThroughputWithResponseAsync(resourceGroupName, accountName, tableName, updateThroughputParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ThroughputSettingsGetResultsInner.class), (Type)((Object)ThroughputSettingsGetResultsInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginUpdateTableThroughput(String resourceGroupName, String accountName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.beginUpdateTableThroughputAsync(resourceGroupName, accountName, tableName, updateThroughputParameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginUpdateTableThroughput(String resourceGroupName, String accountName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        return this.beginUpdateTableThroughputAsync(resourceGroupName, accountName, tableName, updateThroughputParameters, context).getSyncPoller();
    }

    @Override
    public Mono<ThroughputSettingsGetResultsInner> updateTableThroughputAsync(String resourceGroupName, String accountName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.beginUpdateTableThroughputAsync(resourceGroupName, accountName, tableName, updateThroughputParameters).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<ThroughputSettingsGetResultsInner> updateTableThroughputAsync(String resourceGroupName, String accountName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        return this.beginUpdateTableThroughputAsync(resourceGroupName, accountName, tableName, updateThroughputParameters, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public ThroughputSettingsGetResultsInner updateTableThroughput(String resourceGroupName, String accountName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return (ThroughputSettingsGetResultsInner)((Object)this.updateTableThroughputAsync(resourceGroupName, accountName, tableName, updateThroughputParameters).block());
    }

    @Override
    public ThroughputSettingsGetResultsInner updateTableThroughput(String resourceGroupName, String accountName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        return (ThroughputSettingsGetResultsInner)((Object)this.updateTableThroughputAsync(resourceGroupName, accountName, tableName, updateThroughputParameters, context).block());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CosmosDBManagementCl")
    private static interface TableResourcesService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/tables")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TableListResult>> listTables(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/tables/{tableName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TableGetResultsInner>> getTable(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="tableName") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/tables/{tableName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createUpdateTable(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="tableName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") TableCreateUpdateParameters var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/tables/{tableName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> deleteTable(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="tableName") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/tables/{tableName}/throughputSettings/default")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ThroughputSettingsGetResultsInner>> getTableThroughput(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="tableName") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/tables/{tableName}/throughputSettings/default")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> updateTableThroughput(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="tableName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ThroughputSettingsUpdateParameters var7, Context var8);
    }
}

