/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cosmos.models.ConflictResolutionPolicy;
import com.azure.resourcemanager.cosmos.models.ContainerPartitionKey;
import com.azure.resourcemanager.cosmos.models.IndexingPolicy;
import com.azure.resourcemanager.cosmos.models.UniqueKeyPolicy;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class SqlContainerResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SqlContainerResource.class);
    @JsonProperty(value="id", required=true)
    private String id;
    @JsonProperty(value="indexingPolicy")
    private IndexingPolicy indexingPolicy;
    @JsonProperty(value="partitionKey")
    private ContainerPartitionKey partitionKey;
    @JsonProperty(value="defaultTtl")
    private Integer defaultTtl;
    @JsonProperty(value="uniqueKeyPolicy")
    private UniqueKeyPolicy uniqueKeyPolicy;
    @JsonProperty(value="conflictResolutionPolicy")
    private ConflictResolutionPolicy conflictResolutionPolicy;

    public String id() {
        return this.id;
    }

    public SqlContainerResource withId(String id) {
        this.id = id;
        return this;
    }

    public IndexingPolicy indexingPolicy() {
        return this.indexingPolicy;
    }

    public SqlContainerResource withIndexingPolicy(IndexingPolicy indexingPolicy) {
        this.indexingPolicy = indexingPolicy;
        return this;
    }

    public ContainerPartitionKey partitionKey() {
        return this.partitionKey;
    }

    public SqlContainerResource withPartitionKey(ContainerPartitionKey partitionKey) {
        this.partitionKey = partitionKey;
        return this;
    }

    public Integer defaultTtl() {
        return this.defaultTtl;
    }

    public SqlContainerResource withDefaultTtl(Integer defaultTtl) {
        this.defaultTtl = defaultTtl;
        return this;
    }

    public UniqueKeyPolicy uniqueKeyPolicy() {
        return this.uniqueKeyPolicy;
    }

    public SqlContainerResource withUniqueKeyPolicy(UniqueKeyPolicy uniqueKeyPolicy) {
        this.uniqueKeyPolicy = uniqueKeyPolicy;
        return this;
    }

    public ConflictResolutionPolicy conflictResolutionPolicy() {
        return this.conflictResolutionPolicy;
    }

    public SqlContainerResource withConflictResolutionPolicy(ConflictResolutionPolicy conflictResolutionPolicy) {
        this.conflictResolutionPolicy = conflictResolutionPolicy;
        return this;
    }

    public void validate() {
        if (this.id() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property id in model SqlContainerResource"));
        }
        if (this.indexingPolicy() != null) {
            this.indexingPolicy().validate();
        }
        if (this.partitionKey() != null) {
            this.partitionKey().validate();
        }
        if (this.uniqueKeyPolicy() != null) {
            this.uniqueKeyPolicy().validate();
        }
        if (this.conflictResolutionPolicy() != null) {
            this.conflictResolutionPolicy().validate();
        }
    }
}

