/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cosmos.models.ManagedCassandraProvisioningState;
import com.azure.resourcemanager.cosmos.models.SeedNode;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class DataCenterResourceProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DataCenterResourceProperties.class);
    @JsonProperty(value="provisioningState")
    private ManagedCassandraProvisioningState provisioningState;
    @JsonProperty(value="dataCenterLocation")
    private String dataCenterLocation;
    @JsonProperty(value="delegatedSubnetId")
    private String delegatedSubnetId;
    @JsonProperty(value="nodeCount")
    private Integer nodeCount;
    @JsonProperty(value="seedNodes", access=JsonProperty.Access.WRITE_ONLY)
    private List<SeedNode> seedNodes;
    @JsonProperty(value="base64EncodedCassandraYamlFragment")
    private String base64EncodedCassandraYamlFragment;
    @JsonProperty(value="managedDiskCustomerKeyUri")
    private String managedDiskCustomerKeyUri;
    @JsonProperty(value="backupStorageCustomerKeyUri")
    private String backupStorageCustomerKeyUri;
    @JsonProperty(value="sku")
    private String sku;
    @JsonProperty(value="diskSku")
    private String diskSku;
    @JsonProperty(value="diskCapacity")
    private Integer diskCapacity;
    @JsonProperty(value="availabilityZone")
    private Boolean availabilityZone;

    public ManagedCassandraProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public DataCenterResourceProperties withProvisioningState(ManagedCassandraProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public String dataCenterLocation() {
        return this.dataCenterLocation;
    }

    public DataCenterResourceProperties withDataCenterLocation(String dataCenterLocation) {
        this.dataCenterLocation = dataCenterLocation;
        return this;
    }

    public String delegatedSubnetId() {
        return this.delegatedSubnetId;
    }

    public DataCenterResourceProperties withDelegatedSubnetId(String delegatedSubnetId) {
        this.delegatedSubnetId = delegatedSubnetId;
        return this;
    }

    public Integer nodeCount() {
        return this.nodeCount;
    }

    public DataCenterResourceProperties withNodeCount(Integer nodeCount) {
        this.nodeCount = nodeCount;
        return this;
    }

    public List<SeedNode> seedNodes() {
        return this.seedNodes;
    }

    public String base64EncodedCassandraYamlFragment() {
        return this.base64EncodedCassandraYamlFragment;
    }

    public DataCenterResourceProperties withBase64EncodedCassandraYamlFragment(String base64EncodedCassandraYamlFragment) {
        this.base64EncodedCassandraYamlFragment = base64EncodedCassandraYamlFragment;
        return this;
    }

    public String managedDiskCustomerKeyUri() {
        return this.managedDiskCustomerKeyUri;
    }

    public DataCenterResourceProperties withManagedDiskCustomerKeyUri(String managedDiskCustomerKeyUri) {
        this.managedDiskCustomerKeyUri = managedDiskCustomerKeyUri;
        return this;
    }

    public String backupStorageCustomerKeyUri() {
        return this.backupStorageCustomerKeyUri;
    }

    public DataCenterResourceProperties withBackupStorageCustomerKeyUri(String backupStorageCustomerKeyUri) {
        this.backupStorageCustomerKeyUri = backupStorageCustomerKeyUri;
        return this;
    }

    public String sku() {
        return this.sku;
    }

    public DataCenterResourceProperties withSku(String sku) {
        this.sku = sku;
        return this;
    }

    public String diskSku() {
        return this.diskSku;
    }

    public DataCenterResourceProperties withDiskSku(String diskSku) {
        this.diskSku = diskSku;
        return this;
    }

    public Integer diskCapacity() {
        return this.diskCapacity;
    }

    public DataCenterResourceProperties withDiskCapacity(Integer diskCapacity) {
        this.diskCapacity = diskCapacity;
        return this;
    }

    public Boolean availabilityZone() {
        return this.availabilityZone;
    }

    public DataCenterResourceProperties withAvailabilityZone(Boolean availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public void validate() {
        if (this.seedNodes() != null) {
            this.seedNodes().forEach(e -> e.validate());
        }
    }
}

