/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cosmos.models.AnalyticalStorageConfiguration;
import com.azure.resourcemanager.cosmos.models.ApiProperties;
import com.azure.resourcemanager.cosmos.models.BackupPolicy;
import com.azure.resourcemanager.cosmos.models.Capability;
import com.azure.resourcemanager.cosmos.models.Capacity;
import com.azure.resourcemanager.cosmos.models.ConnectorOffer;
import com.azure.resourcemanager.cosmos.models.ConsistencyPolicy;
import com.azure.resourcemanager.cosmos.models.CorsPolicy;
import com.azure.resourcemanager.cosmos.models.CreateMode;
import com.azure.resourcemanager.cosmos.models.IpAddressOrRange;
import com.azure.resourcemanager.cosmos.models.Location;
import com.azure.resourcemanager.cosmos.models.NetworkAclBypass;
import com.azure.resourcemanager.cosmos.models.PublicNetworkAccess;
import com.azure.resourcemanager.cosmos.models.RestoreParameters;
import com.azure.resourcemanager.cosmos.models.VirtualNetworkRule;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class DatabaseAccountCreateUpdateProperties {
    @JsonProperty(value="consistencyPolicy")
    private ConsistencyPolicy consistencyPolicy;
    @JsonProperty(value="locations", required=true)
    private List<Location> locations;
    @JsonProperty(value="databaseAccountOfferType", required=true)
    private String databaseAccountOfferType = "Standard";
    @JsonProperty(value="ipRules")
    private List<IpAddressOrRange> ipRules;
    @JsonProperty(value="isVirtualNetworkFilterEnabled")
    private Boolean isVirtualNetworkFilterEnabled;
    @JsonProperty(value="enableAutomaticFailover")
    private Boolean enableAutomaticFailover;
    @JsonProperty(value="capabilities")
    private List<Capability> capabilities;
    @JsonProperty(value="virtualNetworkRules")
    private List<VirtualNetworkRule> virtualNetworkRules;
    @JsonProperty(value="enableMultipleWriteLocations")
    private Boolean enableMultipleWriteLocations;
    @JsonProperty(value="enableCassandraConnector")
    private Boolean enableCassandraConnector;
    @JsonProperty(value="connectorOffer")
    private ConnectorOffer connectorOffer;
    @JsonProperty(value="disableKeyBasedMetadataWriteAccess")
    private Boolean disableKeyBasedMetadataWriteAccess;
    @JsonProperty(value="keyVaultKeyUri")
    private String keyVaultKeyUri;
    @JsonProperty(value="defaultIdentity")
    private String defaultIdentity;
    @JsonProperty(value="publicNetworkAccess")
    private PublicNetworkAccess publicNetworkAccess;
    @JsonProperty(value="enableFreeTier")
    private Boolean enableFreeTier;
    @JsonProperty(value="apiProperties")
    private ApiProperties apiProperties;
    @JsonProperty(value="enableAnalyticalStorage")
    private Boolean enableAnalyticalStorage;
    @JsonProperty(value="analyticalStorageConfiguration")
    private AnalyticalStorageConfiguration analyticalStorageConfiguration;
    @JsonProperty(value="createMode")
    private CreateMode createMode;
    @JsonProperty(value="backupPolicy")
    private BackupPolicy backupPolicy;
    @JsonProperty(value="cors")
    private List<CorsPolicy> cors;
    @JsonProperty(value="networkAclBypass")
    private NetworkAclBypass networkAclBypass;
    @JsonProperty(value="networkAclBypassResourceIds")
    private List<String> networkAclBypassResourceIds;
    @JsonProperty(value="disableLocalAuth")
    private Boolean disableLocalAuth;
    @JsonProperty(value="restoreParameters")
    private RestoreParameters restoreParameters;
    @JsonProperty(value="capacity")
    private Capacity capacity;
    private static final ClientLogger LOGGER = new ClientLogger(DatabaseAccountCreateUpdateProperties.class);

    public ConsistencyPolicy consistencyPolicy() {
        return this.consistencyPolicy;
    }

    public DatabaseAccountCreateUpdateProperties withConsistencyPolicy(ConsistencyPolicy consistencyPolicy) {
        this.consistencyPolicy = consistencyPolicy;
        return this;
    }

    public List<Location> locations() {
        return this.locations;
    }

    public DatabaseAccountCreateUpdateProperties withLocations(List<Location> locations) {
        this.locations = locations;
        return this;
    }

    public String databaseAccountOfferType() {
        return this.databaseAccountOfferType;
    }

    public DatabaseAccountCreateUpdateProperties withDatabaseAccountOfferType(String databaseAccountOfferType) {
        this.databaseAccountOfferType = databaseAccountOfferType;
        return this;
    }

    public List<IpAddressOrRange> ipRules() {
        return this.ipRules;
    }

    public DatabaseAccountCreateUpdateProperties withIpRules(List<IpAddressOrRange> ipRules) {
        this.ipRules = ipRules;
        return this;
    }

    public Boolean isVirtualNetworkFilterEnabled() {
        return this.isVirtualNetworkFilterEnabled;
    }

    public DatabaseAccountCreateUpdateProperties withIsVirtualNetworkFilterEnabled(Boolean isVirtualNetworkFilterEnabled) {
        this.isVirtualNetworkFilterEnabled = isVirtualNetworkFilterEnabled;
        return this;
    }

    public Boolean enableAutomaticFailover() {
        return this.enableAutomaticFailover;
    }

    public DatabaseAccountCreateUpdateProperties withEnableAutomaticFailover(Boolean enableAutomaticFailover) {
        this.enableAutomaticFailover = enableAutomaticFailover;
        return this;
    }

    public List<Capability> capabilities() {
        return this.capabilities;
    }

    public DatabaseAccountCreateUpdateProperties withCapabilities(List<Capability> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public List<VirtualNetworkRule> virtualNetworkRules() {
        return this.virtualNetworkRules;
    }

    public DatabaseAccountCreateUpdateProperties withVirtualNetworkRules(List<VirtualNetworkRule> virtualNetworkRules) {
        this.virtualNetworkRules = virtualNetworkRules;
        return this;
    }

    public Boolean enableMultipleWriteLocations() {
        return this.enableMultipleWriteLocations;
    }

    public DatabaseAccountCreateUpdateProperties withEnableMultipleWriteLocations(Boolean enableMultipleWriteLocations) {
        this.enableMultipleWriteLocations = enableMultipleWriteLocations;
        return this;
    }

    public Boolean enableCassandraConnector() {
        return this.enableCassandraConnector;
    }

    public DatabaseAccountCreateUpdateProperties withEnableCassandraConnector(Boolean enableCassandraConnector) {
        this.enableCassandraConnector = enableCassandraConnector;
        return this;
    }

    public ConnectorOffer connectorOffer() {
        return this.connectorOffer;
    }

    public DatabaseAccountCreateUpdateProperties withConnectorOffer(ConnectorOffer connectorOffer) {
        this.connectorOffer = connectorOffer;
        return this;
    }

    public Boolean disableKeyBasedMetadataWriteAccess() {
        return this.disableKeyBasedMetadataWriteAccess;
    }

    public DatabaseAccountCreateUpdateProperties withDisableKeyBasedMetadataWriteAccess(Boolean disableKeyBasedMetadataWriteAccess) {
        this.disableKeyBasedMetadataWriteAccess = disableKeyBasedMetadataWriteAccess;
        return this;
    }

    public String keyVaultKeyUri() {
        return this.keyVaultKeyUri;
    }

    public DatabaseAccountCreateUpdateProperties withKeyVaultKeyUri(String keyVaultKeyUri) {
        this.keyVaultKeyUri = keyVaultKeyUri;
        return this;
    }

    public String defaultIdentity() {
        return this.defaultIdentity;
    }

    public DatabaseAccountCreateUpdateProperties withDefaultIdentity(String defaultIdentity) {
        this.defaultIdentity = defaultIdentity;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public DatabaseAccountCreateUpdateProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public Boolean enableFreeTier() {
        return this.enableFreeTier;
    }

    public DatabaseAccountCreateUpdateProperties withEnableFreeTier(Boolean enableFreeTier) {
        this.enableFreeTier = enableFreeTier;
        return this;
    }

    public ApiProperties apiProperties() {
        return this.apiProperties;
    }

    public DatabaseAccountCreateUpdateProperties withApiProperties(ApiProperties apiProperties) {
        this.apiProperties = apiProperties;
        return this;
    }

    public Boolean enableAnalyticalStorage() {
        return this.enableAnalyticalStorage;
    }

    public DatabaseAccountCreateUpdateProperties withEnableAnalyticalStorage(Boolean enableAnalyticalStorage) {
        this.enableAnalyticalStorage = enableAnalyticalStorage;
        return this;
    }

    public AnalyticalStorageConfiguration analyticalStorageConfiguration() {
        return this.analyticalStorageConfiguration;
    }

    public DatabaseAccountCreateUpdateProperties withAnalyticalStorageConfiguration(AnalyticalStorageConfiguration analyticalStorageConfiguration) {
        this.analyticalStorageConfiguration = analyticalStorageConfiguration;
        return this;
    }

    public CreateMode createMode() {
        return this.createMode;
    }

    public DatabaseAccountCreateUpdateProperties withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public BackupPolicy backupPolicy() {
        return this.backupPolicy;
    }

    public DatabaseAccountCreateUpdateProperties withBackupPolicy(BackupPolicy backupPolicy) {
        this.backupPolicy = backupPolicy;
        return this;
    }

    public List<CorsPolicy> cors() {
        return this.cors;
    }

    public DatabaseAccountCreateUpdateProperties withCors(List<CorsPolicy> cors) {
        this.cors = cors;
        return this;
    }

    public NetworkAclBypass networkAclBypass() {
        return this.networkAclBypass;
    }

    public DatabaseAccountCreateUpdateProperties withNetworkAclBypass(NetworkAclBypass networkAclBypass) {
        this.networkAclBypass = networkAclBypass;
        return this;
    }

    public List<String> networkAclBypassResourceIds() {
        return this.networkAclBypassResourceIds;
    }

    public DatabaseAccountCreateUpdateProperties withNetworkAclBypassResourceIds(List<String> networkAclBypassResourceIds) {
        this.networkAclBypassResourceIds = networkAclBypassResourceIds;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public DatabaseAccountCreateUpdateProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public RestoreParameters restoreParameters() {
        return this.restoreParameters;
    }

    public DatabaseAccountCreateUpdateProperties withRestoreParameters(RestoreParameters restoreParameters) {
        this.restoreParameters = restoreParameters;
        return this;
    }

    public Capacity capacity() {
        return this.capacity;
    }

    public DatabaseAccountCreateUpdateProperties withCapacity(Capacity capacity) {
        this.capacity = capacity;
        return this;
    }

    public void validate() {
        if (this.consistencyPolicy() != null) {
            this.consistencyPolicy().validate();
        }
        if (this.locations() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property locations in model DatabaseAccountCreateUpdateProperties"));
        }
        this.locations().forEach(e -> e.validate());
        if (this.ipRules() != null) {
            this.ipRules().forEach(e -> e.validate());
        }
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
        if (this.virtualNetworkRules() != null) {
            this.virtualNetworkRules().forEach(e -> e.validate());
        }
        if (this.apiProperties() != null) {
            this.apiProperties().validate();
        }
        if (this.analyticalStorageConfiguration() != null) {
            this.analyticalStorageConfiguration().validate();
        }
        if (this.backupPolicy() != null) {
            this.backupPolicy().validate();
        }
        if (this.cors() != null) {
            this.cors().forEach(e -> e.validate());
        }
        if (this.restoreParameters() != null) {
            this.restoreParameters().validate();
        }
        if (this.capacity() != null) {
            this.capacity().validate();
        }
    }
}

