// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cosmos.models.ArmProxyResource;
import com.azure.resourcemanager.cosmos.models.Role;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** An Azure Cosmos DB User Definition. */
@Fluent
public final class MongoUserDefinitionGetResultsInner extends ArmProxyResource {
    /*
     * Properties related to the User Definition.
     */
    @JsonProperty(value = "properties")
    private MongoUserDefinitionResource innerProperties;

    /** Creates an instance of MongoUserDefinitionGetResultsInner class. */
    public MongoUserDefinitionGetResultsInner() {
    }

    /**
     * Get the innerProperties property: Properties related to the User Definition.
     *
     * @return the innerProperties value.
     */
    private MongoUserDefinitionResource innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the username property: The user name for User Definition.
     *
     * @return the username value.
     */
    public String username() {
        return this.innerProperties() == null ? null : this.innerProperties().username();
    }

    /**
     * Set the username property: The user name for User Definition.
     *
     * @param username the username value to set.
     * @return the MongoUserDefinitionGetResultsInner object itself.
     */
    public MongoUserDefinitionGetResultsInner withUsername(String username) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoUserDefinitionResource();
        }
        this.innerProperties().withUsername(username);
        return this;
    }

    /**
     * Get the password property: The password for User Definition. Response does not contain user password.
     *
     * @return the password value.
     */
    public String password() {
        return this.innerProperties() == null ? null : this.innerProperties().password();
    }

    /**
     * Set the password property: The password for User Definition. Response does not contain user password.
     *
     * @param password the password value to set.
     * @return the MongoUserDefinitionGetResultsInner object itself.
     */
    public MongoUserDefinitionGetResultsInner withPassword(String password) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoUserDefinitionResource();
        }
        this.innerProperties().withPassword(password);
        return this;
    }

    /**
     * Get the databaseName property: The database name for which access is being granted for this User Definition.
     *
     * @return the databaseName value.
     */
    public String databaseName() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseName();
    }

    /**
     * Set the databaseName property: The database name for which access is being granted for this User Definition.
     *
     * @param databaseName the databaseName value to set.
     * @return the MongoUserDefinitionGetResultsInner object itself.
     */
    public MongoUserDefinitionGetResultsInner withDatabaseName(String databaseName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoUserDefinitionResource();
        }
        this.innerProperties().withDatabaseName(databaseName);
        return this;
    }

    /**
     * Get the customData property: A custom definition for the USer Definition.
     *
     * @return the customData value.
     */
    public String customData() {
        return this.innerProperties() == null ? null : this.innerProperties().customData();
    }

    /**
     * Set the customData property: A custom definition for the USer Definition.
     *
     * @param customData the customData value to set.
     * @return the MongoUserDefinitionGetResultsInner object itself.
     */
    public MongoUserDefinitionGetResultsInner withCustomData(String customData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoUserDefinitionResource();
        }
        this.innerProperties().withCustomData(customData);
        return this;
    }

    /**
     * Get the roles property: The set of roles inherited by the User Definition.
     *
     * @return the roles value.
     */
    public List<Role> roles() {
        return this.innerProperties() == null ? null : this.innerProperties().roles();
    }

    /**
     * Set the roles property: The set of roles inherited by the User Definition.
     *
     * @param roles the roles value to set.
     * @return the MongoUserDefinitionGetResultsInner object itself.
     */
    public MongoUserDefinitionGetResultsInner withRoles(List<Role> roles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoUserDefinitionResource();
        }
        this.innerProperties().withRoles(roles);
        return this;
    }

    /**
     * Get the mechanisms property: The Mongo Auth mechanism. For now, we only support auth mechanism SCRAM-SHA-256.
     *
     * @return the mechanisms value.
     */
    public String mechanisms() {
        return this.innerProperties() == null ? null : this.innerProperties().mechanisms();
    }

    /**
     * Set the mechanisms property: The Mongo Auth mechanism. For now, we only support auth mechanism SCRAM-SHA-256.
     *
     * @param mechanisms the mechanisms value to set.
     * @return the MongoUserDefinitionGetResultsInner object itself.
     */
    public MongoUserDefinitionGetResultsInner withMechanisms(String mechanisms) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoUserDefinitionResource();
        }
        this.innerProperties().withMechanisms(mechanisms);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
