// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cosmos.models.ArmProxyResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/** An Azure Cosmos DB Role Assignment. */
@Fluent
public final class SqlRoleAssignmentGetResultsInner extends ArmProxyResource {
    /*
     * Properties related to the Role Assignment.
     */
    @JsonProperty(value = "properties")
    private SqlRoleAssignmentResource innerProperties;

    /** Creates an instance of SqlRoleAssignmentGetResultsInner class. */
    public SqlRoleAssignmentGetResultsInner() {
    }

    /**
     * Get the innerProperties property: Properties related to the Role Assignment.
     *
     * @return the innerProperties value.
     */
    private SqlRoleAssignmentResource innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the roleDefinitionId property: The unique identifier for the associated Role Definition.
     *
     * @return the roleDefinitionId value.
     */
    public String roleDefinitionId() {
        return this.innerProperties() == null ? null : this.innerProperties().roleDefinitionId();
    }

    /**
     * Set the roleDefinitionId property: The unique identifier for the associated Role Definition.
     *
     * @param roleDefinitionId the roleDefinitionId value to set.
     * @return the SqlRoleAssignmentGetResultsInner object itself.
     */
    public SqlRoleAssignmentGetResultsInner withRoleDefinitionId(String roleDefinitionId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlRoleAssignmentResource();
        }
        this.innerProperties().withRoleDefinitionId(roleDefinitionId);
        return this;
    }

    /**
     * Get the scope property: The data plane resource path for which access is being granted through this Role
     * Assignment.
     *
     * @return the scope value.
     */
    public String scope() {
        return this.innerProperties() == null ? null : this.innerProperties().scope();
    }

    /**
     * Set the scope property: The data plane resource path for which access is being granted through this Role
     * Assignment.
     *
     * @param scope the scope value to set.
     * @return the SqlRoleAssignmentGetResultsInner object itself.
     */
    public SqlRoleAssignmentGetResultsInner withScope(String scope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlRoleAssignmentResource();
        }
        this.innerProperties().withScope(scope);
        return this;
    }

    /**
     * Get the principalId property: The unique identifier for the associated AAD principal in the AAD graph to which
     * access is being granted through this Role Assignment. Tenant ID for the principal is inferred using the tenant
     * associated with the subscription.
     *
     * @return the principalId value.
     */
    public String principalId() {
        return this.innerProperties() == null ? null : this.innerProperties().principalId();
    }

    /**
     * Set the principalId property: The unique identifier for the associated AAD principal in the AAD graph to which
     * access is being granted through this Role Assignment. Tenant ID for the principal is inferred using the tenant
     * associated with the subscription.
     *
     * @param principalId the principalId value to set.
     * @return the SqlRoleAssignmentGetResultsInner object itself.
     */
    public SqlRoleAssignmentGetResultsInner withPrincipalId(String principalId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlRoleAssignmentResource();
        }
        this.innerProperties().withPrincipalId(principalId);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
