// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The AutoscaleSettings model. */
@Fluent
public final class AutoscaleSettings {
    /*
     * Represents maximum throughput, the resource can scale up to.
     */
    @JsonProperty(value = "maxThroughput")
    private Integer maxThroughput;

    /** Creates an instance of AutoscaleSettings class. */
    public AutoscaleSettings() {
    }

    /**
     * Get the maxThroughput property: Represents maximum throughput, the resource can scale up to.
     *
     * @return the maxThroughput value.
     */
    public Integer maxThroughput() {
        return this.maxThroughput;
    }

    /**
     * Set the maxThroughput property: Represents maximum throughput, the resource can scale up to.
     *
     * @param maxThroughput the maxThroughput value to set.
     * @return the AutoscaleSettings object itself.
     */
    public AutoscaleSettings withMaxThroughput(Integer maxThroughput) {
        this.maxThroughput = maxThroughput;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
