// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** The offer type for the Cosmos DB database account. */
public enum DatabaseAccountOfferType {
    /** Enum value Standard. */
    STANDARD("Standard");

    /** The actual serialized value for a DatabaseAccountOfferType instance. */
    private final String value;

    DatabaseAccountOfferType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a DatabaseAccountOfferType instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed DatabaseAccountOfferType object, or null if unable to parse.
     */
    @JsonCreator
    public static DatabaseAccountOfferType fromString(String value) {
        if (value == null) {
            return null;
        }
        DatabaseAccountOfferType[] items = DatabaseAccountOfferType.values();
        for (DatabaseAccountOfferType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
