// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Describes the ServerVersion of an a MongoDB account. */
public final class ServerVersion extends ExpandableStringEnum<ServerVersion> {
    /** Static value 3.2 for ServerVersion. */
    public static final ServerVersion THREE_TWO = fromString("3.2");

    /** Static value 3.6 for ServerVersion. */
    public static final ServerVersion THREE_SIX = fromString("3.6");

    /** Static value 4.0 for ServerVersion. */
    public static final ServerVersion FOUR_ZERO = fromString("4.0");

    /** Static value 4.2 for ServerVersion. */
    public static final ServerVersion FOUR_TWO = fromString("4.2");

    /**
     * Creates a new instance of ServerVersion value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ServerVersion() {
    }

    /**
     * Creates or finds a ServerVersion from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ServerVersion.
     */
    @JsonCreator
    public static ServerVersion fromString(String name) {
        return fromString(name, ServerVersion.class);
    }

    /**
     * Gets known ServerVersion values.
     *
     * @return known ServerVersion values.
     */
    public static Collection<ServerVersion> values() {
        return values(ServerVersion.class);
    }
}
