/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.resourcemanager.cosmos.models.AuthenticationMethod;
import com.azure.resourcemanager.cosmos.models.CassandraError;
import com.azure.resourcemanager.cosmos.models.Certificate;
import com.azure.resourcemanager.cosmos.models.ManagedCassandraProvisioningState;
import com.azure.resourcemanager.cosmos.models.SeedNode;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ClusterResourceProperties {
    @JsonProperty(value="provisioningState")
    private ManagedCassandraProvisioningState provisioningState;
    @JsonProperty(value="restoreFromBackupId")
    private String restoreFromBackupId;
    @JsonProperty(value="delegatedManagementSubnetId")
    private String delegatedManagementSubnetId;
    @JsonProperty(value="cassandraVersion")
    private String cassandraVersion;
    @JsonProperty(value="clusterNameOverride")
    private String clusterNameOverride;
    @JsonProperty(value="authenticationMethod")
    private AuthenticationMethod authenticationMethod;
    @JsonProperty(value="initialCassandraAdminPassword")
    private String initialCassandraAdminPassword;
    @JsonProperty(value="prometheusEndpoint")
    private SeedNode prometheusEndpoint;
    @JsonProperty(value="repairEnabled")
    private Boolean repairEnabled;
    @JsonProperty(value="clientCertificates")
    private List<Certificate> clientCertificates;
    @JsonProperty(value="externalGossipCertificates")
    private List<Certificate> externalGossipCertificates;
    @JsonProperty(value="gossipCertificates", access=JsonProperty.Access.WRITE_ONLY)
    private List<Certificate> gossipCertificates;
    @JsonProperty(value="externalSeedNodes")
    private List<SeedNode> externalSeedNodes;
    @JsonProperty(value="seedNodes", access=JsonProperty.Access.WRITE_ONLY)
    private List<SeedNode> seedNodes;
    @JsonProperty(value="hoursBetweenBackups")
    private Integer hoursBetweenBackups;
    @JsonProperty(value="deallocated")
    private Boolean deallocated;
    @JsonProperty(value="cassandraAuditLoggingEnabled")
    private Boolean cassandraAuditLoggingEnabled;
    @JsonProperty(value="provisionError")
    private CassandraError provisionError;

    public ManagedCassandraProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ClusterResourceProperties withProvisioningState(ManagedCassandraProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public String restoreFromBackupId() {
        return this.restoreFromBackupId;
    }

    public ClusterResourceProperties withRestoreFromBackupId(String restoreFromBackupId) {
        this.restoreFromBackupId = restoreFromBackupId;
        return this;
    }

    public String delegatedManagementSubnetId() {
        return this.delegatedManagementSubnetId;
    }

    public ClusterResourceProperties withDelegatedManagementSubnetId(String delegatedManagementSubnetId) {
        this.delegatedManagementSubnetId = delegatedManagementSubnetId;
        return this;
    }

    public String cassandraVersion() {
        return this.cassandraVersion;
    }

    public ClusterResourceProperties withCassandraVersion(String cassandraVersion) {
        this.cassandraVersion = cassandraVersion;
        return this;
    }

    public String clusterNameOverride() {
        return this.clusterNameOverride;
    }

    public ClusterResourceProperties withClusterNameOverride(String clusterNameOverride) {
        this.clusterNameOverride = clusterNameOverride;
        return this;
    }

    public AuthenticationMethod authenticationMethod() {
        return this.authenticationMethod;
    }

    public ClusterResourceProperties withAuthenticationMethod(AuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
        return this;
    }

    public String initialCassandraAdminPassword() {
        return this.initialCassandraAdminPassword;
    }

    public ClusterResourceProperties withInitialCassandraAdminPassword(String initialCassandraAdminPassword) {
        this.initialCassandraAdminPassword = initialCassandraAdminPassword;
        return this;
    }

    public SeedNode prometheusEndpoint() {
        return this.prometheusEndpoint;
    }

    public ClusterResourceProperties withPrometheusEndpoint(SeedNode prometheusEndpoint) {
        this.prometheusEndpoint = prometheusEndpoint;
        return this;
    }

    public Boolean repairEnabled() {
        return this.repairEnabled;
    }

    public ClusterResourceProperties withRepairEnabled(Boolean repairEnabled) {
        this.repairEnabled = repairEnabled;
        return this;
    }

    public List<Certificate> clientCertificates() {
        return this.clientCertificates;
    }

    public ClusterResourceProperties withClientCertificates(List<Certificate> clientCertificates) {
        this.clientCertificates = clientCertificates;
        return this;
    }

    public List<Certificate> externalGossipCertificates() {
        return this.externalGossipCertificates;
    }

    public ClusterResourceProperties withExternalGossipCertificates(List<Certificate> externalGossipCertificates) {
        this.externalGossipCertificates = externalGossipCertificates;
        return this;
    }

    public List<Certificate> gossipCertificates() {
        return this.gossipCertificates;
    }

    public List<SeedNode> externalSeedNodes() {
        return this.externalSeedNodes;
    }

    public ClusterResourceProperties withExternalSeedNodes(List<SeedNode> externalSeedNodes) {
        this.externalSeedNodes = externalSeedNodes;
        return this;
    }

    public List<SeedNode> seedNodes() {
        return this.seedNodes;
    }

    public Integer hoursBetweenBackups() {
        return this.hoursBetweenBackups;
    }

    public ClusterResourceProperties withHoursBetweenBackups(Integer hoursBetweenBackups) {
        this.hoursBetweenBackups = hoursBetweenBackups;
        return this;
    }

    public Boolean deallocated() {
        return this.deallocated;
    }

    public ClusterResourceProperties withDeallocated(Boolean deallocated) {
        this.deallocated = deallocated;
        return this;
    }

    public Boolean cassandraAuditLoggingEnabled() {
        return this.cassandraAuditLoggingEnabled;
    }

    public ClusterResourceProperties withCassandraAuditLoggingEnabled(Boolean cassandraAuditLoggingEnabled) {
        this.cassandraAuditLoggingEnabled = cassandraAuditLoggingEnabled;
        return this;
    }

    public CassandraError provisionError() {
        return this.provisionError;
    }

    public ClusterResourceProperties withProvisionError(CassandraError provisionError) {
        this.provisionError = provisionError;
        return this;
    }

    public void validate() {
        if (this.prometheusEndpoint() != null) {
            this.prometheusEndpoint().validate();
        }
        if (this.clientCertificates() != null) {
            this.clientCertificates().forEach(e -> e.validate());
        }
        if (this.externalGossipCertificates() != null) {
            this.externalGossipCertificates().forEach(e -> e.validate());
        }
        if (this.gossipCertificates() != null) {
            this.gossipCertificates().forEach(e -> e.validate());
        }
        if (this.externalSeedNodes() != null) {
            this.externalSeedNodes().forEach(e -> e.validate());
        }
        if (this.seedNodes() != null) {
            this.seedNodes().forEach(e -> e.validate());
        }
        if (this.provisionError() != null) {
            this.provisionError().validate();
        }
    }
}

