// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cosmos.models.CassandraKeyspaceGetPropertiesOptions;
import com.azure.resourcemanager.cosmos.models.CassandraKeyspaceGetPropertiesResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The properties of an Azure Cosmos DB Cassandra keyspace. */
@Fluent
public final class CassandraKeyspaceGetProperties {
    /*
     * The resource property.
     */
    @JsonProperty(value = "resource")
    private CassandraKeyspaceGetPropertiesResource resource;

    /*
     * The options property.
     */
    @JsonProperty(value = "options")
    private CassandraKeyspaceGetPropertiesOptions options;

    /** Creates an instance of CassandraKeyspaceGetProperties class. */
    public CassandraKeyspaceGetProperties() {
    }

    /**
     * Get the resource property: The resource property.
     *
     * @return the resource value.
     */
    public CassandraKeyspaceGetPropertiesResource resource() {
        return this.resource;
    }

    /**
     * Set the resource property: The resource property.
     *
     * @param resource the resource value to set.
     * @return the CassandraKeyspaceGetProperties object itself.
     */
    public CassandraKeyspaceGetProperties withResource(CassandraKeyspaceGetPropertiesResource resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Get the options property: The options property.
     *
     * @return the options value.
     */
    public CassandraKeyspaceGetPropertiesOptions options() {
        return this.options;
    }

    /**
     * Set the options property: The options property.
     *
     * @param options the options value to set.
     * @return the CassandraKeyspaceGetProperties object itself.
     */
    public CassandraKeyspaceGetProperties withOptions(CassandraKeyspaceGetPropertiesOptions options) {
        this.options = options;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resource() != null) {
            resource().validate();
        }
        if (options() != null) {
            options().validate();
        }
    }
}
