// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The ApiProperties model. */
@Fluent
public final class ApiProperties {
    /*
     * Describes the ServerVersion of an a MongoDB account.
     */
    @JsonProperty(value = "serverVersion")
    private ServerVersion serverVersion;

    /** Creates an instance of ApiProperties class. */
    public ApiProperties() {
    }

    /**
     * Get the serverVersion property: Describes the ServerVersion of an a MongoDB account.
     *
     * @return the serverVersion value.
     */
    public ServerVersion serverVersion() {
        return this.serverVersion;
    }

    /**
     * Set the serverVersion property: Describes the ServerVersion of an a MongoDB account.
     *
     * @param serverVersion the serverVersion value to set.
     * @return the ApiProperties object itself.
     */
    public ApiProperties withServerVersion(ServerVersion serverVersion) {
        this.serverVersion = serverVersion;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
