// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Cosmos DB client encryption key resource object. */
@Fluent
public class ClientEncryptionKeyResource {
    /*
     * Name of the ClientEncryptionKey
     */
    @JsonProperty(value = "id")
    private String id;

    /*
     * Encryption algorithm that will be used along with this client encryption key to encrypt/decrypt data.
     */
    @JsonProperty(value = "encryptionAlgorithm")
    private String encryptionAlgorithm;

    /*
     * Wrapped (encrypted) form of the key represented as a byte array.
     */
    @JsonProperty(value = "wrappedDataEncryptionKey")
    private byte[] wrappedDataEncryptionKey;

    /*
     * Metadata for the wrapping provider that can be used to unwrap the wrapped client encryption key.
     */
    @JsonProperty(value = "keyWrapMetadata")
    private KeyWrapMetadata keyWrapMetadata;

    /** Creates an instance of ClientEncryptionKeyResource class. */
    public ClientEncryptionKeyResource() {
    }

    /**
     * Get the id property: Name of the ClientEncryptionKey.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Name of the ClientEncryptionKey.
     *
     * @param id the id value to set.
     * @return the ClientEncryptionKeyResource object itself.
     */
    public ClientEncryptionKeyResource withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the encryptionAlgorithm property: Encryption algorithm that will be used along with this client encryption
     * key to encrypt/decrypt data.
     *
     * @return the encryptionAlgorithm value.
     */
    public String encryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    /**
     * Set the encryptionAlgorithm property: Encryption algorithm that will be used along with this client encryption
     * key to encrypt/decrypt data.
     *
     * @param encryptionAlgorithm the encryptionAlgorithm value to set.
     * @return the ClientEncryptionKeyResource object itself.
     */
    public ClientEncryptionKeyResource withEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        return this;
    }

    /**
     * Get the wrappedDataEncryptionKey property: Wrapped (encrypted) form of the key represented as a byte array.
     *
     * @return the wrappedDataEncryptionKey value.
     */
    public byte[] wrappedDataEncryptionKey() {
        return CoreUtils.clone(this.wrappedDataEncryptionKey);
    }

    /**
     * Set the wrappedDataEncryptionKey property: Wrapped (encrypted) form of the key represented as a byte array.
     *
     * @param wrappedDataEncryptionKey the wrappedDataEncryptionKey value to set.
     * @return the ClientEncryptionKeyResource object itself.
     */
    public ClientEncryptionKeyResource withWrappedDataEncryptionKey(byte[] wrappedDataEncryptionKey) {
        this.wrappedDataEncryptionKey = CoreUtils.clone(wrappedDataEncryptionKey);
        return this;
    }

    /**
     * Get the keyWrapMetadata property: Metadata for the wrapping provider that can be used to unwrap the wrapped
     * client encryption key.
     *
     * @return the keyWrapMetadata value.
     */
    public KeyWrapMetadata keyWrapMetadata() {
        return this.keyWrapMetadata;
    }

    /**
     * Set the keyWrapMetadata property: Metadata for the wrapping provider that can be used to unwrap the wrapped
     * client encryption key.
     *
     * @param keyWrapMetadata the keyWrapMetadata value to set.
     * @return the ClientEncryptionKeyResource object itself.
     */
    public ClientEncryptionKeyResource withKeyWrapMetadata(KeyWrapMetadata keyWrapMetadata) {
        this.keyWrapMetadata = keyWrapMetadata;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (keyWrapMetadata() != null) {
            keyWrapMetadata().validate();
        }
    }
}
