// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Cosmos DB MongoDB collection resource object. */
@Fluent
public final class MongoIndexKeys {
    /*
     * List of keys for each MongoDB collection in the Azure Cosmos DB service
     */
    @JsonProperty(value = "keys")
    private List<String> keys;

    /** Creates an instance of MongoIndexKeys class. */
    public MongoIndexKeys() {
    }

    /**
     * Get the keys property: List of keys for each MongoDB collection in the Azure Cosmos DB service.
     *
     * @return the keys value.
     */
    public List<String> keys() {
        return this.keys;
    }

    /**
     * Set the keys property: List of keys for each MongoDB collection in the Azure Cosmos DB service.
     *
     * @param keys the keys value to set.
     * @return the MongoIndexKeys object itself.
     */
    public MongoIndexKeys withKeys(List<String> keys) {
        this.keys = keys;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
