// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The set of data plane operations permitted through this Role Definition. */
@Fluent
public final class Privilege {
    /*
     * An Azure Cosmos DB Mongo DB Resource.
     */
    @JsonProperty(value = "resource")
    private PrivilegeResource resource;

    /*
     * An array of actions that are allowed.
     */
    @JsonProperty(value = "actions")
    private List<String> actions;

    /** Creates an instance of Privilege class. */
    public Privilege() {
    }

    /**
     * Get the resource property: An Azure Cosmos DB Mongo DB Resource.
     *
     * @return the resource value.
     */
    public PrivilegeResource resource() {
        return this.resource;
    }

    /**
     * Set the resource property: An Azure Cosmos DB Mongo DB Resource.
     *
     * @param resource the resource value to set.
     * @return the Privilege object itself.
     */
    public Privilege withResource(PrivilegeResource resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Get the actions property: An array of actions that are allowed.
     *
     * @return the actions value.
     */
    public List<String> actions() {
        return this.actions;
    }

    /**
     * Set the actions property: An array of actions that are allowed.
     *
     * @param actions the actions value to set.
     * @return the Privilege object itself.
     */
    public Privilege withActions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resource() != null) {
            resource().validate();
        }
    }
}
