/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cosmos.fluent.GremlinResourcesClient;
import com.azure.resourcemanager.cosmos.fluent.models.GremlinDatabaseGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.GremlinGraphGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.ThroughputSettingsGetResultsInner;
import com.azure.resourcemanager.cosmos.implementation.CosmosDBManagementClientImpl;
import com.azure.resourcemanager.cosmos.models.GremlinDatabaseCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.GremlinDatabaseListResult;
import com.azure.resourcemanager.cosmos.models.GremlinGraphCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.GremlinGraphListResult;
import com.azure.resourcemanager.cosmos.models.ThroughputSettingsUpdateParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class GremlinResourcesClientImpl
implements GremlinResourcesClient {
    private final ClientLogger logger = new ClientLogger(GremlinResourcesClientImpl.class);
    private final GremlinResourcesService service;
    private final CosmosDBManagementClientImpl client;

    GremlinResourcesClientImpl(CosmosDBManagementClientImpl client) {
        this.service = (GremlinResourcesService)RestProxy.create(GremlinResourcesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<GremlinDatabaseGetResultsInner>> listGremlinDatabasesSinglePageAsync(String resourceGroupName, String accountName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listGremlinDatabases(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GremlinDatabaseListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<GremlinDatabaseGetResultsInner>> listGremlinDatabasesSinglePageAsync(String resourceGroupName, String accountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listGremlinDatabases(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GremlinDatabaseListResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<GremlinDatabaseGetResultsInner> listGremlinDatabasesAsync(String resourceGroupName, String accountName) {
        return new PagedFlux(() -> this.listGremlinDatabasesSinglePageAsync(resourceGroupName, accountName));
    }

    private PagedFlux<GremlinDatabaseGetResultsInner> listGremlinDatabasesAsync(String resourceGroupName, String accountName, Context context) {
        return new PagedFlux(() -> this.listGremlinDatabasesSinglePageAsync(resourceGroupName, accountName, context));
    }

    @Override
    public PagedIterable<GremlinDatabaseGetResultsInner> listGremlinDatabases(String resourceGroupName, String accountName) {
        return new PagedIterable(this.listGremlinDatabasesAsync(resourceGroupName, accountName));
    }

    @Override
    public PagedIterable<GremlinDatabaseGetResultsInner> listGremlinDatabases(String resourceGroupName, String accountName, Context context) {
        return new PagedIterable(this.listGremlinDatabasesAsync(resourceGroupName, accountName, context));
    }

    @Override
    public Mono<Response<GremlinDatabaseGetResultsInner>> getGremlinDatabaseWithResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getGremlinDatabase(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<GremlinDatabaseGetResultsInner>> getGremlinDatabaseWithResponseAsync(String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getGremlinDatabase(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<GremlinDatabaseGetResultsInner> getGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.getGremlinDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((GremlinDatabaseGetResultsInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public GremlinDatabaseGetResultsInner getGremlinDatabase(String resourceGroupName, String accountName, String databaseName) {
        return (GremlinDatabaseGetResultsInner)((Object)this.getGremlinDatabaseAsync(resourceGroupName, accountName, databaseName).block());
    }

    @Override
    public Response<GremlinDatabaseGetResultsInner> getGremlinDatabaseWithResponse(String resourceGroupName, String accountName, String databaseName, Context context) {
        return (Response)this.getGremlinDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createUpdateGremlinDatabaseWithResponseAsync(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (createUpdateGremlinDatabaseParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter createUpdateGremlinDatabaseParameters is required and cannot be null."));
        }
        createUpdateGremlinDatabaseParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createUpdateGremlinDatabase(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, this.client.getApiVersion(), createUpdateGremlinDatabaseParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> createUpdateGremlinDatabaseWithResponseAsync(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (createUpdateGremlinDatabaseParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter createUpdateGremlinDatabaseParameters is required and cannot be null."));
        }
        createUpdateGremlinDatabaseParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createUpdateGremlinDatabase(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, this.client.getApiVersion(), createUpdateGremlinDatabaseParameters, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<GremlinDatabaseGetResultsInner>, GremlinDatabaseGetResultsInner> beginCreateUpdateGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createUpdateGremlinDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)GremlinDatabaseGetResultsInner.class), (Type)((Object)GremlinDatabaseGetResultsInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<GremlinDatabaseGetResultsInner>, GremlinDatabaseGetResultsInner> beginCreateUpdateGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createUpdateGremlinDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)GremlinDatabaseGetResultsInner.class), (Type)((Object)GremlinDatabaseGetResultsInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<GremlinDatabaseGetResultsInner>, GremlinDatabaseGetResultsInner> beginCreateUpdateGremlinDatabase(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return this.beginCreateUpdateGremlinDatabaseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<GremlinDatabaseGetResultsInner>, GremlinDatabaseGetResultsInner> beginCreateUpdateGremlinDatabase(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters, Context context) {
        return this.beginCreateUpdateGremlinDatabaseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters, context).getSyncPoller();
    }

    @Override
    public Mono<GremlinDatabaseGetResultsInner> createUpdateGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return this.beginCreateUpdateGremlinDatabaseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<GremlinDatabaseGetResultsInner> createUpdateGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters, Context context) {
        return this.beginCreateUpdateGremlinDatabaseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public GremlinDatabaseGetResultsInner createUpdateGremlinDatabase(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return (GremlinDatabaseGetResultsInner)((Object)this.createUpdateGremlinDatabaseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters).block());
    }

    @Override
    public GremlinDatabaseGetResultsInner createUpdateGremlinDatabase(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters, Context context) {
        return (GremlinDatabaseGetResultsInner)((Object)this.createUpdateGremlinDatabaseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteGremlinDatabaseWithResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.deleteGremlinDatabase(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, this.client.getApiVersion(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteGremlinDatabaseWithResponseAsync(String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.deleteGremlinDatabase(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, this.client.getApiVersion(), context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteGremlinDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteGremlinDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeleteGremlinDatabase(String resourceGroupName, String accountName, String databaseName) {
        return this.beginDeleteGremlinDatabaseAsync(resourceGroupName, accountName, databaseName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeleteGremlinDatabase(String resourceGroupName, String accountName, String databaseName, Context context) {
        return this.beginDeleteGremlinDatabaseAsync(resourceGroupName, accountName, databaseName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.beginDeleteGremlinDatabaseAsync(resourceGroupName, accountName, databaseName).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, Context context) {
        return this.beginDeleteGremlinDatabaseAsync(resourceGroupName, accountName, databaseName, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void deleteGremlinDatabase(String resourceGroupName, String accountName, String databaseName) {
        this.deleteGremlinDatabaseAsync(resourceGroupName, accountName, databaseName).block();
    }

    @Override
    public void deleteGremlinDatabase(String resourceGroupName, String accountName, String databaseName, Context context) {
        this.deleteGremlinDatabaseAsync(resourceGroupName, accountName, databaseName, context).block();
    }

    @Override
    public Mono<Response<ThroughputSettingsGetResultsInner>> getGremlinDatabaseThroughputWithResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getGremlinDatabaseThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<ThroughputSettingsGetResultsInner>> getGremlinDatabaseThroughputWithResponseAsync(String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getGremlinDatabaseThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<ThroughputSettingsGetResultsInner> getGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.getGremlinDatabaseThroughputWithResponseAsync(resourceGroupName, accountName, databaseName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ThroughputSettingsGetResultsInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public ThroughputSettingsGetResultsInner getGremlinDatabaseThroughput(String resourceGroupName, String accountName, String databaseName) {
        return (ThroughputSettingsGetResultsInner)((Object)this.getGremlinDatabaseThroughputAsync(resourceGroupName, accountName, databaseName).block());
    }

    @Override
    public Response<ThroughputSettingsGetResultsInner> getGremlinDatabaseThroughputWithResponse(String resourceGroupName, String accountName, String databaseName, Context context) {
        return (Response)this.getGremlinDatabaseThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> updateGremlinDatabaseThroughputWithResponseAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null."));
        }
        updateThroughputParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateGremlinDatabaseThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, this.client.getApiVersion(), updateThroughputParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> updateGremlinDatabaseThroughputWithResponseAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null."));
        }
        updateThroughputParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateGremlinDatabaseThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, this.client.getApiVersion(), updateThroughputParameters, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginUpdateGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateGremlinDatabaseThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ThroughputSettingsGetResultsInner.class), (Type)((Object)ThroughputSettingsGetResultsInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginUpdateGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateGremlinDatabaseThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ThroughputSettingsGetResultsInner.class), (Type)((Object)ThroughputSettingsGetResultsInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginUpdateGremlinDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.beginUpdateGremlinDatabaseThroughputAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginUpdateGremlinDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        return this.beginUpdateGremlinDatabaseThroughputAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters, context).getSyncPoller();
    }

    @Override
    public Mono<ThroughputSettingsGetResultsInner> updateGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.beginUpdateGremlinDatabaseThroughputAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<ThroughputSettingsGetResultsInner> updateGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        return this.beginUpdateGremlinDatabaseThroughputAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public ThroughputSettingsGetResultsInner updateGremlinDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return (ThroughputSettingsGetResultsInner)((Object)this.updateGremlinDatabaseThroughputAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters).block());
    }

    @Override
    public ThroughputSettingsGetResultsInner updateGremlinDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        return (ThroughputSettingsGetResultsInner)((Object)this.updateGremlinDatabaseThroughputAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> migrateGremlinDatabaseToAutoscaleWithResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.migrateGremlinDatabaseToAutoscale(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> migrateGremlinDatabaseToAutoscaleWithResponseAsync(String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.migrateGremlinDatabaseToAutoscale(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginMigrateGremlinDatabaseToAutoscaleAsync(String resourceGroupName, String accountName, String databaseName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.migrateGremlinDatabaseToAutoscaleWithResponseAsync(resourceGroupName, accountName, databaseName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ThroughputSettingsGetResultsInner.class), (Type)((Object)ThroughputSettingsGetResultsInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginMigrateGremlinDatabaseToAutoscaleAsync(String resourceGroupName, String accountName, String databaseName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.migrateGremlinDatabaseToAutoscaleWithResponseAsync(resourceGroupName, accountName, databaseName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ThroughputSettingsGetResultsInner.class), (Type)((Object)ThroughputSettingsGetResultsInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginMigrateGremlinDatabaseToAutoscale(String resourceGroupName, String accountName, String databaseName) {
        return this.beginMigrateGremlinDatabaseToAutoscaleAsync(resourceGroupName, accountName, databaseName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginMigrateGremlinDatabaseToAutoscale(String resourceGroupName, String accountName, String databaseName, Context context) {
        return this.beginMigrateGremlinDatabaseToAutoscaleAsync(resourceGroupName, accountName, databaseName, context).getSyncPoller();
    }

    @Override
    public Mono<ThroughputSettingsGetResultsInner> migrateGremlinDatabaseToAutoscaleAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.beginMigrateGremlinDatabaseToAutoscaleAsync(resourceGroupName, accountName, databaseName).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<ThroughputSettingsGetResultsInner> migrateGremlinDatabaseToAutoscaleAsync(String resourceGroupName, String accountName, String databaseName, Context context) {
        return this.beginMigrateGremlinDatabaseToAutoscaleAsync(resourceGroupName, accountName, databaseName, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public ThroughputSettingsGetResultsInner migrateGremlinDatabaseToAutoscale(String resourceGroupName, String accountName, String databaseName) {
        return (ThroughputSettingsGetResultsInner)((Object)this.migrateGremlinDatabaseToAutoscaleAsync(resourceGroupName, accountName, databaseName).block());
    }

    @Override
    public ThroughputSettingsGetResultsInner migrateGremlinDatabaseToAutoscale(String resourceGroupName, String accountName, String databaseName, Context context) {
        return (ThroughputSettingsGetResultsInner)((Object)this.migrateGremlinDatabaseToAutoscaleAsync(resourceGroupName, accountName, databaseName, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> migrateGremlinDatabaseToManualThroughputWithResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.migrateGremlinDatabaseToManualThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> migrateGremlinDatabaseToManualThroughputWithResponseAsync(String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.migrateGremlinDatabaseToManualThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginMigrateGremlinDatabaseToManualThroughputAsync(String resourceGroupName, String accountName, String databaseName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.migrateGremlinDatabaseToManualThroughputWithResponseAsync(resourceGroupName, accountName, databaseName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ThroughputSettingsGetResultsInner.class), (Type)((Object)ThroughputSettingsGetResultsInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginMigrateGremlinDatabaseToManualThroughputAsync(String resourceGroupName, String accountName, String databaseName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.migrateGremlinDatabaseToManualThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ThroughputSettingsGetResultsInner.class), (Type)((Object)ThroughputSettingsGetResultsInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginMigrateGremlinDatabaseToManualThroughput(String resourceGroupName, String accountName, String databaseName) {
        return this.beginMigrateGremlinDatabaseToManualThroughputAsync(resourceGroupName, accountName, databaseName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginMigrateGremlinDatabaseToManualThroughput(String resourceGroupName, String accountName, String databaseName, Context context) {
        return this.beginMigrateGremlinDatabaseToManualThroughputAsync(resourceGroupName, accountName, databaseName, context).getSyncPoller();
    }

    @Override
    public Mono<ThroughputSettingsGetResultsInner> migrateGremlinDatabaseToManualThroughputAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.beginMigrateGremlinDatabaseToManualThroughputAsync(resourceGroupName, accountName, databaseName).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<ThroughputSettingsGetResultsInner> migrateGremlinDatabaseToManualThroughputAsync(String resourceGroupName, String accountName, String databaseName, Context context) {
        return this.beginMigrateGremlinDatabaseToManualThroughputAsync(resourceGroupName, accountName, databaseName, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public ThroughputSettingsGetResultsInner migrateGremlinDatabaseToManualThroughput(String resourceGroupName, String accountName, String databaseName) {
        return (ThroughputSettingsGetResultsInner)((Object)this.migrateGremlinDatabaseToManualThroughputAsync(resourceGroupName, accountName, databaseName).block());
    }

    @Override
    public ThroughputSettingsGetResultsInner migrateGremlinDatabaseToManualThroughput(String resourceGroupName, String accountName, String databaseName, Context context) {
        return (ThroughputSettingsGetResultsInner)((Object)this.migrateGremlinDatabaseToManualThroughputAsync(resourceGroupName, accountName, databaseName, context).block());
    }

    private Mono<PagedResponse<GremlinGraphGetResultsInner>> listGremlinGraphsSinglePageAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listGremlinGraphs(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GremlinGraphListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<GremlinGraphGetResultsInner>> listGremlinGraphsSinglePageAsync(String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listGremlinGraphs(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GremlinGraphListResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<GremlinGraphGetResultsInner> listGremlinGraphsAsync(String resourceGroupName, String accountName, String databaseName) {
        return new PagedFlux(() -> this.listGremlinGraphsSinglePageAsync(resourceGroupName, accountName, databaseName));
    }

    private PagedFlux<GremlinGraphGetResultsInner> listGremlinGraphsAsync(String resourceGroupName, String accountName, String databaseName, Context context) {
        return new PagedFlux(() -> this.listGremlinGraphsSinglePageAsync(resourceGroupName, accountName, databaseName, context));
    }

    @Override
    public PagedIterable<GremlinGraphGetResultsInner> listGremlinGraphs(String resourceGroupName, String accountName, String databaseName) {
        return new PagedIterable(this.listGremlinGraphsAsync(resourceGroupName, accountName, databaseName));
    }

    @Override
    public PagedIterable<GremlinGraphGetResultsInner> listGremlinGraphs(String resourceGroupName, String accountName, String databaseName, Context context) {
        return new PagedIterable(this.listGremlinGraphsAsync(resourceGroupName, accountName, databaseName, context));
    }

    @Override
    public Mono<Response<GremlinGraphGetResultsInner>> getGremlinGraphWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getGremlinGraph(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<GremlinGraphGetResultsInner>> getGremlinGraphWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getGremlinGraph(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<GremlinGraphGetResultsInner> getGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return this.getGremlinGraphWithResponseAsync(resourceGroupName, accountName, databaseName, graphName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((GremlinGraphGetResultsInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public GremlinGraphGetResultsInner getGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return (GremlinGraphGetResultsInner)((Object)this.getGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName).block());
    }

    @Override
    public Response<GremlinGraphGetResultsInner> getGremlinGraphWithResponse(String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        return (Response)this.getGremlinGraphWithResponseAsync(resourceGroupName, accountName, databaseName, graphName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createUpdateGremlinGraphWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        if (createUpdateGremlinGraphParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter createUpdateGremlinGraphParameters is required and cannot be null."));
        }
        createUpdateGremlinGraphParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createUpdateGremlinGraph(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.getApiVersion(), createUpdateGremlinGraphParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> createUpdateGremlinGraphWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        if (createUpdateGremlinGraphParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter createUpdateGremlinGraphParameters is required and cannot be null."));
        }
        createUpdateGremlinGraphParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createUpdateGremlinGraph(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.getApiVersion(), createUpdateGremlinGraphParameters, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<GremlinGraphGetResultsInner>, GremlinGraphGetResultsInner> beginCreateUpdateGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createUpdateGremlinGraphWithResponseAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)GremlinGraphGetResultsInner.class), (Type)((Object)GremlinGraphGetResultsInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<GremlinGraphGetResultsInner>, GremlinGraphGetResultsInner> beginCreateUpdateGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createUpdateGremlinGraphWithResponseAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)GremlinGraphGetResultsInner.class), (Type)((Object)GremlinGraphGetResultsInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<GremlinGraphGetResultsInner>, GremlinGraphGetResultsInner> beginCreateUpdateGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        return this.beginCreateUpdateGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<GremlinGraphGetResultsInner>, GremlinGraphGetResultsInner> beginCreateUpdateGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters, Context context) {
        return this.beginCreateUpdateGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters, context).getSyncPoller();
    }

    @Override
    public Mono<GremlinGraphGetResultsInner> createUpdateGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        return this.beginCreateUpdateGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<GremlinGraphGetResultsInner> createUpdateGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters, Context context) {
        return this.beginCreateUpdateGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public GremlinGraphGetResultsInner createUpdateGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        return (GremlinGraphGetResultsInner)((Object)this.createUpdateGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters).block());
    }

    @Override
    public GremlinGraphGetResultsInner createUpdateGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters, Context context) {
        return (GremlinGraphGetResultsInner)((Object)this.createUpdateGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteGremlinGraphWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.deleteGremlinGraph(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.getApiVersion(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteGremlinGraphWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.deleteGremlinGraph(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.getApiVersion(), context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteGremlinGraphWithResponseAsync(resourceGroupName, accountName, databaseName, graphName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteGremlinGraphWithResponseAsync(resourceGroupName, accountName, databaseName, graphName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeleteGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return this.beginDeleteGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeleteGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        return this.beginDeleteGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return this.beginDeleteGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        return this.beginDeleteGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void deleteGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName) {
        this.deleteGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName).block();
    }

    @Override
    public void deleteGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        this.deleteGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName, context).block();
    }

    @Override
    public Mono<Response<ThroughputSettingsGetResultsInner>> getGremlinGraphThroughputWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getGremlinGraphThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<ThroughputSettingsGetResultsInner>> getGremlinGraphThroughputWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getGremlinGraphThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<ThroughputSettingsGetResultsInner> getGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return this.getGremlinGraphThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, graphName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ThroughputSettingsGetResultsInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public ThroughputSettingsGetResultsInner getGremlinGraphThroughput(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return (ThroughputSettingsGetResultsInner)((Object)this.getGremlinGraphThroughputAsync(resourceGroupName, accountName, databaseName, graphName).block());
    }

    @Override
    public Response<ThroughputSettingsGetResultsInner> getGremlinGraphThroughputWithResponse(String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        return (Response)this.getGremlinGraphThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, graphName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> updateGremlinGraphThroughputWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null."));
        }
        updateThroughputParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateGremlinGraphThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.getApiVersion(), updateThroughputParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> updateGremlinGraphThroughputWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null."));
        }
        updateThroughputParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateGremlinGraphThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.getApiVersion(), updateThroughputParameters, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginUpdateGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateGremlinGraphThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, graphName, updateThroughputParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ThroughputSettingsGetResultsInner.class), (Type)((Object)ThroughputSettingsGetResultsInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginUpdateGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateGremlinGraphThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, graphName, updateThroughputParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ThroughputSettingsGetResultsInner.class), (Type)((Object)ThroughputSettingsGetResultsInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginUpdateGremlinGraphThroughput(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.beginUpdateGremlinGraphThroughputAsync(resourceGroupName, accountName, databaseName, graphName, updateThroughputParameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginUpdateGremlinGraphThroughput(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        return this.beginUpdateGremlinGraphThroughputAsync(resourceGroupName, accountName, databaseName, graphName, updateThroughputParameters, context).getSyncPoller();
    }

    @Override
    public Mono<ThroughputSettingsGetResultsInner> updateGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.beginUpdateGremlinGraphThroughputAsync(resourceGroupName, accountName, databaseName, graphName, updateThroughputParameters).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<ThroughputSettingsGetResultsInner> updateGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        return this.beginUpdateGremlinGraphThroughputAsync(resourceGroupName, accountName, databaseName, graphName, updateThroughputParameters, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public ThroughputSettingsGetResultsInner updateGremlinGraphThroughput(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return (ThroughputSettingsGetResultsInner)((Object)this.updateGremlinGraphThroughputAsync(resourceGroupName, accountName, databaseName, graphName, updateThroughputParameters).block());
    }

    @Override
    public ThroughputSettingsGetResultsInner updateGremlinGraphThroughput(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        return (ThroughputSettingsGetResultsInner)((Object)this.updateGremlinGraphThroughputAsync(resourceGroupName, accountName, databaseName, graphName, updateThroughputParameters, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> migrateGremlinGraphToAutoscaleWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.migrateGremlinGraphToAutoscale(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> migrateGremlinGraphToAutoscaleWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.migrateGremlinGraphToAutoscale(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginMigrateGremlinGraphToAutoscaleAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.migrateGremlinGraphToAutoscaleWithResponseAsync(resourceGroupName, accountName, databaseName, graphName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ThroughputSettingsGetResultsInner.class), (Type)((Object)ThroughputSettingsGetResultsInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginMigrateGremlinGraphToAutoscaleAsync(String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.migrateGremlinGraphToAutoscaleWithResponseAsync(resourceGroupName, accountName, databaseName, graphName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ThroughputSettingsGetResultsInner.class), (Type)((Object)ThroughputSettingsGetResultsInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginMigrateGremlinGraphToAutoscale(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return this.beginMigrateGremlinGraphToAutoscaleAsync(resourceGroupName, accountName, databaseName, graphName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginMigrateGremlinGraphToAutoscale(String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        return this.beginMigrateGremlinGraphToAutoscaleAsync(resourceGroupName, accountName, databaseName, graphName, context).getSyncPoller();
    }

    @Override
    public Mono<ThroughputSettingsGetResultsInner> migrateGremlinGraphToAutoscaleAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return this.beginMigrateGremlinGraphToAutoscaleAsync(resourceGroupName, accountName, databaseName, graphName).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<ThroughputSettingsGetResultsInner> migrateGremlinGraphToAutoscaleAsync(String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        return this.beginMigrateGremlinGraphToAutoscaleAsync(resourceGroupName, accountName, databaseName, graphName, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public ThroughputSettingsGetResultsInner migrateGremlinGraphToAutoscale(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return (ThroughputSettingsGetResultsInner)((Object)this.migrateGremlinGraphToAutoscaleAsync(resourceGroupName, accountName, databaseName, graphName).block());
    }

    @Override
    public ThroughputSettingsGetResultsInner migrateGremlinGraphToAutoscale(String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        return (ThroughputSettingsGetResultsInner)((Object)this.migrateGremlinGraphToAutoscaleAsync(resourceGroupName, accountName, databaseName, graphName, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> migrateGremlinGraphToManualThroughputWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.migrateGremlinGraphToManualThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> migrateGremlinGraphToManualThroughputWithResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.migrateGremlinGraphToManualThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginMigrateGremlinGraphToManualThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.migrateGremlinGraphToManualThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, graphName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ThroughputSettingsGetResultsInner.class), (Type)((Object)ThroughputSettingsGetResultsInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginMigrateGremlinGraphToManualThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.migrateGremlinGraphToManualThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, graphName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ThroughputSettingsGetResultsInner.class), (Type)((Object)ThroughputSettingsGetResultsInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginMigrateGremlinGraphToManualThroughput(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return this.beginMigrateGremlinGraphToManualThroughputAsync(resourceGroupName, accountName, databaseName, graphName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner> beginMigrateGremlinGraphToManualThroughput(String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        return this.beginMigrateGremlinGraphToManualThroughputAsync(resourceGroupName, accountName, databaseName, graphName, context).getSyncPoller();
    }

    @Override
    public Mono<ThroughputSettingsGetResultsInner> migrateGremlinGraphToManualThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return this.beginMigrateGremlinGraphToManualThroughputAsync(resourceGroupName, accountName, databaseName, graphName).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<ThroughputSettingsGetResultsInner> migrateGremlinGraphToManualThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        return this.beginMigrateGremlinGraphToManualThroughputAsync(resourceGroupName, accountName, databaseName, graphName, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public ThroughputSettingsGetResultsInner migrateGremlinGraphToManualThroughput(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return (ThroughputSettingsGetResultsInner)((Object)this.migrateGremlinGraphToManualThroughputAsync(resourceGroupName, accountName, databaseName, graphName).block());
    }

    @Override
    public ThroughputSettingsGetResultsInner migrateGremlinGraphToManualThroughput(String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        return (ThroughputSettingsGetResultsInner)((Object)this.migrateGremlinGraphToManualThroughputAsync(resourceGroupName, accountName, databaseName, graphName, context).block());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CosmosDBManagementCl")
    private static interface GremlinResourcesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GremlinDatabaseListResult>> listGremlinDatabases(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GremlinDatabaseGetResultsInner>> getGremlinDatabase(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createUpdateGremlinDatabase(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") GremlinDatabaseCreateUpdateParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> deleteGremlinDatabase(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/throughputSettings/default")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ThroughputSettingsGetResultsInner>> getGremlinDatabaseThroughput(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/throughputSettings/default")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> updateGremlinDatabaseThroughput(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ThroughputSettingsUpdateParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/throughputSettings/default/migrateToAutoscale")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> migrateGremlinDatabaseToAutoscale(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/throughputSettings/default/migrateToManualThroughput")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> migrateGremlinDatabaseToManualThroughput(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GremlinGraphListResult>> listGremlinGraphs(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GremlinGraphGetResultsInner>> getGremlinGraph(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="graphName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createUpdateGremlinGraph(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="graphName") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") GremlinGraphCreateUpdateParameters var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> deleteGremlinGraph(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="graphName") String var6, @QueryParam(value="api-version") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}/throughputSettings/default")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ThroughputSettingsGetResultsInner>> getGremlinGraphThroughput(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="graphName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}/throughputSettings/default")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> updateGremlinGraphThroughput(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="graphName") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") ThroughputSettingsUpdateParameters var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}/throughputSettings/default/migrateToAutoscale")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> migrateGremlinGraphToAutoscale(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="graphName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}/throughputSettings/default/migrateToManualThroughput")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> migrateGremlinGraphToManualThroughput(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="graphName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

