/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.ArmProxyResource;
import com.azure.resourcemanager.cosmos.models.DataCenterResourceProperties;
import java.io.IOException;

public final class DataCenterResourceInner
extends ArmProxyResource {
    private DataCenterResourceProperties properties;
    private String id;
    private String name;
    private String type;

    public DataCenterResourceProperties properties() {
        return this.properties;
    }

    public DataCenterResourceInner withProperties(DataCenterResourceProperties properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static DataCenterResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (DataCenterResourceInner)((Object)jsonReader.readObject(reader -> {
            DataCenterResourceInner deserializedDataCenterResourceInner = new DataCenterResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDataCenterResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDataCenterResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDataCenterResourceInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDataCenterResourceInner.properties = DataCenterResourceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataCenterResourceInner;
        }));
    }
}

