/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.MongoDBDatabaseGetProperties;
import com.azure.resourcemanager.cosmos.models.ArmResourceProperties;
import com.azure.resourcemanager.cosmos.models.MongoDBDatabaseGetPropertiesOptions;
import com.azure.resourcemanager.cosmos.models.MongoDBDatabaseGetPropertiesResource;
import java.io.IOException;
import java.util.Map;

public final class MongoDBDatabaseGetResultsInner
extends ArmResourceProperties {
    private MongoDBDatabaseGetProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private MongoDBDatabaseGetProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public MongoDBDatabaseGetResultsInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public MongoDBDatabaseGetResultsInner withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public MongoDBDatabaseGetPropertiesResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    public MongoDBDatabaseGetResultsInner withResource(MongoDBDatabaseGetPropertiesResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoDBDatabaseGetProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    public MongoDBDatabaseGetPropertiesOptions options() {
        return this.innerProperties() == null ? null : this.innerProperties().options();
    }

    public MongoDBDatabaseGetResultsInner withOptions(MongoDBDatabaseGetPropertiesOptions options) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoDBDatabaseGetProperties();
        }
        this.innerProperties().withOptions(options);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static MongoDBDatabaseGetResultsInner fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDBDatabaseGetResultsInner)((Object)jsonReader.readObject(reader -> {
            MongoDBDatabaseGetResultsInner deserializedMongoDBDatabaseGetResultsInner = new MongoDBDatabaseGetResultsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMongoDBDatabaseGetResultsInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMongoDBDatabaseGetResultsInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMongoDBDatabaseGetResultsInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedMongoDBDatabaseGetResultsInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedMongoDBDatabaseGetResultsInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedMongoDBDatabaseGetResultsInner.innerProperties = MongoDBDatabaseGetProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoDBDatabaseGetResultsInner;
        }));
    }
}

