/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.UsageInner;
import com.azure.resourcemanager.cosmos.models.MetricName;
import com.azure.resourcemanager.cosmos.models.UnitType;
import java.io.IOException;

public final class PartitionUsageInner
extends UsageInner {
    private String partitionId;
    private String partitionKeyRangeId;
    private UnitType unit;
    private MetricName name;
    private String quotaPeriod;
    private Long limit;
    private Long currentValue;

    public String partitionId() {
        return this.partitionId;
    }

    public String partitionKeyRangeId() {
        return this.partitionKeyRangeId;
    }

    @Override
    public UnitType unit() {
        return this.unit;
    }

    @Override
    public MetricName name() {
        return this.name;
    }

    @Override
    public String quotaPeriod() {
        return this.quotaPeriod;
    }

    @Override
    public Long limit() {
        return this.limit;
    }

    @Override
    public Long currentValue() {
        return this.currentValue;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static PartitionUsageInner fromJson(JsonReader jsonReader) throws IOException {
        return (PartitionUsageInner)jsonReader.readObject(reader -> {
            PartitionUsageInner deserializedPartitionUsageInner = new PartitionUsageInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("unit".equals(fieldName)) {
                    deserializedPartitionUsageInner.unit = UnitType.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPartitionUsageInner.name = MetricName.fromJson(reader);
                    continue;
                }
                if ("quotaPeriod".equals(fieldName)) {
                    deserializedPartitionUsageInner.quotaPeriod = reader.getString();
                    continue;
                }
                if ("limit".equals(fieldName)) {
                    deserializedPartitionUsageInner.limit = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("currentValue".equals(fieldName)) {
                    deserializedPartitionUsageInner.currentValue = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("partitionId".equals(fieldName)) {
                    deserializedPartitionUsageInner.partitionId = reader.getString();
                    continue;
                }
                if ("partitionKeyRangeId".equals(fieldName)) {
                    deserializedPartitionUsageInner.partitionKeyRangeId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPartitionUsageInner;
        });
    }
}

