/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.TableGetProperties;
import com.azure.resourcemanager.cosmos.models.ArmResourceProperties;
import com.azure.resourcemanager.cosmos.models.TableGetPropertiesOptions;
import com.azure.resourcemanager.cosmos.models.TableGetPropertiesResource;
import java.io.IOException;
import java.util.Map;

public final class TableGetResultsInner
extends ArmResourceProperties {
    private TableGetProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private TableGetProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public TableGetResultsInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public TableGetResultsInner withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public TableGetPropertiesResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    public TableGetResultsInner withResource(TableGetPropertiesResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TableGetProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    public TableGetPropertiesOptions options() {
        return this.innerProperties() == null ? null : this.innerProperties().options();
    }

    public TableGetResultsInner withOptions(TableGetPropertiesOptions options) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TableGetProperties();
        }
        this.innerProperties().withOptions(options);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static TableGetResultsInner fromJson(JsonReader jsonReader) throws IOException {
        return (TableGetResultsInner)((Object)jsonReader.readObject(reader -> {
            TableGetResultsInner deserializedTableGetResultsInner = new TableGetResultsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTableGetResultsInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedTableGetResultsInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTableGetResultsInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedTableGetResultsInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedTableGetResultsInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedTableGetResultsInner.innerProperties = TableGetProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTableGetResultsInner;
        }));
    }
}

