/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.ClientEncryptionPolicy;
import com.azure.resourcemanager.cosmos.models.ComputedProperty;
import com.azure.resourcemanager.cosmos.models.ConflictResolutionPolicy;
import com.azure.resourcemanager.cosmos.models.ContainerPartitionKey;
import com.azure.resourcemanager.cosmos.models.CreateMode;
import com.azure.resourcemanager.cosmos.models.IndexingPolicy;
import com.azure.resourcemanager.cosmos.models.ResourceRestoreParameters;
import com.azure.resourcemanager.cosmos.models.SqlContainerResource;
import com.azure.resourcemanager.cosmos.models.UniqueKeyPolicy;
import java.io.IOException;
import java.util.List;

public final class SqlContainerGetPropertiesResource
extends SqlContainerResource {
    private String rid;
    private Float ts;
    private String etag;

    public String rid() {
        return this.rid;
    }

    public Float ts() {
        return this.ts;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public SqlContainerGetPropertiesResource withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public SqlContainerGetPropertiesResource withIndexingPolicy(IndexingPolicy indexingPolicy) {
        super.withIndexingPolicy(indexingPolicy);
        return this;
    }

    @Override
    public SqlContainerGetPropertiesResource withPartitionKey(ContainerPartitionKey partitionKey) {
        super.withPartitionKey(partitionKey);
        return this;
    }

    @Override
    public SqlContainerGetPropertiesResource withDefaultTtl(Integer defaultTtl) {
        super.withDefaultTtl(defaultTtl);
        return this;
    }

    @Override
    public SqlContainerGetPropertiesResource withUniqueKeyPolicy(UniqueKeyPolicy uniqueKeyPolicy) {
        super.withUniqueKeyPolicy(uniqueKeyPolicy);
        return this;
    }

    @Override
    public SqlContainerGetPropertiesResource withConflictResolutionPolicy(ConflictResolutionPolicy conflictResolutionPolicy) {
        super.withConflictResolutionPolicy(conflictResolutionPolicy);
        return this;
    }

    @Override
    public SqlContainerGetPropertiesResource withClientEncryptionPolicy(ClientEncryptionPolicy clientEncryptionPolicy) {
        super.withClientEncryptionPolicy(clientEncryptionPolicy);
        return this;
    }

    @Override
    public SqlContainerGetPropertiesResource withAnalyticalStorageTtl(Long analyticalStorageTtl) {
        super.withAnalyticalStorageTtl(analyticalStorageTtl);
        return this;
    }

    @Override
    public SqlContainerGetPropertiesResource withRestoreParameters(ResourceRestoreParameters restoreParameters) {
        super.withRestoreParameters(restoreParameters);
        return this;
    }

    @Override
    public SqlContainerGetPropertiesResource withCreateMode(CreateMode createMode) {
        super.withCreateMode(createMode);
        return this;
    }

    @Override
    public SqlContainerGetPropertiesResource withComputedProperties(List<ComputedProperty> computedProperties) {
        super.withComputedProperties(computedProperties);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("indexingPolicy", (JsonSerializable)this.indexingPolicy());
        jsonWriter.writeJsonField("partitionKey", (JsonSerializable)this.partitionKey());
        jsonWriter.writeNumberField("defaultTtl", (Number)this.defaultTtl());
        jsonWriter.writeJsonField("uniqueKeyPolicy", (JsonSerializable)this.uniqueKeyPolicy());
        jsonWriter.writeJsonField("conflictResolutionPolicy", (JsonSerializable)this.conflictResolutionPolicy());
        jsonWriter.writeJsonField("clientEncryptionPolicy", (JsonSerializable)this.clientEncryptionPolicy());
        jsonWriter.writeNumberField("analyticalStorageTtl", (Number)this.analyticalStorageTtl());
        jsonWriter.writeJsonField("restoreParameters", (JsonSerializable)this.restoreParameters());
        jsonWriter.writeStringField("createMode", this.createMode() == null ? null : this.createMode().toString());
        jsonWriter.writeArrayField("computedProperties", this.computedProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SqlContainerGetPropertiesResource fromJson(JsonReader jsonReader) throws IOException {
        return (SqlContainerGetPropertiesResource)jsonReader.readObject(reader -> {
            SqlContainerGetPropertiesResource deserializedSqlContainerGetPropertiesResource = new SqlContainerGetPropertiesResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.withId(reader.getString());
                    continue;
                }
                if ("indexingPolicy".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.withIndexingPolicy(IndexingPolicy.fromJson(reader));
                    continue;
                }
                if ("partitionKey".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.withPartitionKey(ContainerPartitionKey.fromJson(reader));
                    continue;
                }
                if ("defaultTtl".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.withDefaultTtl((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("uniqueKeyPolicy".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.withUniqueKeyPolicy(UniqueKeyPolicy.fromJson(reader));
                    continue;
                }
                if ("conflictResolutionPolicy".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.withConflictResolutionPolicy(ConflictResolutionPolicy.fromJson(reader));
                    continue;
                }
                if ("clientEncryptionPolicy".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.withClientEncryptionPolicy(ClientEncryptionPolicy.fromJson(reader));
                    continue;
                }
                if ("analyticalStorageTtl".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.withAnalyticalStorageTtl((Long)reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if ("restoreParameters".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.withRestoreParameters(ResourceRestoreParameters.fromJson(reader));
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.withCreateMode(CreateMode.fromString(reader.getString()));
                    continue;
                }
                if ("computedProperties".equals(fieldName)) {
                    List computedProperties = reader.readArray(reader1 -> ComputedProperty.fromJson(reader1));
                    deserializedSqlContainerGetPropertiesResource.withComputedProperties(computedProperties);
                    continue;
                }
                if ("_rid".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.rid = reader.getString();
                    continue;
                }
                if ("_ts".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.ts = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("_etag".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlContainerGetPropertiesResource;
        });
    }
}

