/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.AutoscaleSettings;
import com.azure.resourcemanager.cosmos.models.OptionsResource;
import java.io.IOException;

public final class SqlDatabaseGetPropertiesOptions
extends OptionsResource {
    @Override
    public SqlDatabaseGetPropertiesOptions withThroughput(Integer throughput) {
        super.withThroughput(throughput);
        return this;
    }

    @Override
    public SqlDatabaseGetPropertiesOptions withAutoscaleSettings(AutoscaleSettings autoscaleSettings) {
        super.withAutoscaleSettings(autoscaleSettings);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("throughput", (Number)this.throughput());
        jsonWriter.writeJsonField("autoscaleSettings", (JsonSerializable)this.autoscaleSettings());
        return jsonWriter.writeEndObject();
    }

    public static SqlDatabaseGetPropertiesOptions fromJson(JsonReader jsonReader) throws IOException {
        return (SqlDatabaseGetPropertiesOptions)jsonReader.readObject(reader -> {
            SqlDatabaseGetPropertiesOptions deserializedSqlDatabaseGetPropertiesOptions = new SqlDatabaseGetPropertiesOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("throughput".equals(fieldName)) {
                    deserializedSqlDatabaseGetPropertiesOptions.withThroughput((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("autoscaleSettings".equals(fieldName)) {
                    deserializedSqlDatabaseGetPropertiesOptions.withAutoscaleSettings(AutoscaleSettings.fromJson(reader));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlDatabaseGetPropertiesOptions;
        });
    }
}

