/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.DedicatedGatewayType;
import com.azure.resourcemanager.cosmos.models.ServiceResourceCreateUpdateProperties;
import com.azure.resourcemanager.cosmos.models.ServiceSize;
import com.azure.resourcemanager.cosmos.models.ServiceType;
import java.io.IOException;

public final class SqlDedicatedGatewayServiceResourceCreateUpdateParameters
extends ServiceResourceCreateUpdateProperties {
    private ServiceType serviceType = ServiceType.SQL_DEDICATED_GATEWAY;
    private DedicatedGatewayType dedicatedGatewayType;

    @Override
    public ServiceType serviceType() {
        return this.serviceType;
    }

    public DedicatedGatewayType dedicatedGatewayType() {
        return this.dedicatedGatewayType;
    }

    public SqlDedicatedGatewayServiceResourceCreateUpdateParameters withDedicatedGatewayType(DedicatedGatewayType dedicatedGatewayType) {
        this.dedicatedGatewayType = dedicatedGatewayType;
        return this;
    }

    @Override
    public SqlDedicatedGatewayServiceResourceCreateUpdateParameters withInstanceSize(ServiceSize instanceSize) {
        super.withInstanceSize(instanceSize);
        return this;
    }

    @Override
    public SqlDedicatedGatewayServiceResourceCreateUpdateParameters withInstanceCount(Integer instanceCount) {
        super.withInstanceCount(instanceCount);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("instanceSize", this.instanceSize() == null ? null : this.instanceSize().toString());
        jsonWriter.writeNumberField("instanceCount", (Number)this.instanceCount());
        jsonWriter.writeStringField("serviceType", this.serviceType == null ? null : this.serviceType.toString());
        jsonWriter.writeStringField("dedicatedGatewayType", this.dedicatedGatewayType == null ? null : this.dedicatedGatewayType.toString());
        return jsonWriter.writeEndObject();
    }

    public static SqlDedicatedGatewayServiceResourceCreateUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (SqlDedicatedGatewayServiceResourceCreateUpdateParameters)jsonReader.readObject(reader -> {
            SqlDedicatedGatewayServiceResourceCreateUpdateParameters deserializedSqlDedicatedGatewayServiceResourceCreateUpdateParameters = new SqlDedicatedGatewayServiceResourceCreateUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("instanceSize".equals(fieldName)) {
                    deserializedSqlDedicatedGatewayServiceResourceCreateUpdateParameters.withInstanceSize(ServiceSize.fromString(reader.getString()));
                    continue;
                }
                if ("instanceCount".equals(fieldName)) {
                    deserializedSqlDedicatedGatewayServiceResourceCreateUpdateParameters.withInstanceCount((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("serviceType".equals(fieldName)) {
                    deserializedSqlDedicatedGatewayServiceResourceCreateUpdateParameters.serviceType = ServiceType.fromString(reader.getString());
                    continue;
                }
                if ("dedicatedGatewayType".equals(fieldName)) {
                    deserializedSqlDedicatedGatewayServiceResourceCreateUpdateParameters.dedicatedGatewayType = DedicatedGatewayType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlDedicatedGatewayServiceResourceCreateUpdateParameters;
        });
    }
}

