// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.MetricAvailability;
import com.azure.resourcemanager.cosmos.models.MetricName;
import com.azure.resourcemanager.cosmos.models.PrimaryAggregationType;
import com.azure.resourcemanager.cosmos.models.UnitType;
import java.io.IOException;
import java.util.List;

/**
 * The definition of a metric.
 */
@Immutable
public final class MetricDefinitionInner implements JsonSerializable<MetricDefinitionInner> {
    /*
     * The list of metric availabilities for the account.
     */
    private List<MetricAvailability> metricAvailabilities;

    /*
     * The primary aggregation type of the metric.
     */
    private PrimaryAggregationType primaryAggregationType;

    /*
     * The unit of the metric.
     */
    private UnitType unit;

    /*
     * The resource uri of the database.
     */
    private String resourceUri;

    /*
     * The name information for the metric.
     */
    private MetricName name;

    /**
     * Creates an instance of MetricDefinitionInner class.
     */
    public MetricDefinitionInner() {
    }

    /**
     * Get the metricAvailabilities property: The list of metric availabilities for the account.
     * 
     * @return the metricAvailabilities value.
     */
    public List<MetricAvailability> metricAvailabilities() {
        return this.metricAvailabilities;
    }

    /**
     * Get the primaryAggregationType property: The primary aggregation type of the metric.
     * 
     * @return the primaryAggregationType value.
     */
    public PrimaryAggregationType primaryAggregationType() {
        return this.primaryAggregationType;
    }

    /**
     * Get the unit property: The unit of the metric.
     * 
     * @return the unit value.
     */
    public UnitType unit() {
        return this.unit;
    }

    /**
     * Get the resourceUri property: The resource uri of the database.
     * 
     * @return the resourceUri value.
     */
    public String resourceUri() {
        return this.resourceUri;
    }

    /**
     * Get the name property: The name information for the metric.
     * 
     * @return the name value.
     */
    public MetricName name() {
        return this.name;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (metricAvailabilities() != null) {
            metricAvailabilities().forEach(e -> e.validate());
        }
        if (name() != null) {
            name().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MetricDefinitionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MetricDefinitionInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MetricDefinitionInner.
     */
    public static MetricDefinitionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricDefinitionInner deserializedMetricDefinitionInner = new MetricDefinitionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("metricAvailabilities".equals(fieldName)) {
                    List<MetricAvailability> metricAvailabilities
                        = reader.readArray(reader1 -> MetricAvailability.fromJson(reader1));
                    deserializedMetricDefinitionInner.metricAvailabilities = metricAvailabilities;
                } else if ("primaryAggregationType".equals(fieldName)) {
                    deserializedMetricDefinitionInner.primaryAggregationType
                        = PrimaryAggregationType.fromString(reader.getString());
                } else if ("unit".equals(fieldName)) {
                    deserializedMetricDefinitionInner.unit = UnitType.fromString(reader.getString());
                } else if ("resourceUri".equals(fieldName)) {
                    deserializedMetricDefinitionInner.resourceUri = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedMetricDefinitionInner.name = MetricName.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMetricDefinitionInner;
        });
    }
}
