// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Configuration values for periodic mode backup.
 */
@Fluent
public final class ContinuousModeProperties implements JsonSerializable<ContinuousModeProperties> {
    /*
     * Enum to indicate type of Continuous backup mode
     */
    private ContinuousTier tier;

    /**
     * Creates an instance of ContinuousModeProperties class.
     */
    public ContinuousModeProperties() {
    }

    /**
     * Get the tier property: Enum to indicate type of Continuous backup mode.
     * 
     * @return the tier value.
     */
    public ContinuousTier tier() {
        return this.tier;
    }

    /**
     * Set the tier property: Enum to indicate type of Continuous backup mode.
     * 
     * @param tier the tier value to set.
     * @return the ContinuousModeProperties object itself.
     */
    public ContinuousModeProperties withTier(ContinuousTier tier) {
        this.tier = tier;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tier", this.tier == null ? null : this.tier.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContinuousModeProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContinuousModeProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContinuousModeProperties.
     */
    public static ContinuousModeProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContinuousModeProperties deserializedContinuousModeProperties = new ContinuousModeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tier".equals(fieldName)) {
                    deserializedContinuousModeProperties.tier = ContinuousTier.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContinuousModeProperties;
        });
    }
}
