// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The metadata related to each access key for the given Cosmos DB database account.
 */
@Immutable
public final class DatabaseAccountKeysMetadata implements JsonSerializable<DatabaseAccountKeysMetadata> {
    /*
     * The metadata related to the Primary Read-Write Key for the given Cosmos DB database account.
     */
    private AccountKeyMetadata primaryMasterKey;

    /*
     * The metadata related to the Secondary Read-Write Key for the given Cosmos DB database account.
     */
    private AccountKeyMetadata secondaryMasterKey;

    /*
     * The metadata related to the Primary Read-Only Key for the given Cosmos DB database account.
     */
    private AccountKeyMetadata primaryReadonlyMasterKey;

    /*
     * The metadata related to the Secondary Read-Only Key for the given Cosmos DB database account.
     */
    private AccountKeyMetadata secondaryReadonlyMasterKey;

    /**
     * Creates an instance of DatabaseAccountKeysMetadata class.
     */
    public DatabaseAccountKeysMetadata() {
    }

    /**
     * Get the primaryMasterKey property: The metadata related to the Primary Read-Write Key for the given Cosmos DB
     * database account.
     * 
     * @return the primaryMasterKey value.
     */
    public AccountKeyMetadata primaryMasterKey() {
        return this.primaryMasterKey;
    }

    /**
     * Get the secondaryMasterKey property: The metadata related to the Secondary Read-Write Key for the given Cosmos DB
     * database account.
     * 
     * @return the secondaryMasterKey value.
     */
    public AccountKeyMetadata secondaryMasterKey() {
        return this.secondaryMasterKey;
    }

    /**
     * Get the primaryReadonlyMasterKey property: The metadata related to the Primary Read-Only Key for the given Cosmos
     * DB database account.
     * 
     * @return the primaryReadonlyMasterKey value.
     */
    public AccountKeyMetadata primaryReadonlyMasterKey() {
        return this.primaryReadonlyMasterKey;
    }

    /**
     * Get the secondaryReadonlyMasterKey property: The metadata related to the Secondary Read-Only Key for the given
     * Cosmos DB database account.
     * 
     * @return the secondaryReadonlyMasterKey value.
     */
    public AccountKeyMetadata secondaryReadonlyMasterKey() {
        return this.secondaryReadonlyMasterKey;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (primaryMasterKey() != null) {
            primaryMasterKey().validate();
        }
        if (secondaryMasterKey() != null) {
            secondaryMasterKey().validate();
        }
        if (primaryReadonlyMasterKey() != null) {
            primaryReadonlyMasterKey().validate();
        }
        if (secondaryReadonlyMasterKey() != null) {
            secondaryReadonlyMasterKey().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DatabaseAccountKeysMetadata from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DatabaseAccountKeysMetadata if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DatabaseAccountKeysMetadata.
     */
    public static DatabaseAccountKeysMetadata fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DatabaseAccountKeysMetadata deserializedDatabaseAccountKeysMetadata = new DatabaseAccountKeysMetadata();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("primaryMasterKey".equals(fieldName)) {
                    deserializedDatabaseAccountKeysMetadata.primaryMasterKey = AccountKeyMetadata.fromJson(reader);
                } else if ("secondaryMasterKey".equals(fieldName)) {
                    deserializedDatabaseAccountKeysMetadata.secondaryMasterKey = AccountKeyMetadata.fromJson(reader);
                } else if ("primaryReadonlyMasterKey".equals(fieldName)) {
                    deserializedDatabaseAccountKeysMetadata.primaryReadonlyMasterKey
                        = AccountKeyMetadata.fromJson(reader);
                } else if ("secondaryReadonlyMasterKey".equals(fieldName)) {
                    deserializedDatabaseAccountKeysMetadata.secondaryReadonlyMasterKey
                        = AccountKeyMetadata.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDatabaseAccountKeysMetadata;
        });
    }
}
