// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameters for Create or Update request for ServiceResource.
 */
@Fluent
public final class ServiceResourceCreateUpdateParameters
    implements JsonSerializable<ServiceResourceCreateUpdateParameters> {
    /*
     * Properties in ServiceResourceCreateUpdateParameters.
     */
    private ServiceResourceCreateUpdateProperties properties;

    /**
     * Creates an instance of ServiceResourceCreateUpdateParameters class.
     */
    public ServiceResourceCreateUpdateParameters() {
    }

    /**
     * Get the properties property: Properties in ServiceResourceCreateUpdateParameters.
     * 
     * @return the properties value.
     */
    public ServiceResourceCreateUpdateProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties in ServiceResourceCreateUpdateParameters.
     * 
     * @param properties the properties value to set.
     * @return the ServiceResourceCreateUpdateParameters object itself.
     */
    public ServiceResourceCreateUpdateParameters withProperties(ServiceResourceCreateUpdateProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServiceResourceCreateUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServiceResourceCreateUpdateParameters if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServiceResourceCreateUpdateParameters.
     */
    public static ServiceResourceCreateUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServiceResourceCreateUpdateParameters deserializedServiceResourceCreateUpdateParameters
                = new ServiceResourceCreateUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedServiceResourceCreateUpdateParameters.properties
                        = ServiceResourceCreateUpdateProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServiceResourceCreateUpdateParameters;
        });
    }
}
