/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.ClientEncryptionKeyResource;
import java.io.IOException;

public final class ClientEncryptionKeyCreateUpdateProperties
implements JsonSerializable<ClientEncryptionKeyCreateUpdateProperties> {
    private ClientEncryptionKeyResource resource;
    private static final ClientLogger LOGGER = new ClientLogger(ClientEncryptionKeyCreateUpdateProperties.class);

    public ClientEncryptionKeyResource resource() {
        return this.resource;
    }

    public ClientEncryptionKeyCreateUpdateProperties withResource(ClientEncryptionKeyResource resource) {
        this.resource = resource;
        return this;
    }

    public void validate() {
        if (this.resource() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resource in model ClientEncryptionKeyCreateUpdateProperties"));
        }
        this.resource().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("resource", (JsonSerializable)this.resource);
        return jsonWriter.writeEndObject();
    }

    public static ClientEncryptionKeyCreateUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ClientEncryptionKeyCreateUpdateProperties)jsonReader.readObject(reader -> {
            ClientEncryptionKeyCreateUpdateProperties deserializedClientEncryptionKeyCreateUpdateProperties = new ClientEncryptionKeyCreateUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resource".equals(fieldName)) {
                    deserializedClientEncryptionKeyCreateUpdateProperties.resource = ClientEncryptionKeyResource.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClientEncryptionKeyCreateUpdateProperties;
        });
    }
}

