/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public class ArmResourceProperties
extends Resource {
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(ArmResourceProperties.class);

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ArmResourceProperties withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ArmResourceProperties withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model ArmResourceProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ArmResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ArmResourceProperties)((Object)jsonReader.readObject(reader -> {
            ArmResourceProperties deserializedArmResourceProperties = new ArmResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedArmResourceProperties.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedArmResourceProperties.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedArmResourceProperties.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedArmResourceProperties.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedArmResourceProperties.withTags(tags);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedArmResourceProperties;
        }));
    }
}

