// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.ClientEncryptionKeyCreateUpdateProperties;
import java.io.IOException;

/**
 * Parameters to create and update ClientEncryptionKey.
 */
@Fluent
public final class ClientEncryptionKeyCreateUpdateParameters
    implements JsonSerializable<ClientEncryptionKeyCreateUpdateParameters> {
    /*
     * Properties to create and update ClientEncryptionKey.
     */
    private ClientEncryptionKeyCreateUpdateProperties innerProperties = new ClientEncryptionKeyCreateUpdateProperties();

    /**
     * Creates an instance of ClientEncryptionKeyCreateUpdateParameters class.
     */
    public ClientEncryptionKeyCreateUpdateParameters() {
    }

    /**
     * Get the innerProperties property: Properties to create and update ClientEncryptionKey.
     * 
     * @return the innerProperties value.
     */
    private ClientEncryptionKeyCreateUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the resource property: The standard JSON format of a ClientEncryptionKey.
     * 
     * @return the resource value.
     */
    public ClientEncryptionKeyResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    /**
     * Set the resource property: The standard JSON format of a ClientEncryptionKey.
     * 
     * @param resource the resource value to set.
     * @return the ClientEncryptionKeyCreateUpdateParameters object itself.
     */
    public ClientEncryptionKeyCreateUpdateParameters withResource(ClientEncryptionKeyResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClientEncryptionKeyCreateUpdateProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerProperties in model ClientEncryptionKeyCreateUpdateParameters"));
        } else {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ClientEncryptionKeyCreateUpdateParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ClientEncryptionKeyCreateUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ClientEncryptionKeyCreateUpdateParameters if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ClientEncryptionKeyCreateUpdateParameters.
     */
    public static ClientEncryptionKeyCreateUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClientEncryptionKeyCreateUpdateParameters deserializedClientEncryptionKeyCreateUpdateParameters
                = new ClientEncryptionKeyCreateUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedClientEncryptionKeyCreateUpdateParameters.innerProperties
                        = ClientEncryptionKeyCreateUpdateProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedClientEncryptionKeyCreateUpdateParameters;
        });
    }
}
