// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents key wrap metadata that a key wrapping provider can use to wrap/unwrap a client encryption key.
 */
@Fluent
public final class KeyWrapMetadata implements JsonSerializable<KeyWrapMetadata> {
    /*
     * The name of associated KeyEncryptionKey (aka CustomerManagedKey).
     */
    private String name;

    /*
     * ProviderName of KeyStoreProvider.
     */
    private String type;

    /*
     * Reference / link to the KeyEncryptionKey.
     */
    private String value;

    /*
     * Algorithm used in wrapping and unwrapping of the data encryption key.
     */
    private String algorithm;

    /**
     * Creates an instance of KeyWrapMetadata class.
     */
    public KeyWrapMetadata() {
    }

    /**
     * Get the name property: The name of associated KeyEncryptionKey (aka CustomerManagedKey).
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of associated KeyEncryptionKey (aka CustomerManagedKey).
     * 
     * @param name the name value to set.
     * @return the KeyWrapMetadata object itself.
     */
    public KeyWrapMetadata withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: ProviderName of KeyStoreProvider.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: ProviderName of KeyStoreProvider.
     * 
     * @param type the type value to set.
     * @return the KeyWrapMetadata object itself.
     */
    public KeyWrapMetadata withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the value property: Reference / link to the KeyEncryptionKey.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Reference / link to the KeyEncryptionKey.
     * 
     * @param value the value value to set.
     * @return the KeyWrapMetadata object itself.
     */
    public KeyWrapMetadata withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the algorithm property: Algorithm used in wrapping and unwrapping of the data encryption key.
     * 
     * @return the algorithm value.
     */
    public String algorithm() {
        return this.algorithm;
    }

    /**
     * Set the algorithm property: Algorithm used in wrapping and unwrapping of the data encryption key.
     * 
     * @param algorithm the algorithm value to set.
     * @return the KeyWrapMetadata object itself.
     */
    public KeyWrapMetadata withAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("algorithm", this.algorithm);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyWrapMetadata from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyWrapMetadata if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the KeyWrapMetadata.
     */
    public static KeyWrapMetadata fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyWrapMetadata deserializedKeyWrapMetadata = new KeyWrapMetadata();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedKeyWrapMetadata.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedKeyWrapMetadata.type = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedKeyWrapMetadata.value = reader.getString();
                } else if ("algorithm".equals(fieldName)) {
                    deserializedKeyWrapMetadata.algorithm = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyWrapMetadata;
        });
    }
}
