// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.MongoDBCollectionGetResultsInner;
import java.io.IOException;
import java.util.List;

/**
 * The List operation response, that contains the MongoDB collections and their properties.
 */
@Immutable
public final class MongoDBCollectionListResult implements JsonSerializable<MongoDBCollectionListResult> {
    /*
     * List of MongoDB collections and their properties.
     */
    private List<MongoDBCollectionGetResultsInner> value;

    /**
     * Creates an instance of MongoDBCollectionListResult class.
     */
    public MongoDBCollectionListResult() {
    }

    /**
     * Get the value property: List of MongoDB collections and their properties.
     * 
     * @return the value value.
     */
    public List<MongoDBCollectionGetResultsInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MongoDBCollectionListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MongoDBCollectionListResult if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MongoDBCollectionListResult.
     */
    public static MongoDBCollectionListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MongoDBCollectionListResult deserializedMongoDBCollectionListResult = new MongoDBCollectionListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<MongoDBCollectionGetResultsInner> value
                        = reader.readArray(reader1 -> MongoDBCollectionGetResultsInner.fromJson(reader1));
                    deserializedMongoDBCollectionListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMongoDBCollectionListResult;
        });
    }
}
