/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.CassandraTableGetProperties;
import com.azure.resourcemanager.cosmos.models.ArmResourceProperties;
import com.azure.resourcemanager.cosmos.models.CassandraTableGetPropertiesOptions;
import com.azure.resourcemanager.cosmos.models.CassandraTableGetPropertiesResource;
import java.io.IOException;
import java.util.Map;

public final class CassandraTableGetResultsInner
extends ArmResourceProperties {
    private CassandraTableGetProperties innerProperties;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(CassandraTableGetResultsInner.class);

    private CassandraTableGetProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public CassandraTableGetResultsInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public CassandraTableGetResultsInner withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public CassandraTableGetPropertiesResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    public CassandraTableGetResultsInner withResource(CassandraTableGetPropertiesResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CassandraTableGetProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    public CassandraTableGetPropertiesOptions options() {
        return this.innerProperties() == null ? null : this.innerProperties().options();
    }

    public CassandraTableGetResultsInner withOptions(CassandraTableGetPropertiesOptions options) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CassandraTableGetProperties();
        }
        this.innerProperties().withOptions(options);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model CassandraTableGetResultsInner"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static CassandraTableGetResultsInner fromJson(JsonReader jsonReader) throws IOException {
        return (CassandraTableGetResultsInner)((Object)jsonReader.readObject(reader -> {
            CassandraTableGetResultsInner deserializedCassandraTableGetResultsInner = new CassandraTableGetResultsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCassandraTableGetResultsInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCassandraTableGetResultsInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCassandraTableGetResultsInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedCassandraTableGetResultsInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedCassandraTableGetResultsInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCassandraTableGetResultsInner.innerProperties = CassandraTableGetProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCassandraTableGetResultsInner;
        }));
    }
}

