/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.MongoDBCollectionCreateUpdateProperties;
import com.azure.resourcemanager.cosmos.models.ArmResourceProperties;
import com.azure.resourcemanager.cosmos.models.CreateUpdateOptions;
import com.azure.resourcemanager.cosmos.models.MongoDBCollectionResource;
import java.io.IOException;
import java.util.Map;

public final class MongoDBCollectionCreateUpdateParameters
extends ArmResourceProperties {
    private MongoDBCollectionCreateUpdateProperties innerProperties = new MongoDBCollectionCreateUpdateProperties();
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(MongoDBCollectionCreateUpdateParameters.class);

    private MongoDBCollectionCreateUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public MongoDBCollectionCreateUpdateParameters withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public MongoDBCollectionCreateUpdateParameters withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public MongoDBCollectionResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    public MongoDBCollectionCreateUpdateParameters withResource(MongoDBCollectionResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoDBCollectionCreateUpdateProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    public CreateUpdateOptions options() {
        return this.innerProperties() == null ? null : this.innerProperties().options();
    }

    public MongoDBCollectionCreateUpdateParameters withOptions(CreateUpdateOptions options) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoDBCollectionCreateUpdateProperties();
        }
        this.innerProperties().withOptions(options);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model MongoDBCollectionCreateUpdateParameters"));
        }
        this.innerProperties().validate();
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model MongoDBCollectionCreateUpdateParameters"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static MongoDBCollectionCreateUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDBCollectionCreateUpdateParameters)((Object)jsonReader.readObject(reader -> {
            MongoDBCollectionCreateUpdateParameters deserializedMongoDBCollectionCreateUpdateParameters = new MongoDBCollectionCreateUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMongoDBCollectionCreateUpdateParameters.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMongoDBCollectionCreateUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMongoDBCollectionCreateUpdateParameters.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedMongoDBCollectionCreateUpdateParameters.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedMongoDBCollectionCreateUpdateParameters.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedMongoDBCollectionCreateUpdateParameters.innerProperties = MongoDBCollectionCreateUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoDBCollectionCreateUpdateParameters;
        }));
    }
}

