// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.DatabaseAccountUpdateProperties;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Parameters for patching Azure Cosmos DB database account properties.
 */
@Fluent
public final class DatabaseAccountUpdateParameters implements JsonSerializable<DatabaseAccountUpdateParameters> {
    /*
     * Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping
     * this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a
     * key no greater than 128 characters and value no greater than 256 characters. For example, the default experience
     * for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include
     * "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    private Map<String, String> tags;

    /*
     * The location of the resource group to which the resource belongs.
     */
    private String location;

    /*
     * Identity for the resource.
     */
    private ManagedServiceIdentity identity;

    /*
     * Properties to update Azure Cosmos DB database accounts.
     */
    private DatabaseAccountUpdateProperties innerProperties;

    /**
     * Creates an instance of DatabaseAccountUpdateParameters class.
     */
    public DatabaseAccountUpdateParameters() {
    }

    /**
     * Get the tags property: Tags are a list of key-value pairs that describe the resource. These tags can be used in
     * viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource.
     * Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
     * the default experience for a template type is set with "defaultExperience": "Cassandra". Current
     * "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Tags are a list of key-value pairs that describe the resource. These tags can be used in
     * viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource.
     * Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
     * the default experience for a template type is set with "defaultExperience": "Cassandra". Current
     * "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     * 
     * @param tags the tags value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the location property: The location of the resource group to which the resource belongs.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The location of the resource group to which the resource belongs.
     * 
     * @param location the location value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the identity property: Identity for the resource.
     * 
     * @return the identity value.
     */
    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: Identity for the resource.
     * 
     * @param identity the identity value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the innerProperties property: Properties to update Azure Cosmos DB database accounts.
     * 
     * @return the innerProperties value.
     */
    private DatabaseAccountUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the consistencyPolicy property: The consistency policy for the Cosmos DB account.
     * 
     * @return the consistencyPolicy value.
     */
    public ConsistencyPolicy consistencyPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().consistencyPolicy();
    }

    /**
     * Set the consistencyPolicy property: The consistency policy for the Cosmos DB account.
     * 
     * @param consistencyPolicy the consistencyPolicy value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withConsistencyPolicy(ConsistencyPolicy consistencyPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withConsistencyPolicy(consistencyPolicy);
        return this;
    }

    /**
     * Get the locations property: An array that contains the georeplication locations enabled for the Cosmos DB
     * account.
     * 
     * @return the locations value.
     */
    public List<Location> locations() {
        return this.innerProperties() == null ? null : this.innerProperties().locations();
    }

    /**
     * Set the locations property: An array that contains the georeplication locations enabled for the Cosmos DB
     * account.
     * 
     * @param locations the locations value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withLocations(List<Location> locations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withLocations(locations);
        return this;
    }

    /**
     * Get the ipRules property: List of IpRules.
     * 
     * @return the ipRules value.
     */
    public List<IpAddressOrRange> ipRules() {
        return this.innerProperties() == null ? null : this.innerProperties().ipRules();
    }

    /**
     * Set the ipRules property: List of IpRules.
     * 
     * @param ipRules the ipRules value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withIpRules(List<IpAddressOrRange> ipRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withIpRules(ipRules);
        return this;
    }

    /**
     * Get the isVirtualNetworkFilterEnabled property: Flag to indicate whether to enable/disable Virtual Network ACL
     * rules.
     * 
     * @return the isVirtualNetworkFilterEnabled value.
     */
    public Boolean isVirtualNetworkFilterEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isVirtualNetworkFilterEnabled();
    }

    /**
     * Set the isVirtualNetworkFilterEnabled property: Flag to indicate whether to enable/disable Virtual Network ACL
     * rules.
     * 
     * @param isVirtualNetworkFilterEnabled the isVirtualNetworkFilterEnabled value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withIsVirtualNetworkFilterEnabled(Boolean isVirtualNetworkFilterEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withIsVirtualNetworkFilterEnabled(isVirtualNetworkFilterEnabled);
        return this;
    }

    /**
     * Get the enableAutomaticFailover property: Enables automatic failover of the write region in the rare event that
     * the region is unavailable due to an outage. Automatic failover will result in a new write region for the account
     * and is chosen based on the failover priorities configured for the account.
     * 
     * @return the enableAutomaticFailover value.
     */
    public Boolean enableAutomaticFailover() {
        return this.innerProperties() == null ? null : this.innerProperties().enableAutomaticFailover();
    }

    /**
     * Set the enableAutomaticFailover property: Enables automatic failover of the write region in the rare event that
     * the region is unavailable due to an outage. Automatic failover will result in a new write region for the account
     * and is chosen based on the failover priorities configured for the account.
     * 
     * @param enableAutomaticFailover the enableAutomaticFailover value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withEnableAutomaticFailover(Boolean enableAutomaticFailover) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withEnableAutomaticFailover(enableAutomaticFailover);
        return this;
    }

    /**
     * Get the capabilities property: List of Cosmos DB capabilities for the account.
     * 
     * @return the capabilities value.
     */
    public List<Capability> capabilities() {
        return this.innerProperties() == null ? null : this.innerProperties().capabilities();
    }

    /**
     * Set the capabilities property: List of Cosmos DB capabilities for the account.
     * 
     * @param capabilities the capabilities value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withCapabilities(List<Capability> capabilities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withCapabilities(capabilities);
        return this;
    }

    /**
     * Get the virtualNetworkRules property: List of Virtual Network ACL rules configured for the Cosmos DB account.
     * 
     * @return the virtualNetworkRules value.
     */
    public List<VirtualNetworkRule> virtualNetworkRules() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkRules();
    }

    /**
     * Set the virtualNetworkRules property: List of Virtual Network ACL rules configured for the Cosmos DB account.
     * 
     * @param virtualNetworkRules the virtualNetworkRules value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withVirtualNetworkRules(List<VirtualNetworkRule> virtualNetworkRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withVirtualNetworkRules(virtualNetworkRules);
        return this;
    }

    /**
     * Get the enableMultipleWriteLocations property: Enables the account to write in multiple locations.
     * 
     * @return the enableMultipleWriteLocations value.
     */
    public Boolean enableMultipleWriteLocations() {
        return this.innerProperties() == null ? null : this.innerProperties().enableMultipleWriteLocations();
    }

    /**
     * Set the enableMultipleWriteLocations property: Enables the account to write in multiple locations.
     * 
     * @param enableMultipleWriteLocations the enableMultipleWriteLocations value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withEnableMultipleWriteLocations(Boolean enableMultipleWriteLocations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withEnableMultipleWriteLocations(enableMultipleWriteLocations);
        return this;
    }

    /**
     * Get the enableCassandraConnector property: Enables the cassandra connector on the Cosmos DB C* account.
     * 
     * @return the enableCassandraConnector value.
     */
    public Boolean enableCassandraConnector() {
        return this.innerProperties() == null ? null : this.innerProperties().enableCassandraConnector();
    }

    /**
     * Set the enableCassandraConnector property: Enables the cassandra connector on the Cosmos DB C* account.
     * 
     * @param enableCassandraConnector the enableCassandraConnector value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withEnableCassandraConnector(Boolean enableCassandraConnector) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withEnableCassandraConnector(enableCassandraConnector);
        return this;
    }

    /**
     * Get the connectorOffer property: The cassandra connector offer type for the Cosmos DB database C* account.
     * 
     * @return the connectorOffer value.
     */
    public ConnectorOffer connectorOffer() {
        return this.innerProperties() == null ? null : this.innerProperties().connectorOffer();
    }

    /**
     * Set the connectorOffer property: The cassandra connector offer type for the Cosmos DB database C* account.
     * 
     * @param connectorOffer the connectorOffer value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withConnectorOffer(ConnectorOffer connectorOffer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withConnectorOffer(connectorOffer);
        return this;
    }

    /**
     * Get the disableKeyBasedMetadataWriteAccess property: Disable write operations on metadata resources (databases,
     * containers, throughput) via account keys.
     * 
     * @return the disableKeyBasedMetadataWriteAccess value.
     */
    public Boolean disableKeyBasedMetadataWriteAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().disableKeyBasedMetadataWriteAccess();
    }

    /**
     * Set the disableKeyBasedMetadataWriteAccess property: Disable write operations on metadata resources (databases,
     * containers, throughput) via account keys.
     * 
     * @param disableKeyBasedMetadataWriteAccess the disableKeyBasedMetadataWriteAccess value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters
        withDisableKeyBasedMetadataWriteAccess(Boolean disableKeyBasedMetadataWriteAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withDisableKeyBasedMetadataWriteAccess(disableKeyBasedMetadataWriteAccess);
        return this;
    }

    /**
     * Get the keyVaultKeyUri property: The URI of the key vault.
     * 
     * @return the keyVaultKeyUri value.
     */
    public String keyVaultKeyUri() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultKeyUri();
    }

    /**
     * Set the keyVaultKeyUri property: The URI of the key vault.
     * 
     * @param keyVaultKeyUri the keyVaultKeyUri value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withKeyVaultKeyUri(String keyVaultKeyUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withKeyVaultKeyUri(keyVaultKeyUri);
        return this;
    }

    /**
     * Get the defaultIdentity property: The default identity for accessing key vault used in features like customer
     * managed keys. The default identity needs to be explicitly set by the users. It can be "FirstPartyIdentity",
     * "SystemAssignedIdentity" and more.
     * 
     * @return the defaultIdentity value.
     */
    public String defaultIdentity() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultIdentity();
    }

    /**
     * Set the defaultIdentity property: The default identity for accessing key vault used in features like customer
     * managed keys. The default identity needs to be explicitly set by the users. It can be "FirstPartyIdentity",
     * "SystemAssignedIdentity" and more.
     * 
     * @param defaultIdentity the defaultIdentity value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withDefaultIdentity(String defaultIdentity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withDefaultIdentity(defaultIdentity);
        return this;
    }

    /**
     * Get the publicNetworkAccess property: Whether requests from Public Network are allowed.
     * 
     * @return the publicNetworkAccess value.
     */
    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    /**
     * Set the publicNetworkAccess property: Whether requests from Public Network are allowed.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    /**
     * Get the enableFreeTier property: Flag to indicate whether Free Tier is enabled.
     * 
     * @return the enableFreeTier value.
     */
    public Boolean enableFreeTier() {
        return this.innerProperties() == null ? null : this.innerProperties().enableFreeTier();
    }

    /**
     * Set the enableFreeTier property: Flag to indicate whether Free Tier is enabled.
     * 
     * @param enableFreeTier the enableFreeTier value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withEnableFreeTier(Boolean enableFreeTier) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withEnableFreeTier(enableFreeTier);
        return this;
    }

    /**
     * Get the apiProperties property: API specific properties. Currently, supported only for MongoDB API.
     * 
     * @return the apiProperties value.
     */
    public ApiProperties apiProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().apiProperties();
    }

    /**
     * Set the apiProperties property: API specific properties. Currently, supported only for MongoDB API.
     * 
     * @param apiProperties the apiProperties value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withApiProperties(ApiProperties apiProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withApiProperties(apiProperties);
        return this;
    }

    /**
     * Get the enableAnalyticalStorage property: Flag to indicate whether to enable storage analytics.
     * 
     * @return the enableAnalyticalStorage value.
     */
    public Boolean enableAnalyticalStorage() {
        return this.innerProperties() == null ? null : this.innerProperties().enableAnalyticalStorage();
    }

    /**
     * Set the enableAnalyticalStorage property: Flag to indicate whether to enable storage analytics.
     * 
     * @param enableAnalyticalStorage the enableAnalyticalStorage value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withEnableAnalyticalStorage(Boolean enableAnalyticalStorage) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withEnableAnalyticalStorage(enableAnalyticalStorage);
        return this;
    }

    /**
     * Get the analyticalStorageConfiguration property: Analytical storage specific properties.
     * 
     * @return the analyticalStorageConfiguration value.
     */
    public AnalyticalStorageConfiguration analyticalStorageConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().analyticalStorageConfiguration();
    }

    /**
     * Set the analyticalStorageConfiguration property: Analytical storage specific properties.
     * 
     * @param analyticalStorageConfiguration the analyticalStorageConfiguration value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters
        withAnalyticalStorageConfiguration(AnalyticalStorageConfiguration analyticalStorageConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withAnalyticalStorageConfiguration(analyticalStorageConfiguration);
        return this;
    }

    /**
     * Get the backupPolicy property: The object representing the policy for taking backups on an account.
     * 
     * @return the backupPolicy value.
     */
    public BackupPolicy backupPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().backupPolicy();
    }

    /**
     * Set the backupPolicy property: The object representing the policy for taking backups on an account.
     * 
     * @param backupPolicy the backupPolicy value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withBackupPolicy(BackupPolicy backupPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withBackupPolicy(backupPolicy);
        return this;
    }

    /**
     * Get the cors property: The CORS policy for the Cosmos DB database account.
     * 
     * @return the cors value.
     */
    public List<CorsPolicy> cors() {
        return this.innerProperties() == null ? null : this.innerProperties().cors();
    }

    /**
     * Set the cors property: The CORS policy for the Cosmos DB database account.
     * 
     * @param cors the cors value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withCors(List<CorsPolicy> cors) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withCors(cors);
        return this;
    }

    /**
     * Get the networkAclBypass property: Indicates what services are allowed to bypass firewall checks.
     * 
     * @return the networkAclBypass value.
     */
    public NetworkAclBypass networkAclBypass() {
        return this.innerProperties() == null ? null : this.innerProperties().networkAclBypass();
    }

    /**
     * Set the networkAclBypass property: Indicates what services are allowed to bypass firewall checks.
     * 
     * @param networkAclBypass the networkAclBypass value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withNetworkAclBypass(NetworkAclBypass networkAclBypass) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withNetworkAclBypass(networkAclBypass);
        return this;
    }

    /**
     * Get the networkAclBypassResourceIds property: An array that contains the Resource Ids for Network Acl Bypass for
     * the Cosmos DB account.
     * 
     * @return the networkAclBypassResourceIds value.
     */
    public List<String> networkAclBypassResourceIds() {
        return this.innerProperties() == null ? null : this.innerProperties().networkAclBypassResourceIds();
    }

    /**
     * Set the networkAclBypassResourceIds property: An array that contains the Resource Ids for Network Acl Bypass for
     * the Cosmos DB account.
     * 
     * @param networkAclBypassResourceIds the networkAclBypassResourceIds value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withNetworkAclBypassResourceIds(List<String> networkAclBypassResourceIds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withNetworkAclBypassResourceIds(networkAclBypassResourceIds);
        return this;
    }

    /**
     * Get the disableLocalAuth property: Opt-out of local authentication and ensure only MSI and AAD can be used
     * exclusively for authentication.
     * 
     * @return the disableLocalAuth value.
     */
    public Boolean disableLocalAuth() {
        return this.innerProperties() == null ? null : this.innerProperties().disableLocalAuth();
    }

    /**
     * Set the disableLocalAuth property: Opt-out of local authentication and ensure only MSI and AAD can be used
     * exclusively for authentication.
     * 
     * @param disableLocalAuth the disableLocalAuth value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    /**
     * Get the capacity property: The object that represents all properties related to capacity enforcement on an
     * account.
     * 
     * @return the capacity value.
     */
    public Capacity capacity() {
        return this.innerProperties() == null ? null : this.innerProperties().capacity();
    }

    /**
     * Set the capacity property: The object that represents all properties related to capacity enforcement on an
     * account.
     * 
     * @param capacity the capacity value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withCapacity(Capacity capacity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withCapacity(capacity);
        return this;
    }

    /**
     * Get the keysMetadata property: This property is ignored during the update operation, as the metadata is
     * read-only. The object represents the metadata for the Account Keys of the Cosmos DB account.
     * 
     * @return the keysMetadata value.
     */
    public DatabaseAccountKeysMetadata keysMetadata() {
        return this.innerProperties() == null ? null : this.innerProperties().keysMetadata();
    }

    /**
     * Get the enablePartitionMerge property: Flag to indicate enabling/disabling of Partition Merge feature on the
     * account.
     * 
     * @return the enablePartitionMerge value.
     */
    public Boolean enablePartitionMerge() {
        return this.innerProperties() == null ? null : this.innerProperties().enablePartitionMerge();
    }

    /**
     * Set the enablePartitionMerge property: Flag to indicate enabling/disabling of Partition Merge feature on the
     * account.
     * 
     * @param enablePartitionMerge the enablePartitionMerge value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withEnablePartitionMerge(Boolean enablePartitionMerge) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withEnablePartitionMerge(enablePartitionMerge);
        return this;
    }

    /**
     * Get the minimalTlsVersion property: Indicates the minimum allowed Tls version. The default value is Tls 1.2.
     * Cassandra and Mongo APIs only work with Tls 1.2.
     * 
     * @return the minimalTlsVersion value.
     */
    public MinimalTlsVersion minimalTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minimalTlsVersion();
    }

    /**
     * Set the minimalTlsVersion property: Indicates the minimum allowed Tls version. The default value is Tls 1.2.
     * Cassandra and Mongo APIs only work with Tls 1.2.
     * 
     * @param minimalTlsVersion the minimalTlsVersion value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withMinimalTlsVersion(MinimalTlsVersion minimalTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withMinimalTlsVersion(minimalTlsVersion);
        return this;
    }

    /**
     * Get the enableBurstCapacity property: Flag to indicate enabling/disabling of Burst Capacity feature on the
     * account.
     * 
     * @return the enableBurstCapacity value.
     */
    public Boolean enableBurstCapacity() {
        return this.innerProperties() == null ? null : this.innerProperties().enableBurstCapacity();
    }

    /**
     * Set the enableBurstCapacity property: Flag to indicate enabling/disabling of Burst Capacity feature on the
     * account.
     * 
     * @param enableBurstCapacity the enableBurstCapacity value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withEnableBurstCapacity(Boolean enableBurstCapacity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withEnableBurstCapacity(enableBurstCapacity);
        return this;
    }

    /**
     * Get the customerManagedKeyStatus property: Indicates the status of the Customer Managed Key feature on the
     * account. In case there are errors, the property provides troubleshooting guidance.
     * 
     * @return the customerManagedKeyStatus value.
     */
    public String customerManagedKeyStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().customerManagedKeyStatus();
    }

    /**
     * Set the customerManagedKeyStatus property: Indicates the status of the Customer Managed Key feature on the
     * account. In case there are errors, the property provides troubleshooting guidance.
     * 
     * @param customerManagedKeyStatus the customerManagedKeyStatus value to set.
     * @return the DatabaseAccountUpdateParameters object itself.
     */
    public DatabaseAccountUpdateParameters withCustomerManagedKeyStatus(String customerManagedKeyStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountUpdateProperties();
        }
        this.innerProperties().withCustomerManagedKeyStatus(customerManagedKeyStatus);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identity() != null) {
            identity().validate();
        }
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DatabaseAccountUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DatabaseAccountUpdateParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DatabaseAccountUpdateParameters.
     */
    public static DatabaseAccountUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DatabaseAccountUpdateParameters deserializedDatabaseAccountUpdateParameters
                = new DatabaseAccountUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDatabaseAccountUpdateParameters.tags = tags;
                } else if ("location".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateParameters.location = reader.getString();
                } else if ("identity".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateParameters.identity = ManagedServiceIdentity.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateParameters.innerProperties
                        = DatabaseAccountUpdateProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDatabaseAccountUpdateParameters;
        });
    }
}
