// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Connection string for the Cosmos DB account.
 */
@Immutable
public final class DatabaseAccountConnectionString implements JsonSerializable<DatabaseAccountConnectionString> {
    /*
     * Value of the connection string
     */
    private String connectionString;

    /*
     * Description of the connection string
     */
    private String description;

    /*
     * Kind of the connection string key
     */
    private Kind keyKind;

    /*
     * Type of the connection string
     */
    private Type type;

    /**
     * Creates an instance of DatabaseAccountConnectionString class.
     */
    public DatabaseAccountConnectionString() {
    }

    /**
     * Get the connectionString property: Value of the connection string.
     * 
     * @return the connectionString value.
     */
    public String connectionString() {
        return this.connectionString;
    }

    /**
     * Get the description property: Description of the connection string.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Get the keyKind property: Kind of the connection string key.
     * 
     * @return the keyKind value.
     */
    public Kind keyKind() {
        return this.keyKind;
    }

    /**
     * Get the type property: Type of the connection string.
     * 
     * @return the type value.
     */
    public Type type() {
        return this.type;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DatabaseAccountConnectionString from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DatabaseAccountConnectionString if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DatabaseAccountConnectionString.
     */
    public static DatabaseAccountConnectionString fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DatabaseAccountConnectionString deserializedDatabaseAccountConnectionString
                = new DatabaseAccountConnectionString();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("connectionString".equals(fieldName)) {
                    deserializedDatabaseAccountConnectionString.connectionString = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedDatabaseAccountConnectionString.description = reader.getString();
                } else if ("keyKind".equals(fieldName)) {
                    deserializedDatabaseAccountConnectionString.keyKind = Kind.fromString(reader.getString());
                } else if ("type".equals(fieldName)) {
                    deserializedDatabaseAccountConnectionString.type = Type.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDatabaseAccountConnectionString;
        });
    }
}
