// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Specific Gremlin Databases to restore.
 */
@Fluent
public final class GremlinDatabaseRestoreResource implements JsonSerializable<GremlinDatabaseRestoreResource> {
    /*
     * The name of the gremlin database available for restore.
     */
    private String databaseName;

    /*
     * The names of the graphs available for restore.
     */
    private List<String> graphNames;

    /**
     * Creates an instance of GremlinDatabaseRestoreResource class.
     */
    public GremlinDatabaseRestoreResource() {
    }

    /**
     * Get the databaseName property: The name of the gremlin database available for restore.
     * 
     * @return the databaseName value.
     */
    public String databaseName() {
        return this.databaseName;
    }

    /**
     * Set the databaseName property: The name of the gremlin database available for restore.
     * 
     * @param databaseName the databaseName value to set.
     * @return the GremlinDatabaseRestoreResource object itself.
     */
    public GremlinDatabaseRestoreResource withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    /**
     * Get the graphNames property: The names of the graphs available for restore.
     * 
     * @return the graphNames value.
     */
    public List<String> graphNames() {
        return this.graphNames;
    }

    /**
     * Set the graphNames property: The names of the graphs available for restore.
     * 
     * @param graphNames the graphNames value to set.
     * @return the GremlinDatabaseRestoreResource object itself.
     */
    public GremlinDatabaseRestoreResource withGraphNames(List<String> graphNames) {
        this.graphNames = graphNames;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("databaseName", this.databaseName);
        jsonWriter.writeArrayField("graphNames", this.graphNames, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GremlinDatabaseRestoreResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GremlinDatabaseRestoreResource if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GremlinDatabaseRestoreResource.
     */
    public static GremlinDatabaseRestoreResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GremlinDatabaseRestoreResource deserializedGremlinDatabaseRestoreResource
                = new GremlinDatabaseRestoreResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("databaseName".equals(fieldName)) {
                    deserializedGremlinDatabaseRestoreResource.databaseName = reader.getString();
                } else if ("graphNames".equals(fieldName)) {
                    List<String> graphNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedGremlinDatabaseRestoreResource.graphNames = graphNames;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGremlinDatabaseRestoreResource;
        });
    }
}
